/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptorLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ColumnCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.RelationalMappingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CompositeCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListCollectionValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.Model;

public class RelationalLockingColumnsPanel
extends AbstractSubjectPanel {
    RelationalLockingColumnsPanel(PropertyValueModel lockingPolicyHolder, WorkbenchContextHolder contextHolder) {
        super((ValueModel)lockingPolicyHolder, contextHolder);
        this.initializeLayout();
    }

    @Override
    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 1, 1, 1);
        this.add((Component)this.buildColumnLockingColumnsList(), constraints);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private AddRemoveListPanel buildColumnLockingColumnsList() {
        AddRemoveListPanel listPanel = new AddRemoveListPanel(this.getApplicationContext(), this.buildPrimaryKeysAddRemoveAdapter(), this.buildSortedColumnLockingColumnsHolder(), 3, this.resourceRepository().getString("LOCKING_POLICY_SELECTED_FIELDS_LOCKING"), RelationalMappingComponentFactory.buildColumnNodeSelector(this.getWorkbenchContextHolder()));
        listPanel.setBorder(this.buildStandardEmptyBorder());
        listPanel.setCellRenderer(this.buildColumnLockingColumnsListCellRenderer());
        return listPanel;
    }

    private AddRemovePanel.Adapter buildPrimaryKeysAddRemoveAdapter() {
        return new AddRemovePanel.Adapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                listSelectionModel.setSelectedValues(RelationalLockingColumnsPanel.this.addColumnLockingColumns());
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                RelationalLockingColumnsPanel.this.removeColumnLockingColumns(listSelectionModel.getSelectedValues());
            }
        };
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] children = this.getComponents();
        for (int i = 0; i < children.length; ++i) {
            children[i].setEnabled(enabled);
        }
    }

    Object[] addColumnLockingColumns() {
        Object[] columnLockingColumns = new LockingColumnDialog(this.getWorkbenchContext()).promptForPrimaryKeys();
        for (int i = 0; i < columnLockingColumns.length; ++i) {
            ((MWTableDescriptorLockingPolicy)this.relationalDescriptor().getLockingPolicy()).addColumnLockColumn((MWColumn)columnLockingColumns[i]);
        }
        return columnLockingColumns;
    }

    void removeColumnLockingColumns(Object[] lockingColumns) {
        for (int i = 0; i < lockingColumns.length; ++i) {
            ((MWTableDescriptorLockingPolicy)this.relationalDescriptor().getLockingPolicy()).removeColumnLockColumn((MWColumn)lockingColumns[i]);
        }
    }

    private ListValueModel buildSortedColumnLockingColumnsHolder() {
        return new SortedListValueModelAdapter(this.buildNamedColumnLockingColumnsHolder());
    }

    private ListValueModel buildNamedColumnLockingColumnsHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildColumnLockingColumnsHolder(), "qualifiedName", "databaseType");
    }

    private CollectionValueModel buildColumnLockingColumnsHolder() {
        return new CollectionAspectAdapter(this.getSubjectHolder(), "columnLockColumns"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWTableDescriptorLockingPolicy)this.subject).columnLockColumns();
            }
        };
    }

    private ListCellRenderer buildColumnLockingColumnsListCellRenderer() {
        return new AdaptableListCellRenderer(new ColumnCellRendererAdapter(this.resourceRepository()));
    }

    private MWTableDescriptor relationalDescriptor() {
        return ((MWTableDescriptorLockingPolicy)this.getSubjectHolder().getValue()).getOwningTableDescriptor();
    }

    @Override
    protected ValueModel getSubjectHolder() {
        return super.getSubjectHolder();
    }

    public String helpTopicId() {
        return "descriptor.locking.selectedfields";
    }

    private class LockingColumnDialog
    extends AbstractDialog {
        private ListModel lockingColumnsModel;
        private ObjectListSelectionModel lockingColumnsSelectionModel;

        LockingColumnDialog(WorkbenchContext context) {
            super(context);
        }

        @Override
        protected void initialize() {
            super.initialize();
            this.lockingColumnsModel = this.buildPrimaryKeyListAdapter();
            this.lockingColumnsSelectionModel = this.buildLockingColumnsSelectionModel();
            this.setTitle(this.resourceRepository().getString("LOCKING_ADD_REMOVE_DIALOG_TITLE"));
            this.getOKAction().setEnabled(false);
        }

        private ListModel buildPrimaryKeyListAdapter() {
            return new ListModelAdapter(this.buildSortedColumnsHolder());
        }

        private ListValueModel buildSortedColumnsHolder() {
            return new SortedListValueModelAdapter(this.buildAllColumnsCollectionHolder());
        }

        private CollectionValueModel buildAllColumnsCollectionHolder() {
            return new CompositeCollectionValueModel(this.buildSortedTablesHolder()){

                @Override
                protected CollectionValueModel transform(Object value) {
                    return new ListCollectionValueModelAdapter(LockingColumnDialog.this.buildSortedColumnsHolder((MWTable)value));
                }
            };
        }

        private ListValueModel buildSortedTablesHolder() {
            return new SortedListValueModelAdapter(this.buildTableNameAdapter());
        }

        private ListValueModel buildTableNameAdapter() {
            return new ItemPropertyListValueModelAdapter(this.buildTablesHolder(), "qualifiedName");
        }

        private CollectionValueModel buildTablesHolder() {
            return new CollectionAspectAdapter(RelationalLockingColumnsPanel.this.getSubjectHolder()){

                @Override
                protected Iterator getValueFromSubject() {
                    return ((MWTableDescriptorLockingPolicy)this.subject).getOwningTableDescriptor().associatedTables();
                }
            };
        }

        ListValueModel buildSortedColumnsHolder(MWTable table) {
            return new SortedListValueModelAdapter(this.buildColumnNameAdapter(table));
        }

        private ListValueModel buildColumnNameAdapter(MWTable table) {
            return new ItemPropertyListValueModelAdapter((CollectionValueModel)this.buildColumnsHolder(table), "name");
        }

        private CollectionAspectAdapter buildColumnsHolder(MWTable table) {
            return new CollectionAspectAdapter("columns", (Model)table){

                @Override
                protected Iterator getValueFromSubject() {
                    return ((MWTable)this.subject).columns();
                }

                @Override
                protected int sizeFromSubject() {
                    return ((MWTable)this.subject).columnsSize();
                }
            };
        }

        private ObjectListSelectionModel buildLockingColumnsSelectionModel() {
            ObjectListSelectionModel selectionModel = new ObjectListSelectionModel(this.lockingColumnsModel);
            selectionModel.addListSelectionListener(this.buildSelectionListener());
            return selectionModel;
        }

        private ListSelectionListener buildSelectionListener() {
            return new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        LockingColumnDialog.this.selectionChanged();
                    }
                }
            };
        }

        void selectionChanged() {
            this.getOKAction().setEnabled(!this.lockingColumnsSelectionModel.isSelectionEmpty());
        }

        @Override
        protected Component buildMainPanel() {
            JList list = SwingComponentFactory.buildList(this.lockingColumnsModel);
            list.setSelectionModel(this.lockingColumnsSelectionModel);
            list.setSelectionMode(2);
            list.setCellRenderer(this.buildListCellRenderer());
            list.addMouseListener(this.buildListMouseListener());
            return new JScrollPane(list);
        }

        private ListCellRenderer buildListCellRenderer() {
            return new AdaptableListCellRenderer(new ColumnCellRendererAdapter(this.resourceRepository()));
        }

        protected MouseListener buildListMouseListener() {
            return new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        LockingColumnDialog.this.clickOK();
                    }
                }
            };
        }

        @Override
        protected void clickOK() {
            super.clickOK();
        }

        @Override
        protected String helpTopicId() {
            return RelationalLockingColumnsPanel.this.helpTopicId();
        }

        Object[] promptForPrimaryKeys() {
            this.show();
            if (this.wasConfirmed()) {
                return this.lockingColumnsSelectionModel.getSelectedValues();
            }
            return new Object[0];
        }
    }
}

