/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.persistence.tools.workbench.framework.NodeManager;
import org.eclipse.persistence.tools.workbench.framework.OpenException;
import org.eclipse.persistence.tools.workbench.framework.Plugin;
import org.eclipse.persistence.tools.workbench.framework.UnsupportedFileException;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkApplication;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkRootNode;
import org.eclipse.persistence.tools.workbench.framework.internal.RunnableProjectLoader;
import org.eclipse.persistence.tools.workbench.framework.internal.SaveModifiedProjectsDialog;
import org.eclipse.persistence.tools.workbench.framework.internal.WorkbenchWindow;
import org.eclipse.persistence.tools.workbench.uitools.CancelException;
import org.eclipse.persistence.tools.workbench.uitools.PreferencesRecentFilesManager;
import org.eclipse.persistence.tools.workbench.uitools.RecentFilesManager;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.SynchronizedBoolean;
import org.eclipse.persistence.tools.workbench.utility.events.AWTChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.DefaultChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.PluggableValidator;
import org.eclipse.persistence.tools.workbench.utility.node.RunnableValidation;

final class FrameworkNodeManager
extends AbstractNodeModel
implements NodeManager {
    private FrameworkApplication application;
    private TreeNodeValueModel rootNode;
    private Collection projectNodes;
    public static final String PROJECT_NODES_COLLECTION = "projectNodes";
    private Map validationThreads;
    private Map continueValidationThreadFlags;
    private Collection synchronousProjectNodes;
    private boolean projectNodesAreAddedWithSynchronousValidators;
    private RecentFilesManager recentFilesManager;
    private static final String RECENT_FILES_PREFERENCES_NODE = "recent files";
    static final String RECENT_FILES_MAX_SIZE_PREFERENCE = "recent files max size";
    static final int RECENT_FILES_MAX_SIZE_PREFERENCE_DEFAULT = 4;
    private static final String MOST_RECENT_SAVE_LOCATION_PREFERENCE = "recent save location";
    private static final String MOST_RECENT_SAVE_LOCATION_PREFERENCE_DEFAULT = FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();

    FrameworkNodeManager(FrameworkApplication application) {
        super(null);
        this.application = application;
        this.recentFilesManager = this.buildRecentFilesManager();
    }

    protected void initialize() {
        super.initialize();
        this.rootNode = new FrameworkRootNode(this);
        this.projectNodes = new ArrayList();
        this.validationThreads = new HashMap();
        this.continueValidationThreadFlags = new HashMap();
        this.synchronousProjectNodes = new HashBag();
        this.projectNodesAreAddedWithSynchronousValidators = false;
    }

    private RecentFilesManager buildRecentFilesManager() {
        Preferences baseNode = this.application.generalPreferences();
        Preferences recentFilesNode = baseNode.node(RECENT_FILES_PREFERENCES_NODE);
        return new PreferencesRecentFilesManager(recentFilesNode, baseNode, RECENT_FILES_MAX_SIZE_PREFERENCE);
    }

    protected void checkParent(Node parent) {
        if (parent != null) {
            throw new IllegalArgumentException(ClassTools.shortClassNameForObject((Object)this) + " should not have a parent");
        }
    }

    @Override
    public void addProjectNode(ApplicationNode projectNode) {
        this.addItemToCollection(projectNode, this.projectNodes, PROJECT_NODES_COLLECTION);
        ((Node)projectNode.getValue()).setChangeNotifier(AWTChangeNotifier.instance());
        if (this.projectNodesAreAddedWithSynchronousValidators) {
            this.installSynchronousValidatorOn(projectNode);
        } else {
            this.installAsynchronousValidatorOn(projectNode);
        }
    }

    private void installAsynchronousValidatorOn(ApplicationNode projectNode) {
        Node node = (Node)projectNode.getValue();
        SynchronizedBoolean validateFlag = new SynchronizedBoolean(true);
        node.setValidator(PluggableValidator.buildAsynchronousValidator((SynchronizedBoolean)validateFlag));
        SynchronizedBoolean continueFlag = new SynchronizedBoolean(true);
        this.continueValidationThreadFlags.put(projectNode, continueFlag);
        Thread validationThread = new Thread((Runnable)new RunnableValidation(node, validateFlag, continueFlag, this.logger(), Level.WARNING, "VALIDATION_EXCEPTION"), "Validation Thread : " + node.displayString());
        validationThread.setPriority(1);
        this.validationThreads.put(projectNode, validationThread);
        validationThread.start();
    }

    private void installSynchronousValidatorOn(ApplicationNode projectNode) {
        Node node = (Node)projectNode.getValue();
        node.setValidator(PluggableValidator.buildSynchronousValidator((Node)node));
        this.synchronousProjectNodes.add(projectNode);
    }

    @Override
    public void removeProjectNode(ApplicationNode projectNode) {
        this.removeItemFromCollection(projectNode, this.projectNodes, PROJECT_NODES_COLLECTION);
        if (!this.synchronousProjectNodes.remove(projectNode)) {
            SynchronizedBoolean continueFlag = (SynchronizedBoolean)this.continueValidationThreadFlags.remove(projectNode);
            continueFlag.setFalse();
            Thread validationThread = (Thread)this.validationThreads.remove(projectNode);
            validationThread.interrupt();
        }
    }

    @Override
    public ApplicationNode[] projectNodesFor(Plugin plugin) {
        ArrayList<ApplicationNode> nodes = new ArrayList<ApplicationNode>();
        Iterator stream = this.projectNodes();
        while (stream.hasNext()) {
            ApplicationNode node = (ApplicationNode)stream.next();
            if (node.getPlugin() != plugin) continue;
            nodes.add(node);
        }
        return nodes.toArray(new ApplicationNode[nodes.size()]);
    }

    @Override
    public TreeNodeValueModel getRootNode() {
        return this.rootNode;
    }

    public String displayString() {
        return null;
    }

    public ChangeNotifier getChangeNotifier() {
        return DefaultChangeNotifier.instance();
    }

    public Node.Validator getValidator() {
        return Node.NULL_VALIDATOR;
    }

    Iterator projectNodes() {
        return this.projectNodes.iterator();
    }

    int projectNodesSize() {
        return this.projectNodes.size();
    }

    RecentFilesManager getRecentFilesManager() {
        return this.recentFilesManager;
    }

    boolean projectNodesAreAddedWithSynchronousValidators() {
        return this.projectNodesAreAddedWithSynchronousValidators;
    }

    boolean toggleAddProjectNodesWithSynchronousValidators() {
        this.projectNodesAreAddedWithSynchronousValidators = !this.projectNodesAreAddedWithSynchronousValidators;
        return this.projectNodesAreAddedWithSynchronousValidators;
    }

    private Logger logger() {
        return this.application.getLogger();
    }

    void open(File file, WorkbenchContext context) {
        ApplicationNode projectNode = this.projectNodeFor(file);
        if (projectNode == null) {
            this.openNew(file, context);
            return;
        }
        if (projectNode.isDirty() && this.userWantsToRevert(file, context)) {
            context.getNavigatorSelectionModel().pushExpansionState();
            this.removeProjectNode(projectNode);
            this.openNew(file, context);
            context.getNavigatorSelectionModel().popAndRestoreExpansionState();
        } else {
            context.getNavigatorSelectionModel().setSelectedNode(projectNode);
        }
    }

    private ApplicationNode projectNodeFor(File file) {
        Iterator stream = this.projectNodes();
        while (stream.hasNext()) {
            ApplicationNode projectNode = (ApplicationNode)stream.next();
            File saveLocation = projectNode.saveFile();
            if (saveLocation == null || !saveLocation.equals(file)) continue;
            return projectNode;
        }
        return null;
    }

    private void openNew(File file, WorkbenchContext context) {
        Thread thread = new Thread((Runnable)new RunnableProjectLoader(this, file, context), "Project Loader");
        thread.setPriority(5);
        thread.start();
    }

    synchronized ApplicationNode openCallback(File file, WorkbenchContext context) throws UnsupportedFileException, OpenException {
        return this.application.open(file, context);
    }

    void addProjectNodeCallback(ApplicationNode node, File file, WorkbenchContext context) {
        this.addProjectNode(node);
        context.getNavigatorSelectionModel().expandNode(node);
        context.getNavigatorSelectionModel().setSelectedNode(node);
        this.recentFilesManager.setMostRecentFile(file);
    }

    private boolean userWantsToRevert(File file, WorkbenchContext context) {
        int option = JOptionPane.showConfirmDialog(context.getCurrentWindow(), context.getApplicationContext().getResourceRepository().getString("REVERT_TO_SAVED.message", file), context.getApplicationContext().getResourceRepository().getString("REVERT_TO_SAVED.title"), 0);
        return option == 0;
    }

    void exit(WorkbenchContext context) {
        ArrayList nodes = new ArrayList(this.projectNodes);
        this.application.saveTreeExpansionStates();
        if (this.closeAll(context)) {
            this.saveProjectsState(nodes.iterator());
            nodes = null;
            this.application.exit();
        }
    }

    private void saveProjectsState(Iterator nodes) {
        Preferences projectPreferences = this.application.generalPreferences().node("projects");
        try {
            projectPreferences.clear();
        }
        catch (BackingStoreException e) {
            // empty catch block
        }
        int i = 0;
        while (nodes.hasNext()) {
            ApplicationNode projectNode = (ApplicationNode)nodes.next();
            if (projectNode.saveFile() == null) continue;
            projectPreferences.put(String.valueOf(i++), projectNode.saveFile().getAbsolutePath());
        }
    }

    protected void restoreProjectsState(WorkbenchWindow window, Preferences windowPreferences) {
        String[] keys;
        Preferences projectPreferences = this.application.generalPreferences().node("projects");
        try {
            keys = projectPreferences.keys();
        }
        catch (BackingStoreException e) {
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            File projectFile;
            String projectLocation = projectPreferences.get(keys[i], null);
            if (projectLocation == null || !(projectFile = new File(projectLocation)).exists()) continue;
            this.open(projectFile, window.getContext());
        }
        window.restoreTreeExpansionState(windowPreferences);
    }

    boolean closeAll(WorkbenchContext context) {
        return this.close(this.projectNodes.toArray(new ApplicationNode[this.projectNodes.size()]), context);
    }

    boolean close(ApplicationNode[] nodes, WorkbenchContext context) {
        Collection dirtyNodesToSave;
        try {
            dirtyNodesToSave = this.promptToSave(this.dirtyNodesFrom(nodes), context);
        }
        catch (CancelException e) {
            return false;
        }
        Iterator stream = dirtyNodesToSave.iterator();
        while (stream.hasNext()) {
            if (this.save((ApplicationNode)stream.next(), context)) continue;
            return false;
        }
        int i = nodes.length;
        while (i-- > 0) {
            this.removeProjectNode(nodes[i]);
        }
        return true;
    }

    private Collection dirtyNodesFrom(ApplicationNode[] nodes) {
        ArrayList<ApplicationNode> dirtyNodes = new ArrayList<ApplicationNode>(nodes.length);
        int i = nodes.length;
        while (i-- > 0) {
            ApplicationNode node = nodes[i];
            if (!node.isDirty()) continue;
            dirtyNodes.add(node);
        }
        return dirtyNodes;
    }

    private Collection promptToSave(Collection dirtyNodes, WorkbenchContext context) {
        if (dirtyNodes.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        SaveModifiedProjectsDialog dialog = new SaveModifiedProjectsDialog(context, dirtyNodes);
        dialog.show();
        if (dialog.wasCanceled()) {
            throw new CancelException();
        }
        return dialog.selectedNodes();
    }

    @Override
    public boolean save(ApplicationNode node, WorkbenchContext workbenchContext) {
        boolean saved = node.save(this.getMostRecentSaveDirectory(), workbenchContext);
        if (saved) {
            this.recentFilesManager.setMostRecentFile(node.getProjectRoot().saveFile());
            this.setMostRecentSaveDirectory(node.getProjectRoot().saveFile());
        }
        return saved;
    }

    private File getMostRecentSaveDirectory() {
        return new File(this.application.generalPreferences().get(MOST_RECENT_SAVE_LOCATION_PREFERENCE, MOST_RECENT_SAVE_LOCATION_PREFERENCE_DEFAULT));
    }

    private void setMostRecentSaveDirectory(File saveLocation) {
        this.application.generalPreferences().put(MOST_RECENT_SAVE_LOCATION_PREFERENCE, saveLocation.getParentFile().getAbsolutePath());
    }

    boolean saveAs(ApplicationNode node, WorkbenchContext context) {
        boolean saved = node.saveAs(this.getMostRecentSaveDirectory(), context);
        if (saved) {
            this.recentFilesManager.setMostRecentFile(node.getProjectRoot().saveFile());
            this.setMostRecentSaveDirectory(node.getProjectRoot().saveFile());
        }
        return saved;
    }

    void saveAll(WorkbenchContext workbenchContext) {
        Iterator stream = this.projectNodes();
        while (stream.hasNext()) {
            ApplicationNode node = (ApplicationNode)stream.next();
            if (!node.isDirty()) continue;
            this.save(node, workbenchContext);
        }
    }
}

