/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.ddlparser;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.List;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.NumericType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCollectionType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLPackageType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLRecordType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLType;
import org.eclipse.persistence.tools.oracleddl.metadata.SizedType;
import org.eclipse.persistence.tools.oracleddl.metadata.VarChar2Type;
import org.eclipse.persistence.tools.oracleddl.parser.DDLParser;
import org.eclipse.persistence.tools.oracleddl.parser.ParseException;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypesRepository;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PackageDDLTestSuite {
    static final String CREATE_PACKAGE_PREFIX = "CREATE PACKAGE ";
    static DDLParser parser = null;
    static final String EMPTY_PACKAGE = "EMPTY_PACKAGE";
    static final String CREATE_EMPTY_PACKAGE = "CREATE PACKAGE EMPTY_PACKAGE AS END EMPTY_PACKAGE;";
    static final String SIMPLE_PACKAGE = "SIMPLE_PACKAGE";
    static final String SIMPLE_TYPE = "EREC";
    static final String FIELD1_NAME = "FLAG";
    static final String FIELD1_TYPE = "PLS_INTEGER";
    static final String FIELD2_NAME = "EMPNO";
    static final String FIELD2_TYPE = "NUMERIC";
    static final String FIELD3_NAME = "ENAME";
    static final String FIELD3_TYPE = "VARCHAR2";
    static final String FIELD4_NAME = "JOB";
    static final String FIELD4_TYPE = "VARCHAR2";
    static final String CREATE_SIMPLE_PACKAGE = "CREATE PACKAGE SIMPLE_PACKAGE AS \nTYPE EREC IS RECORD (\nFLAG PLS_INTEGER,\nEMPNO NUMERIC,\nENAME VARCHAR2,\nJOB VARCHAR2\n);\nEND SIMPLE_PACKAGE;";
    static final String NPACKAGE = "PACKAGE_WITH_NESTED_RECORDS";
    static final String NTYPE1 = "ADDRESS";
    static final String NT1_FIELD_TYPE = "VARCHAR2";
    static final String NT1_FIELD1_NAME = "HOUSE_NUMBER";
    static final String NT1_FIELD2_NAME = "STREET";
    static final String NT1_FIELD3_NAME = "PHONE";
    static final String NT1_FIELD4_NAME = "REGION";
    static final String NT1_FIELD5_NAME = "POSTAL_CODE";
    static final String NT1_FIELD6_NAME = "COUNTRY";
    static final String NTYPE2 = "CONTACT";
    static final String NT2_FIELD_TYPE = "ADDRESS";
    static final String NT2_FIELD1_NAME = "HOME";
    static final String NT2_FIELD2_NAME = "BUSINESS";
    static final String CREATE_NPACKAGE = "CREATE PACKAGE PACKAGE_WITH_NESTED_RECORDS AS \nTYPE ADDRESS IS RECORD (\nHOUSE_NUMBER VARCHAR2,\nSTREET VARCHAR2,\nPHONE VARCHAR2,\nREGION VARCHAR2,\nPOSTAL_CODE VARCHAR2,\nCOUNTRY VARCHAR2\n);\nTYPE CONTACT IS RECORD (\nHOME ADDRESS,\nBUSINESS ADDRESS\n);\nEND PACKAGE_WITH_NESTED_RECORDS;";
    static final String PACKAGE_WCOLLECTION = "PACKAGE_WCOLLECTION";
    static final String PACKAGE_WCOLLECTION_NAME = "VCHAR_ARRAY";
    static final String PACKAGE_WCOLLECTION_TYPE = "VARCHAR2(20)";
    static final String PACKAGE_WCOLLECTION_INDEXBY = "BINARY_INTEGER";
    static final String CREATE_PACKAGE_WCOLLECTION = "CREATE PACKAGE PACKAGE_WCOLLECTION AS \nTYPE VCHAR_ARRAY IS TABLE OF VARCHAR2(20) INDEX BY BINARY_INTEGER;\nEND PACKAGE_WCOLLECTION;";
    static final String PACKAGE_WCOLLECTION_WRECORD = "PACKAGE_WCOLLECTION_WRECORD";
    static final String PACKAGE_WCOLLECTION_WRECORD_TYPE1 = "BOOK_TYPE";
    static final String PACKAGE_WCOLLECTION_WRECORD_TYPE1_FIELD1_NAME = "ISBN";
    static final String PACKAGE_WCOLLECTION_WRECORD_TYPE1_FIELD1_TYPE = "VARCHAR2(20)";
    static final String PACKAGE_WCOLLECTION_WRECORD_TYPE1_FIELD2_NAME = "TITLE";
    static final String PACKAGE_WCOLLECTION_WRECORD_TYPE1_FIELD2_TYPE = "VARCHAR2(2000)";
    static final String PACKAGE_WCOLLECTION_WRECORD_TYPE1_FIELD3_NAME = "AUTHOR";
    static final String PACKAGE_WCOLLECTION_WRECORD_TYPE1_FIELD3_TYPE = "VARCHAR2(2000)";
    static final String PACKAGE_WCOLLECTION_WRECORD_TYPE1_FIELD4_NAME = "PUBLISHER";
    static final String PACKAGE_WCOLLECTION_WRECORD_TYPE1_FIELD4_TYPE = "VARCHAR2";
    static final String PACKAGE_WCOLLECTION_WRECORD_TYPE1_FIELD5_NAME = "PUBLISHED_ON";
    static final String PACKAGE_WCOLLECTION_WRECORD_TYPE1_FIELD5_TYPE = "DATE";
    static final String PACKAGE_WCOLLECTION_WRECORD_TYPE2 = "BOOKS_TAB";
    static final String CREATE_PACKAGE_WCOLLECTION_WRECORD = "CREATE PACKAGE PACKAGE_WCOLLECTION_WRECORD AS \nTYPE BOOK_TYPE IS RECORD (\nISBN VARCHAR2(20),\nTITLE VARCHAR2(2000),\nAUTHOR VARCHAR2(2000),\nPUBLISHER VARCHAR2,\nPUBLISHED_ON DATE\n);\nTYPE BOOKS_TAB IS TABLE OF BOOK_TYPE;\nEND PACKAGE_WCOLLECTION_WRECORD;";
    static final String PACKAGE_WDEEPLY_NESTED_TYPES = "PACKAGE_WDEEPLY_NESTED_TYPES";
    static final String PACKAGE_WDEEPLY_NESTED_TYPE1 = "TBL1";
    static final String PACKAGE_WDEEPLY_NESTED_TYPE1_NESTED_TYPE = "VARCHAR2(111)";
    static final String PACKAGE_WDEEPLY_NESTED_TYPE1_INDEX_TYPE = "BINARY_INTEGER";
    static final String PACKAGE_WDEEPLY_NESTED_TYPE2 = "TBL2";
    static final String PACKAGE_WDEEPLY_NESTED_TYPE2_NESTED_TYPE = "NUMBER";
    static final String PACKAGE_WDEEPLY_NESTED_TYPE2_INDEX_TYPE = "BINARY_INTEGER";
    static final String PACKAGE_WDEEPLY_NESTED_TYPE3 = "ARECORD";
    static final String PACKAGE_WDEEPLY_NESTED_TYPE3_FIELD1_NAME = "T1";
    static final String PACKAGE_WDEEPLY_NESTED_TYPE3_FIELD1_TYPE = "TBL1";
    static final String PACKAGE_WDEEPLY_NESTED_TYPE3_FIELD2_NAME = "T2";
    static final String PACKAGE_WDEEPLY_NESTED_TYPE3_FIELD2_TYPE = "TBL2";
    static final String PACKAGE_WDEEPLY_NESTED_TYPE3_FIELD3_NAME = "T3";
    static final String PACKAGE_WDEEPLY_NESTED_TYPE3_FIELD3_TYPE = "BOOLEAN";
    static final String PACKAGE_WDEEPLY_NESTED_TYPE4 = "TBL3";
    static final String PACKAGE_WDEEPLY_NESTED_TYPE4_NESTED_TYPE = "ARECORD";
    static final String PACKAGE_WDEEPLY_NESTED_TYPE4_INDEX_TYPE = "PLS_INTEGER";
    static final String PACKAGE_WDEEPLY_NESTED_TYPE5 = "TBL4";
    static final String PACKAGE_WDEEPLY_NESTED_TYPE5_NESTED_TYPE = "TBL2";
    static final String PACKAGE_WDEEPLY_NESTED_TYPE5_INDEX_TYPE = "PLS_INTEGER";
    static final String CREATE_PACKAGE_WDEEPLY_NESTED_TYPES = "CREATE PACKAGE PACKAGE_WDEEPLY_NESTED_TYPES AS \nTYPE TBL1 IS TABLE OF VARCHAR2(111) INDEX BY BINARY_INTEGER;\nTYPE TBL2 IS TABLE OF NUMBER INDEX BY BINARY_INTEGER;\nTYPE ARECORD IS RECORD (\nT1 TBL1,\nT2 TBL2,\nT3 BOOLEAN\n);\nTYPE TBL3 IS TABLE OF ARECORD INDEX BY PLS_INTEGER;\nTYPE TBL4 IS TABLE OF TBL2 INDEX BY PLS_INTEGER;\nEND PACKAGE_WDEEPLY_NESTED_TYPES;";
    static final String PACKAGE_W_KEYWORDS = "ZONE";
    static final String CREATE_PACKAGE_W_KEYWORDS = "CREATE PACKAGE ZONE AS \nTYPE YEAR IS TABLE OF VARCHAR2(111) INDEX BY BINARY_INTEGER;END ZONE;";

    @BeforeClass
    public static void setUp() {
        parser = new DDLParser(new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        });
        parser.setTypesRepository(new DatabaseTypesRepository());
    }

    @Test
    public void testEmptyPackage() {
        parser.ReInit(new StringReader(CREATE_EMPTY_PACKAGE));
        boolean worked = true;
        PLSQLPackageType packageType = null;
        try {
            packageType = parser.parsePLSQLPackage();
        }
        catch (ParseException pe) {
            worked = false;
        }
        Assert.assertTrue((String)"empty package should parse", (boolean)worked);
        Assert.assertEquals((String)"empty package wrong name", (Object)packageType.getPackageName(), (Object)EMPTY_PACKAGE);
        Assert.assertTrue((String)"empty package should have no procedures", (boolean)packageType.getProcedures().isEmpty());
        Assert.assertTrue((String)"empty package should have no types", (boolean)packageType.getTypes().isEmpty());
    }

    @Test
    public void testSimplePackage() {
        parser.ReInit(new StringReader(CREATE_SIMPLE_PACKAGE));
        boolean worked = true;
        PLSQLPackageType packageType = null;
        try {
            packageType = parser.parsePLSQLPackage();
        }
        catch (ParseException pe) {
            worked = false;
        }
        Assert.assertTrue((String)"simple package should parse", (boolean)worked);
        Assert.assertEquals((String)"simple package has wrong name", (Object)packageType.getPackageName(), (Object)SIMPLE_PACKAGE);
        Assert.assertTrue((String)"simple package should have no procedures", (boolean)packageType.getProcedures().isEmpty());
        Assert.assertFalse((String)"simple package should have types", (boolean)packageType.getTypes().isEmpty());
        Assert.assertEquals((String)"simple package should have exactly 1 type", (long)1L, (long)packageType.getTypes().size());
        PLSQLType type = packageType.getTypes().get(0);
        Assert.assertEquals((String)"type has wrong name", (Object)SIMPLE_TYPE, (Object)type.getTypeName());
        List<FieldType> fields = ((PLSQLRecordType)type).getFields();
        Assert.assertEquals((String)"type field1 has wrong name", (Object)FIELD1_NAME, (Object)fields.get(0).getFieldName());
        Assert.assertEquals((String)"type field1 has wrong type", (Object)"PLS_INTEGER", (Object)fields.get(0).getTypeName());
        Assert.assertEquals((String)"type field2 has wrong name", (Object)FIELD2_NAME, (Object)fields.get(1).getFieldName());
        Assert.assertEquals((String)"type field1 has wrong type", (Object)FIELD2_TYPE, (Object)fields.get(1).getTypeName());
        Assert.assertEquals((String)"type field3 has wrong name", (Object)FIELD3_NAME, (Object)fields.get(2).getFieldName());
        Assert.assertEquals((String)"type field1 has wrong type", (Object)"VARCHAR2", (Object)fields.get(2).getTypeName());
        Assert.assertEquals((String)"type field4 has wrong name", (Object)FIELD4_NAME, (Object)fields.get(3).getFieldName());
        Assert.assertEquals((String)"type field4 has wrong type", (Object)"VARCHAR2", (Object)fields.get(3).getTypeName());
    }

    @Test
    public void testPackageWithNestedRecords() {
        parser.ReInit(new StringReader(CREATE_NPACKAGE));
        boolean worked = true;
        PLSQLPackageType packageType = null;
        try {
            packageType = parser.parsePLSQLPackage();
        }
        catch (ParseException pe) {
            worked = false;
        }
        Assert.assertTrue((String)"npackage should parse", (boolean)worked);
        Assert.assertEquals((String)"npackage has wrong name", (Object)packageType.getPackageName(), (Object)NPACKAGE);
        Assert.assertTrue((String)"npackage should have no procedures", (boolean)packageType.getProcedures().isEmpty());
        Assert.assertFalse((String)"npackage should have types", (boolean)packageType.getTypes().isEmpty());
        Assert.assertEquals((String)"npackage should have exactly 2 types", (long)2L, (long)packageType.getTypes().size());
        PLSQLType ntype1 = packageType.getTypes().get(0);
        Assert.assertEquals((String)"ntype1 has wrong name", (Object)"ADDRESS", (Object)ntype1.getTypeName());
        List<FieldType> fields = ((PLSQLRecordType)ntype1).getFields();
        Assert.assertEquals((String)"ntype1 field1 has wrong name", (Object)NT1_FIELD1_NAME, (Object)fields.get(0).getFieldName());
        Assert.assertEquals((String)"ntype1 field1 has wrong type", (Object)"VARCHAR2", (Object)fields.get(0).getTypeName());
        Assert.assertEquals((String)"ntype1 field2 has wrong name", (Object)NT1_FIELD2_NAME, (Object)fields.get(1).getFieldName());
        Assert.assertEquals((String)"ntype1 field1 has wrong type", (Object)"VARCHAR2", (Object)fields.get(1).getTypeName());
        Assert.assertEquals((String)"ntype1 field3 has wrong name", (Object)NT1_FIELD3_NAME, (Object)fields.get(2).getFieldName());
        Assert.assertEquals((String)"ntype1 field1 has wrong type", (Object)"VARCHAR2", (Object)fields.get(2).getTypeName());
        Assert.assertEquals((String)"ntype1 field4 has wrong name", (Object)NT1_FIELD4_NAME, (Object)fields.get(3).getFieldName());
        Assert.assertEquals((String)"ntype1 field4 has wrong type", (Object)"VARCHAR2", (Object)fields.get(3).getTypeName());
        PLSQLType ntype2 = packageType.getTypes().get(1);
        Assert.assertEquals((String)"ntype2 has wrong name", (Object)NTYPE2, (Object)ntype2.getTypeName());
        fields = ((PLSQLRecordType)ntype2).getFields();
        Assert.assertEquals((String)"ntype2 field1 has wrong name", (Object)NT2_FIELD1_NAME, (Object)fields.get(0).getFieldName());
        Assert.assertEquals((String)"ntype2 field1 has wrong type", (Object)"ADDRESS", (Object)fields.get(0).getTypeName());
        Assert.assertEquals((String)"ntype2 field2 has wrong name", (Object)NT2_FIELD2_NAME, (Object)fields.get(1).getFieldName());
        Assert.assertEquals((String)"ntype2 field1 has wrong type", (Object)"ADDRESS", (Object)fields.get(1).getTypeName());
    }

    @Test
    public void testPackageWithCollection() {
        parser.ReInit(new StringReader(CREATE_PACKAGE_WCOLLECTION));
        boolean worked = true;
        PLSQLPackageType packageType = null;
        try {
            packageType = parser.parsePLSQLPackage();
        }
        catch (ParseException pe) {
            worked = false;
        }
        Assert.assertTrue((String)"package with collection should parse", (boolean)worked);
        Assert.assertEquals((String)"package with collection has wrong name", (Object)packageType.getPackageName(), (Object)PACKAGE_WCOLLECTION);
        Assert.assertTrue((String)"package with collection should have no procedures", (boolean)packageType.getProcedures().isEmpty());
        Assert.assertFalse((String)"package with collection should have types", (boolean)packageType.getTypes().isEmpty());
        Assert.assertEquals((String)"package with collection should have exactly 1 type", (long)1L, (long)packageType.getTypes().size());
        PLSQLType t1 = packageType.getTypes().get(0);
        Assert.assertEquals((String)"collection type1 has wrong name", (Object)PACKAGE_WCOLLECTION_NAME, (Object)t1.getTypeName());
        PLSQLCollectionType collType = (PLSQLCollectionType)t1;
        Assert.assertTrue((String)"nestedType should be associative", (boolean)collType.isIndexed());
        DatabaseType nestedType = collType.getEnclosedType();
        Assert.assertEquals((String)"nestedType has wrong name", (Object)new VarChar2Type().getTypeName(), (Object)nestedType.getTypeName());
        VarChar2Type varcharNestedType = (VarChar2Type)nestedType;
        Assert.assertEquals((String)"nestedType has wrong size", (long)20L, (long)varcharNestedType.getSize());
    }

    @Test
    public void testPackageWithCollectionWithNestedRecord() {
        parser.ReInit(new StringReader(CREATE_PACKAGE_WCOLLECTION_WRECORD));
        boolean worked = true;
        PLSQLPackageType packageType = null;
        try {
            packageType = parser.parsePLSQLPackage();
        }
        catch (ParseException pe) {
            worked = false;
        }
        Assert.assertTrue((String)"package with collection containing record should parse", (boolean)worked);
        Assert.assertEquals((String)"package with collection containing record has wrong name", (Object)packageType.getPackageName(), (Object)PACKAGE_WCOLLECTION_WRECORD);
        Assert.assertTrue((String)"package with collection containing record should have no procedures", (boolean)packageType.getProcedures().isEmpty());
        Assert.assertFalse((String)"package with collection containing record should have types", (boolean)packageType.getTypes().isEmpty());
        Assert.assertEquals((String)"package with collection containing record should have exactly 2 types", (long)2L, (long)packageType.getTypes().size());
        PLSQLType t1 = packageType.getTypes().get(0);
        Assert.assertEquals((String)"package with collection containing record type1 has wrong name", (Object)PACKAGE_WCOLLECTION_WRECORD_TYPE1, (Object)t1.getTypeName());
        PLSQLRecordType t1Rec = (PLSQLRecordType)t1;
        List<FieldType> fields = t1Rec.getFields();
        Assert.assertEquals((String)"package with collection containing record type1 field1 has wrong name", (Object)PACKAGE_WCOLLECTION_WRECORD_TYPE1_FIELD1_NAME, (Object)fields.get(0).getFieldName());
        Assert.assertEquals((String)"package with collection containing record type1 field1 has wrong type", (Object)new VarChar2Type().getTypeName(), (Object)fields.get(0).getTypeName());
        Assert.assertEquals((String)"package with collection containing record type1 field1 has wrong size", (long)20L, (long)((SizedType)fields.get(0).getEnclosedType()).getSize());
        Assert.assertEquals((String)"package with collection containing record type1 field2 has wrong name", (Object)PACKAGE_WCOLLECTION_WRECORD_TYPE1_FIELD2_NAME, (Object)fields.get(1).getFieldName());
        Assert.assertEquals((String)"package with collection containing record type1 field2 has wrong type", (Object)new VarChar2Type().getTypeName(), (Object)fields.get(1).getTypeName());
        Assert.assertEquals((String)"package with collection containing record type1 field2 has wrong size", (long)2000L, (long)((SizedType)fields.get(1).getEnclosedType()).getSize());
        Assert.assertEquals((String)"package with collection containing record type1 field3 has wrong name", (Object)PACKAGE_WCOLLECTION_WRECORD_TYPE1_FIELD3_NAME, (Object)fields.get(2).getFieldName());
        Assert.assertEquals((String)"package with collection containing record type1 field3 has wrong type", (Object)new VarChar2Type().getTypeName(), (Object)fields.get(2).getTypeName());
        Assert.assertEquals((String)"package with collection containing record type1 field3 has wrong size", (long)2000L, (long)((SizedType)fields.get(2).getEnclosedType()).getSize());
        Assert.assertEquals((String)"package with collection containing record type1 field4 has wrong name", (Object)PACKAGE_WCOLLECTION_WRECORD_TYPE1_FIELD4_NAME, (Object)fields.get(3).getFieldName());
        Assert.assertEquals((String)"package with collection containing record type1 field4 has wrong type", (Object)"VARCHAR2", (Object)fields.get(3).getTypeName());
        Assert.assertEquals((String)"package with collection containing record type1 field5 has wrong name", (Object)PACKAGE_WCOLLECTION_WRECORD_TYPE1_FIELD5_NAME, (Object)fields.get(4).getFieldName());
        Assert.assertEquals((String)"package with collection containing record type1 field5 has wrong type", (Object)PACKAGE_WCOLLECTION_WRECORD_TYPE1_FIELD5_TYPE, (Object)fields.get(4).getTypeName());
        PLSQLType t2 = packageType.getTypes().get(1);
        Assert.assertEquals((String)"package with collection containing record type2 has wrong name", (Object)PACKAGE_WCOLLECTION_WRECORD_TYPE2, (Object)t2.getTypeName());
        PLSQLCollectionType collT2 = (PLSQLCollectionType)t2;
        Assert.assertFalse((String)"package with collection containing record type2 nestedType should not be associative", (boolean)collT2.isIndexed());
        DatabaseType nestedType = collT2.getEnclosedType();
        Assert.assertEquals((String)"package with collection containing record type2 nestedType has wrong name", (Object)PACKAGE_WCOLLECTION_WRECORD_TYPE1, (Object)nestedType.getTypeName());
        Assert.assertSame((String)"package with collection containing record type2 nestedType wrong instance", (Object)nestedType, (Object)t1Rec);
    }

    @Test
    public void testPackageWithDeeplyNestedTypes() {
        parser.ReInit(new StringReader(CREATE_PACKAGE_WDEEPLY_NESTED_TYPES));
        boolean worked = true;
        PLSQLPackageType packageType = null;
        try {
            packageType = parser.parsePLSQLPackage();
        }
        catch (ParseException pe) {
            worked = false;
        }
        Assert.assertTrue((String)"package with deeply nested types should parse", (boolean)worked);
        Assert.assertEquals((String)"package with deeply nested types has wrong name", (Object)packageType.getPackageName(), (Object)PACKAGE_WDEEPLY_NESTED_TYPES);
        Assert.assertTrue((String)"package with deeply nested types should have no procedures", (boolean)packageType.getProcedures().isEmpty());
        Assert.assertFalse((String)"package with deeply nested types should have types", (boolean)packageType.getTypes().isEmpty());
        Assert.assertEquals((String)"package with deeply nested types should have exactly 5 types", (long)5L, (long)packageType.getTypes().size());
        PLSQLType t1 = packageType.getTypes().get(0);
        Assert.assertEquals((String)"package with deeply nested types type1 has wrong name", (Object)"TBL1", (Object)t1.getTypeName());
        PLSQLCollectionType collT1 = (PLSQLCollectionType)t1;
        Assert.assertTrue((String)"package with deeply nested types type1 nestedType should be associative", (boolean)collT1.isIndexed());
        DatabaseType nestedType = collT1.getEnclosedType();
        Assert.assertEquals((String)"package with deeply nested types type1 nestedType has wrong name", (Object)new VarChar2Type().getTypeName(), (Object)nestedType.getTypeName());
        Assert.assertEquals((String)"package with deeply nested types type1 nestedType has wrong size", (long)111L, (long)((SizedType)nestedType).getSize());
        PLSQLType t2 = packageType.getTypes().get(1);
        Assert.assertEquals((String)"package with deeply nested types type2 has wrong name", (Object)"TBL2", (Object)t2.getTypeName());
        PLSQLCollectionType collT2 = (PLSQLCollectionType)t2;
        Assert.assertTrue((String)"package with deeply nested types type2 nestedType should be associative", (boolean)collT2.isIndexed());
        nestedType = collT2.getEnclosedType();
        Assert.assertEquals((String)"package with deeply nested types type2 nestedType has wrong name", (Object)new NumericType().getTypeName(), (Object)nestedType.getTypeName());
        PLSQLType t3 = packageType.getTypes().get(2);
        Assert.assertEquals((String)"package with deeply nested types type3 has wrong name", (Object)"ARECORD", (Object)t3.getTypeName());
        PLSQLRecordType t3Rec = (PLSQLRecordType)t3;
        List<FieldType> fields = t3Rec.getFields();
        Assert.assertEquals((String)"package with deeply nested types type3 field1 has wrong name", (Object)PACKAGE_WDEEPLY_NESTED_TYPE3_FIELD1_NAME, (Object)fields.get(0).getFieldName());
        Assert.assertEquals((String)"package with deeply nested types type3 field1 has wrong type", (Object)"TBL1", (Object)fields.get(0).getTypeName());
        Assert.assertEquals((String)"package with deeply nested types type3 field2 has wrong name", (Object)PACKAGE_WDEEPLY_NESTED_TYPE3_FIELD2_NAME, (Object)fields.get(1).getFieldName());
        Assert.assertEquals((String)"package with deeply nested types type3 field2 has wrong type", (Object)"TBL2", (Object)fields.get(1).getTypeName());
        Assert.assertEquals((String)"package with deeply nested types type3 field2 has wrong name", (Object)PACKAGE_WDEEPLY_NESTED_TYPE3_FIELD3_NAME, (Object)fields.get(2).getFieldName());
        Assert.assertEquals((String)"package with deeply nested types type3 field2 has wrong type", (Object)PACKAGE_WDEEPLY_NESTED_TYPE3_FIELD3_TYPE, (Object)fields.get(2).getTypeName());
    }

    @Test
    public void testPackage_With_Keyword() {
        parser.ReInit(new StringReader(CREATE_PACKAGE_W_KEYWORDS));
        boolean worked = true;
        PLSQLPackageType packageType = null;
        try {
            packageType = parser.parsePLSQLPackage();
        }
        catch (ParseException pe) {
            worked = false;
        }
        Assert.assertTrue((String)"package with keywords should parse", (boolean)worked);
        Assert.assertEquals((Object)PACKAGE_W_KEYWORDS, (Object)packageType.getPackageName());
    }
}

