/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jaxrs;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.jaxrs.PhoneNumber;

public class MessageBodyReaderWriterTestCases
extends JUnitTestCase {
    private JAXBContext jc;

    public MessageBodyReaderWriterTestCases(String name) throws Exception {
        super(name);
        HashMap<String, String> properties = new HashMap<String, String>(1);
        properties.put("eclipselink-oxm-xml", "META-INF/binding-phonenumber.xml");
        this.jc = JAXBContext.newInstance((Class[])new Class[]{PhoneNumber.class}, properties);
    }

    protected PhoneNumber getControlObject() {
        PhoneNumber phoneNumber = new PhoneNumber();
        phoneNumber.setId(2L);
        phoneNumber.setType("HOME");
        phoneNumber.setNum("555-2222");
        return phoneNumber;
    }

    protected String getID() {
        return "2";
    }

    protected JAXBContext getJAXBContext() {
        return this.jc;
    }

    protected String getURL() {
        return "http://%%host:port%%/CustomerWAR/rest/phonenumber_war";
    }

    public void testGetPhoneNumber() throws Exception {
        URL url = new URL(this.getURL() + "/" + this.getID());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/xml");
        InputStream xml = connection.getInputStream();
        PhoneNumber testObject = (PhoneNumber)this.getJAXBContext().createUnmarshaller().unmarshal(xml);
        connection.disconnect();
        MessageBodyReaderWriterTestCases.assertEquals((Object)this.getControlObject(), (Object)testObject);
    }
}

