/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jaxrs;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.jaxrs.Address;
import org.eclipse.persistence.testing.models.jpa.jaxrs.Customer;
import org.eclipse.persistence.testing.models.jpa.jaxrs.Customers;
import org.eclipse.persistence.testing.models.jpa.jaxrs.JAXRSPopulator;
import org.eclipse.persistence.testing.models.jpa.jaxrs.JAXRSTableCreator;
import org.eclipse.persistence.testing.models.jpa.jaxrs.PhoneNumber;

public class DefaultJAXBContextTestCases
extends JUnitTestCase {
    private JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Customer.class, Customers.class});

    public DefaultJAXBContextTestCases(String name) throws Exception {
        super(name);
    }

    public void testSetup() {
        ServerSession session = JUnitTestCase.getServerSession();
        new JAXRSTableCreator().replaceTables((DatabaseSession)session);
        JAXRSPopulator jaxrsPopulator = new JAXRSPopulator();
        jaxrsPopulator.buildExamples();
        jaxrsPopulator.persistExample((Session)session);
    }

    public void testGetCustomer() throws Exception {
        URL url = new URL(this.getURL() + "/" + this.getID());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/xml");
        InputStream xml = connection.getInputStream();
        Customer testObject = (Customer)this.getJAXBContext().createUnmarshaller().unmarshal(xml);
        connection.disconnect();
        DefaultJAXBContextTestCases.assertEquals((Object)this.getControlObject(), (Object)testObject);
    }

    public void testGetCustomerJSON() throws Exception {
        URL url = new URL(this.getURL() + "/" + this.getID());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json");
        InputStream inputStream = connection.getInputStream();
        StreamSource json = new StreamSource(inputStream);
        Unmarshaller u = this.getJAXBContext().createUnmarshaller();
        u.setProperty("eclipselink.media-type", (Object)"application/json");
        u.setProperty("eclipselink.json.include-root", (Object)false);
        Customer testObject = (Customer)u.unmarshal((Source)json, Customer.class).getValue();
        connection.disconnect();
        DefaultJAXBContextTestCases.assertEquals((Object)this.getControlObject(), (Object)testObject);
    }

    public void testGetCollectionOfObjects() throws Exception {
        URL url = new URL(this.getURL() + "/" + "findCustomerByCity" + "/" + "Ottawa");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/xml");
        InputStream xml = connection.getInputStream();
        Customers testObject = (Customers)this.getJAXBContext().createUnmarshaller().unmarshal(xml);
        connection.disconnect();
        DefaultJAXBContextTestCases.assertEquals((Object)this.getControlObjects(), (Object)testObject);
    }

    public void testGetCollectionOfObjectsJSON() throws Exception {
        URL url = new URL(this.getURL() + "/" + "findCustomerByCity" + "/" + "Ottawa");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json");
        InputStream inputStream = connection.getInputStream();
        StreamSource json = new StreamSource(inputStream);
        Unmarshaller u = this.getJAXBContext().createUnmarshaller();
        u.setProperty("eclipselink.media-type", (Object)"application/json");
        u.setProperty("eclipselink.json.include-root", (Object)false);
        List customers = (List)u.unmarshal((Source)json, Customer.class).getValue();
        connection.disconnect();
        Customers testObject = new Customers();
        testObject.setCustomer(customers);
        DefaultJAXBContextTestCases.assertEquals((Object)this.getControlObjects(), (Object)testObject);
    }

    public void testDeleteCustomer() throws Exception {
        URL url = new URL(this.getURL() + "/" + 2);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("DELETE");
        int response = connection.getResponseCode();
        connection.disconnect();
        DefaultJAXBContextTestCases.assertEquals((int)204, (int)response);
    }

    public void testPostCustomer() throws Exception {
        URL url = new URL(this.getURL());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/xml");
        OutputStream os = connection.getOutputStream();
        this.getJAXBContext().createMarshaller().marshal((Object)this.getControlObject2(), os);
        os.flush();
        connection.getResponseCode();
        Customer testObject = this.verifyHelperForPostPut(4);
        connection.disconnect();
        DefaultJAXBContextTestCases.assertEquals((Object)this.getControlObject2(), (Object)testObject);
    }

    public void testPostCustomerJSON() throws Exception {
        URL url = new URL(this.getURL());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        OutputStream os = connection.getOutputStream();
        this.getJAXBContext().createMarshaller().marshal((Object)this.getControlObject2(), os);
        os.flush();
        connection.getResponseCode();
        Customer testObject = this.verifyHelperForPostPutJSON(4);
        connection.disconnect();
        DefaultJAXBContextTestCases.assertEquals((Object)this.getControlObject2(), (Object)testObject);
    }

    public void testPutCustomer() throws Exception {
        URL url = new URL(this.getURL());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/xml");
        OutputStream os = connection.getOutputStream();
        this.getJAXBContext().createMarshaller().marshal((Object)this.getControlObject3(), os);
        os.flush();
        connection.getResponseCode();
        Customer testObject = this.verifyHelperForPostPut(3);
        connection.disconnect();
        DefaultJAXBContextTestCases.assertEquals((Object)this.getControlObject3(), (Object)testObject);
    }

    public void testPutCustomerJSON() throws Exception {
        URL url = new URL(this.getURL());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/json");
        OutputStream os = connection.getOutputStream();
        this.getJAXBContext().createMarshaller().marshal((Object)this.getControlObject3(), os);
        os.flush();
        connection.getResponseCode();
        Customer testObject = this.verifyHelperForPostPutJSON(3);
        connection.disconnect();
        DefaultJAXBContextTestCases.assertEquals((Object)this.getControlObject3(), (Object)testObject);
    }

    public Customer verifyHelperForPostPut(int id) throws Exception {
        URL url = new URL(this.getURL() + "/" + id);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/xml");
        InputStream xml = connection.getInputStream();
        Customer testObject = (Customer)this.getJAXBContext().createUnmarshaller().unmarshal(xml);
        connection.disconnect();
        return testObject;
    }

    public Customer verifyHelperForPostPutJSON(int id) throws Exception {
        URL url = new URL(this.getURL() + "/" + id);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json");
        InputStream inputStream = connection.getInputStream();
        StreamSource json = new StreamSource(inputStream);
        Unmarshaller u = this.getJAXBContext().createUnmarshaller();
        u.setProperty("eclipselink.media-type", (Object)"application/json");
        u.setProperty("eclipselink.json.include-root", (Object)false);
        Customer testObject = (Customer)u.unmarshal((Source)json, Customer.class).getValue();
        connection.disconnect();
        return testObject;
    }

    protected Customer getControlObject() {
        Customer customer = new Customer();
        customer.setId(1L);
        customer.setFirstName("Jane");
        customer.setLastName("Doe");
        Address address = new Address();
        address.setId(1L);
        address.setStreet("1 A Street");
        address.setCity("Ottawa");
        customer.setAddress(address);
        ArrayList<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>(2);
        PhoneNumber workPhone = new PhoneNumber();
        workPhone.setId(1L);
        workPhone.setNum("555-1111");
        workPhone.setType("WORK");
        phoneNumbers.add(workPhone);
        PhoneNumber homePhone = new PhoneNumber();
        homePhone.setId(2L);
        homePhone.setNum("555-2222");
        homePhone.setType("HOME");
        phoneNumbers.add(homePhone);
        customer.setPhoneNumbers(phoneNumbers);
        return customer;
    }

    protected Customer getControlObject2() {
        Customer customer = new Customer();
        customer.setId(4L);
        customer.setFirstName("John");
        customer.setLastName("Does");
        Address address = new Address();
        address.setId(4L);
        address.setStreet("4 A Street");
        address.setCity("AnyTown");
        customer.setAddress(address);
        ArrayList<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>(2);
        PhoneNumber workPhone = new PhoneNumber();
        workPhone.setId(7L);
        workPhone.setNum("555-7777");
        workPhone.setType("WORK");
        workPhone.setCustomer(customer);
        phoneNumbers.add(workPhone);
        PhoneNumber homePhone = new PhoneNumber();
        homePhone.setId(8L);
        homePhone.setNum("555-8888");
        homePhone.setType("HOME");
        homePhone.setCustomer(customer);
        phoneNumbers.add(homePhone);
        customer.setPhoneNumbers(phoneNumbers);
        return customer;
    }

    protected Customer getControlObject3() {
        Customer customer = new Customer();
        customer.setId(3L);
        customer.setFirstName("Sarah");
        customer.setLastName("Smith");
        Address address = new Address();
        address.setId(3L);
        address.setStreet("1 Nowhere Drive");
        address.setCity("Ottawa");
        customer.setAddress(address);
        ArrayList<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>(2);
        PhoneNumber workPhone = new PhoneNumber();
        workPhone.setId(5L);
        workPhone.setNum("555-5555");
        workPhone.setType("WORK");
        workPhone.setCustomer(customer);
        phoneNumbers.add(workPhone);
        PhoneNumber homePhone = new PhoneNumber();
        homePhone.setId(6L);
        homePhone.setNum("555-6666");
        homePhone.setType("HOME");
        homePhone.setCustomer(customer);
        phoneNumbers.add(homePhone);
        customer.setPhoneNumbers(phoneNumbers);
        return customer;
    }

    protected Customers getControlObjects() {
        Customers customerList = new Customers();
        ArrayList<Customer> customers = new ArrayList<Customer>(2);
        customers.add(this.getControlObject());
        customers.add(this.getControlObject3());
        customerList.setCustomer(customers);
        return customerList;
    }

    protected String getID() {
        return "1";
    }

    protected JAXBContext getJAXBContext() {
        return this.jc;
    }

    protected String getURL() {
        return "http://%%host:port%%/CustomerWAR/rest/customer_war";
    }
}

