/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PessimisticLockScope;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Dealer;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.Equipment;
import org.eclipse.persistence.testing.models.jpa.advanced.EquipmentCode;
import org.eclipse.persistence.testing.models.jpa.advanced.LargeProject;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.models.jpa.advanced.SmallProject;
import org.eclipse.persistence.testing.models.jpa.advanced.entities.EntyA;
import org.eclipse.persistence.testing.models.jpa.advanced.entities.EntyB;
import org.eclipse.persistence.testing.models.jpa.advanced.entities.EntyC;
import org.eclipse.persistence.testing.models.jpa.advanced.entities.EntyD;
import org.eclipse.persistence.testing.models.jpa.advanced.entities.EntyE;

public class PessimisticLockingExtendedScopeTestSuite
extends JUnitTestCase {
    public PessimisticLockingExtendedScopeTestSuite() {
    }

    public PessimisticLockingExtendedScopeTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("PessimisticLocking ExtendedScope TestSuite");
        suite.addTest((Test)new PessimisticLockingExtendedScopeTestSuite("testSetup"));
        suite.addTest((Test)new PessimisticLockingExtendedScopeTestSuite("testPESSMISTIC_ES1"));
        suite.addTest((Test)new PessimisticLockingExtendedScopeTestSuite("testPESSMISTIC_ES2"));
        suite.addTest((Test)new PessimisticLockingExtendedScopeTestSuite("testPESSMISTIC_ES3"));
        suite.addTest((Test)new PessimisticLockingExtendedScopeTestSuite("testPESSMISTIC_ES4"));
        suite.addTest((Test)new PessimisticLockingExtendedScopeTestSuite("testPESSMISTIC_ES5"));
        suite.addTest((Test)new PessimisticLockingExtendedScopeTestSuite("testPESSMISTIC_ES6"));
        suite.addTest((Test)new PessimisticLockingExtendedScopeTestSuite("testPESSMISTIC_ES7"));
        suite.addTest((Test)new PessimisticLockingExtendedScopeTestSuite("testPESSMISTIC_ES8"));
        suite.addTest((Test)new PessimisticLockingExtendedScopeTestSuite("testPESSMISTIC_ES9"));
        return suite;
    }

    public void testSetup() {
        ServerSession session = JUnitTestCase.getServerSession();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        ClassDescriptor descriptor = session.getDescriptor(EquipmentCode.class);
        boolean shouldBeReadOnly = descriptor.shouldBeReadOnly();
        descriptor.setShouldBeReadOnly(false);
        this.clearCache();
    }

    public void testPESSMISTIC_ES1() throws Exception {
        if (this.getPlatform().isSQLServer()) {
            PessimisticLockingExtendedScopeTestSuite.warning((String)"This test deadlocks on SQL Server");
            return;
        }
        final EntyA a = new EntyA();
        Actor<EntyA> actor = new Actor<EntyA>(){

            @Override
            public void setup(EntityManager em) {
                EntyC c = new EntyC();
                em.persist((Object)c);
                a.setName("test");
                a.setEntyC(c);
                em.persist((Object)a);
            }

            @Override
            public EntyA getEntityToLock(EntityManager em) {
                return (EntyA)em.find(EntyA.class, (Object)a.getId());
            }

            @Override
            public void modify(EntityManager em) {
                EntyA a2 = (EntyA)em.find(EntyA.class, (Object)a.getId());
                a2.setEntyC(null);
            }

            @Override
            public void check(EntityManager em, EntyA lockedEntity) {
                em.refresh((Object)lockedEntity);
                Assert.assertNotNull((String)"other transaction modified row concurrently", (Object)lockedEntity.getEntyC());
            }
        };
        this.testNonrepeatableRead(actor);
    }

    public void testPESSMISTIC_ES2() throws Exception {
        if (this.getPlatform().isSQLServer()) {
            PessimisticLockingExtendedScopeTestSuite.warning((String)"This test deadlocks on SQL Server");
            return;
        }
        final EntyA a = new EntyA();
        Actor<EntyA> actor = new Actor<EntyA>(){

            @Override
            public void setup(EntityManager em) {
                EntyB b = new EntyB();
                a.setEntyB(b);
                em.persist((Object)a);
            }

            @Override
            public EntyA getEntityToLock(EntityManager em1) {
                return (EntyA)em1.find(EntyA.class, (Object)a.getId());
            }

            @Override
            public void modify(EntityManager em2) {
                EntyA a2 = (EntyA)em2.find(EntyA.class, (Object)a.getId());
                a2.setEntyB(null);
            }

            @Override
            public void check(EntityManager em1, EntyA lockedEntity) {
                em1.refresh((Object)lockedEntity);
                Assert.assertNotNull((String)"other transaction modified row concurrently", (Object)lockedEntity.getEntyB());
            }
        };
        this.testNonrepeatableRead(actor);
    }

    public void testPESSMISTIC_ES3() throws Exception {
        if (this.getPlatform().isSQLServer()) {
            PessimisticLockingExtendedScopeTestSuite.warning((String)"This test deadlocks on SQL Server");
            return;
        }
        final Equipment eq = new Equipment();
        Actor<Equipment> actor = new Actor<Equipment>(){

            @Override
            public void setup(EntityManager em) {
                EquipmentCode eqCode = new EquipmentCode();
                eqCode.setCode("A");
                em.persist((Object)eqCode);
                eq.setEquipmentCode(eqCode);
                em.persist((Object)eq);
            }

            @Override
            public Equipment getEntityToLock(EntityManager em1) {
                return (Equipment)em1.find(Equipment.class, (Object)eq.getId());
            }

            @Override
            public void modify(EntityManager em2) {
                Equipment eq2 = (Equipment)em2.find(Equipment.class, (Object)eq.getId());
                eq2.setEquipmentCode(null);
            }

            @Override
            public void check(EntityManager em1, Equipment lockedEntity) {
                em1.refresh((Object)lockedEntity);
                Assert.assertNotNull((String)"other transaction modified row concurrently", (Object)lockedEntity.getEquipmentCode());
            }
        };
        this.testNonrepeatableRead(actor);
    }

    public void testPESSMISTIC_ES4() throws Exception {
        if (this.getPlatform().isSQLServer()) {
            PessimisticLockingExtendedScopeTestSuite.warning((String)"This test deadlocks on SQL Server");
            return;
        }
        final Employee emp = new Employee();
        Actor<Employee> actor = new Actor<Employee>(){

            @Override
            public void setup(EntityManager em) {
                Address ads = new Address("SomeStreet", "somecity", "province", "country", "postalcode");
                emp.setAddress(ads);
                em.persist((Object)emp);
            }

            @Override
            public Employee getEntityToLock(EntityManager em1) {
                return (Employee)em1.find(Employee.class, (Object)emp.getId());
            }

            @Override
            public void modify(EntityManager em2) {
                Employee emp2 = (Employee)em2.find(Employee.class, (Object)emp.getId());
                emp2.setAddress((Address)null);
            }

            @Override
            public void check(EntityManager em1, Employee lockedEntity) {
                em1.refresh((Object)lockedEntity);
                Assert.assertNotNull((String)"other transaction modified row concurrently", (Object)lockedEntity.getAddress());
            }
        };
        this.testNonrepeatableRead(actor);
    }

    public void testPESSMISTIC_ES5() throws Exception {
        if (this.getPlatform().isSQLServer()) {
            PessimisticLockingExtendedScopeTestSuite.warning((String)"This test deadlocks on SQL Server");
            return;
        }
        final EntyA entyA = new EntyA();
        Actor<EntyA> actor = new Actor<EntyA>(){

            @Override
            public void setup(EntityManager em) {
                em.persist((Object)entyA);
                entyA.getEntyDs().add(new EntyD());
            }

            @Override
            public EntyA getEntityToLock(EntityManager em1) {
                return (EntyA)em1.find(EntyA.class, (Object)entyA.getId());
            }

            @Override
            public void modify(EntityManager em2) {
                EntyA entyA2 = (EntyA)em2.find(EntyA.class, (Object)entyA.getId());
                entyA2.setEntyDs(null);
            }

            @Override
            public void check(EntityManager em1, EntyA lockedEntity) {
                Collection collection;
                em1.refresh((Object)lockedEntity);
                Assert.assertNotNull((String)"other transaction modified row concurrently", (Object)lockedEntity.getEntyDs());
                if (JUnitTestCase.getServerSession().getPlatform().isMaxDB()) {
                    Query query = em1.createNativeQuery("SELECT t2.entyDs_ID FROM ADV_ENTYA_ADV_ENTYD t2, ADV_ENTYA t1 WHERE ((? = t1.ID) AND ((t2.EntyA_ID = t1.ID)))");
                    query.setParameter(1, (Object)lockedEntity.getId());
                    collection = query.getResultList();
                } else {
                    collection = lockedEntity.getEntyDs();
                }
                Assert.assertFalse((String)"other transaction modified row concurrently", (boolean)collection.isEmpty());
            }
        };
        this.testNonrepeatableRead(actor);
    }

    public void testPESSMISTIC_ES6() throws Exception {
        if (this.getPlatform().isSQLServer()) {
            PessimisticLockingExtendedScopeTestSuite.warning((String)"This test deadlocks on SQL Server");
            return;
        }
        final EntyA entyA = new EntyA();
        Actor<EntyA> actor = new Actor<EntyA>(){

            @Override
            public void setup(EntityManager em) {
                ArrayList<EntyE> entyEs = new ArrayList<EntyE>();
                EntyE entyE1 = new EntyE();
                EntyE entyE2 = new EntyE();
                entyEs.add(entyE1);
                entyEs.add(entyE2);
                entyA.setEntyEs(entyEs);
                em.persist((Object)entyA);
            }

            @Override
            public EntyA getEntityToLock(EntityManager em1) {
                return (EntyA)em1.find(EntyA.class, (Object)entyA.getId());
            }

            @Override
            public void modify(EntityManager em2) {
                EntyA entyA2 = (EntyA)em2.find(EntyA.class, (Object)entyA.getId());
                entyA2.setEntyEs(null);
            }

            @Override
            public void check(EntityManager em1, EntyA lockedEntity) {
                em1.refresh((Object)lockedEntity);
                Assert.assertNotNull((String)"other transaction modified row concurrently", (Object)lockedEntity.getEntyEs());
                Assert.assertFalse((String)"other transaction modified row concurrently", (boolean)lockedEntity.getEntyEs().isEmpty());
            }
        };
        this.testNonrepeatableRead(actor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X> void testNonrepeatableRead(final Actor<X> actor) throws InterruptedException {
        if (PessimisticLockingExtendedScopeTestSuite.isOnServer() || !this.isSelectForUpateSupported()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        Object c = null;
        try {
            this.beginTransaction(em);
            actor.setup(em);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        Object lockTimeOutException = null;
        LockModeType lockMode = LockModeType.PESSIMISTIC_WRITE;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("javax.persistence.lock.scope", PessimisticLockScope.EXTENDED);
        properties.put("javax.persistence.lock.timeout", 10);
        EntityManager em1 = this.createEntityManager();
        try {
            this.beginTransaction(em1);
            X locked = actor.getEntityToLock(em1);
            em1.lock(locked, lockMode, properties);
            final EntityManager em2 = this.createEntityManager();
            try {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                PessimisticLockingExtendedScopeTestSuite.this.beginTransaction(em2);
                                actor.modify(em2);
                                PessimisticLockingExtendedScopeTestSuite.this.commitTransaction(em2);
                            }
                            catch (RollbackException ex) {
                                if (ex.getMessage().indexOf("org.eclipse.persistence.exceptions.DatabaseException") != -1) break block2;
                                ex.printStackTrace();
                                Assert.fail((String)"it's not the right exception");
                            }
                        }
                    }
                };
                Thread t2 = new Thread(runnable);
                t2.start();
                Thread.sleep(1000L);
                actor.check(em1, locked);
                this.rollbackTransaction(em1);
                t2.join();
            }
            finally {
                if (this.isTransactionActive(em2)) {
                    this.rollbackTransaction(em2);
                }
                this.closeEntityManager(em2);
            }
        }
        finally {
            if (this.isTransactionActive(em1)) {
                this.rollbackTransaction(em1);
            }
            this.closeEntityManager(em1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPESSMISTIC_ES7() throws Exception {
        if (this.getPlatform().isSQLServer()) {
            PessimisticLockingExtendedScopeTestSuite.warning((String)"This test deadlocks on SQL Server");
            return;
        }
        if (!PessimisticLockingExtendedScopeTestSuite.isOnServer() && this.isSelectForUpateSupported()) {
            EntityManager em = this.createEntityManager();
            EntyA a = null;
            EntyC c = null;
            try {
                this.beginTransaction(em);
                a = new EntyA();
                c = new EntyC();
                em.persist((Object)c);
                a.setEntyC(c);
                em.persist((Object)a);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            finally {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
            }
            Object lockTimeOutException = null;
            LockModeType lockMode = LockModeType.PESSIMISTIC_WRITE;
            HashMap<String, PessimisticLockScope> properties = new HashMap<String, PessimisticLockScope>();
            properties.put("javax.persistence.lock.scope", PessimisticLockScope.NORMAL);
            EntityManager em1 = this.createEntityManager();
            try {
                this.beginTransaction(em1);
                c = (EntyC)em1.find(EntyC.class, (Object)c.getId());
                em1.lock((Object)c, lockMode, properties);
                EntityManager em2 = this.createEntityManager();
                try {
                    this.beginTransaction(em2);
                    c = (EntyC)em2.find(EntyC.class, (Object)c.getId());
                    c.setEntyA(null);
                    this.commitTransaction(em2);
                }
                catch (RollbackException ex) {
                    PessimisticLockingExtendedScopeTestSuite.fail((String)"it should not throw the exception!!!");
                }
                finally {
                    if (this.isTransactionActive(em2)) {
                        this.rollbackTransaction(em2);
                    }
                    this.closeEntityManager(em2);
                }
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                if (this.isTransactionActive(em1)) {
                    this.rollbackTransaction(em1);
                }
                this.closeEntityManager(em1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPESSMISTIC_ES8() throws Exception {
        if (this.getPlatform().isSQLServer()) {
            PessimisticLockingExtendedScopeTestSuite.warning((String)"This test deadlocks on SQL Server");
            return;
        }
        if (!PessimisticLockingExtendedScopeTestSuite.isOnServer() && this.isSelectForUpateSupported()) {
            EntityManager em = this.createEntityManager();
            Employee emp = null;
            try {
                this.beginTransaction(em);
                emp = new Employee();
                emp.getDealers().add(new Dealer("Honda", "Kanata"));
                em.persist((Object)emp);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            finally {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
            }
            Object lockTimeOutException = null;
            LockModeType lockMode = LockModeType.PESSIMISTIC_WRITE;
            HashMap<String, PessimisticLockScope> properties = new HashMap<String, PessimisticLockScope>();
            properties.put("javax.persistence.lock.scope", PessimisticLockScope.NORMAL);
            EntityManager em1 = this.createEntityManager();
            try {
                this.beginTransaction(em1);
                emp = (Employee)em1.find(Employee.class, (Object)emp.getId());
                em1.lock((Object)emp, lockMode, properties);
                EntityManager em2 = this.createEntityManager();
                try {
                    this.beginTransaction(em2);
                    emp = (Employee)em1.find(Employee.class, (Object)emp.getId());
                    emp.setDealers(null);
                    this.commitTransaction(em2);
                }
                catch (RollbackException ex) {
                    PessimisticLockingExtendedScopeTestSuite.fail((String)"it should not throw the exception!!!");
                }
                finally {
                    if (this.isTransactionActive(em2)) {
                        this.rollbackTransaction(em2);
                    }
                    this.closeEntityManager(em2);
                }
            }
            catch (Exception ex) {
                PessimisticLockingExtendedScopeTestSuite.fail((String)"it should not throw the exception!!!");
                throw ex;
            }
            finally {
                if (this.isTransactionActive(em1)) {
                    this.rollbackTransaction(em1);
                }
                this.closeEntityManager(em1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPESSMISTIC_ES9() throws Exception {
        if (this.getPlatform().isSQLServer()) {
            PessimisticLockingExtendedScopeTestSuite.warning((String)"This test deadlocks on SQL Server");
            return;
        }
        if (!PessimisticLockingExtendedScopeTestSuite.isOnServer() && this.isSelectForUpateSupported()) {
            EntityManager em = this.createEntityManager();
            Employee emp = null;
            try {
                this.beginTransaction(em);
                emp = new Employee();
                SmallProject smallProject = new SmallProject();
                smallProject.setName("New High School Set Up");
                emp.addProject((Project)smallProject);
                LargeProject largeProject = new LargeProject();
                largeProject.setName("Downtown Light Rail");
                largeProject.setBudget(5000.0);
                emp.addProject((Project)largeProject);
                em.persist((Object)emp);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            finally {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
            }
            Object lockTimeOutException = null;
            LockModeType lockMode = LockModeType.PESSIMISTIC_WRITE;
            HashMap<String, PessimisticLockScope> properties = new HashMap<String, PessimisticLockScope>();
            properties.put("javax.persistence.lock.scope", PessimisticLockScope.NORMAL);
            EntityManager em1 = this.createEntityManager();
            try {
                this.beginTransaction(em1);
                emp = (Employee)em1.find(Employee.class, (Object)emp.getId());
                em1.lock((Object)emp, lockMode, properties);
                EntityManager em2 = this.createEntityManager();
                try {
                    this.beginTransaction(em2);
                    emp = (Employee)em1.find(Employee.class, (Object)emp.getId());
                    emp.setProjects(null);
                    this.commitTransaction(em2);
                }
                catch (RollbackException ex) {
                    PessimisticLockingExtendedScopeTestSuite.fail((String)"it should not throw the exception!!!");
                }
                finally {
                    if (this.isTransactionActive(em2)) {
                        this.rollbackTransaction(em2);
                    }
                    this.closeEntityManager(em2);
                }
            }
            catch (Exception ex) {
                PessimisticLockingExtendedScopeTestSuite.fail((String)"it should not throw the exception!!!");
                throw ex;
            }
            finally {
                if (this.isTransactionActive(em1)) {
                    this.rollbackTransaction(em1);
                }
                this.closeEntityManager(em1);
            }
        }
    }

    static interface Actor<X> {
        public void setup(EntityManager var1);

        public X getEntityToLock(EntityManager var1);

        public void modify(EntityManager var1);

        public void check(EntityManager var1, X var2);
    }
}

