/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.models.optimisticlocking.Controller;
import org.eclipse.persistence.testing.models.optimisticlocking.GamesConsole;
import org.eclipse.persistence.testing.tests.optimisticlocking.SwitchableOptimisticLockingPolicyTest;

public class UpdateNullOneToManyValueTest2
extends SwitchableOptimisticLockingPolicyTest {
    protected Controller original;
    protected Controller original2;

    public UpdateNullOneToManyValueTest2(Class optimisticLockingPolicyClass) {
        super(optimisticLockingPolicyClass);
        this.addClassToModify(Controller.class);
        this.addClassToModify(GamesConsole.class);
    }

    @Override
    public void setup() {
        super.setup();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.original = new Controller("Mad-Dogz", "black");
        this.original.setConsole(null);
        this.original2 = new Controller("X-Bocks", "green");
        uow.registerObject((Object)this.original);
        uow.registerObject((Object)this.original2);
        uow.commit();
    }

    public void test() throws TestException {
        try {
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.readObjectAndChangeAttributeValue(new GamesConsole(null, "mauve"));
            this.readObjectAndChangeAttributeValue(null);
            this.readObjectAndChangeAttributeValue(new GamesConsole("Whee", "white"));
            this.readObjectAndChangeAttributeValue(new GamesConsole("N3S", "gray"));
            this.readObjectAndChangeAttributeValue(null);
            this.readObjectAndChangeAttributeValue(new GamesConsole(null, "white"));
            this.readObjectAndChangeAttributeValue(null);
            this.deleteObject(this.original);
            this.deleteObject(this.original2);
        }
        catch (Exception tle) {
            this.tlException = tle;
            this.tlException.printStackTrace();
        }
    }

    public void readObjectAndChangeAttributeValue(GamesConsole newConsole) {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Controller clone = (Controller)uow.readObject(Controller.class, new ExpressionBuilder().get("id").equal(this.original.getId()));
        UpdateNullOneToManyValueTest2.assertNotNull((String)"The object returned should be not null", (Object)clone);
        if (clone.getConsole() != null) {
            clone.getConsole().removeController(clone);
        }
        if (newConsole != null) {
            GamesConsole consoleClone = (GamesConsole)uow.registerObject((Object)newConsole);
            consoleClone.addController(clone);
        } else {
            clone.setConsole(null);
        }
        uow.commit();
    }

    @Override
    public void reset() {
        super.reset();
        this.original = null;
        this.original2 = null;
    }
}

