/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.helper;

import java.sql.Time;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class TimeFromLongTest
extends AutoVerifyTestCase {
    Long currentTime;
    Time nonOptimizedTime;
    Time optimizedTime;
    boolean optimizedDatesState;

    public static void main(String[] args) {
        TimeFromLongTest test = new TimeFromLongTest();
        test.setup();
        test.test();
        test.verify();
        test.reset();
    }

    public TimeFromLongTest() {
        this.setDescription("Test of Helper.timeFromLong(Long longObject)");
    }

    public void setup() {
        this.currentTime = new Long(System.currentTimeMillis());
        this.optimizedDatesState = Helper.shouldOptimizeDates();
    }

    public void test() {
        Helper.setShouldOptimizeDates((boolean)false);
        this.nonOptimizedTime = Helper.timeFromLong((Long)this.currentTime);
        Helper.setShouldOptimizeDates((boolean)true);
        this.optimizedTime = Helper.timeFromLong((Long)this.currentTime);
    }

    public void verify() {
        Time testTime = new Time(this.currentTime);
        if (!testTime.equals(this.nonOptimizedTime) || !testTime.toString().equals(this.nonOptimizedTime.toString())) {
            throw new TestErrorException("Failed to convert Long to java.sql.Time when shouldOptimizedDates is off");
        }
        if (!testTime.equals(this.optimizedTime) || !testTime.toString().equals(this.optimizedTime.toString())) {
            throw new TestErrorException("Failed to convert Long to java.sql.Time when shouldOptimizedDates is on");
        }
    }

    public void reset() {
        Helper.setShouldOptimizeDates((boolean)this.optimizedDatesState);
    }
}

