/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import java.util.Iterator;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.map.AggregateEntityMapHolder;
import org.eclipse.persistence.testing.models.collections.map.AggregateMapKey;
import org.eclipse.persistence.testing.models.collections.map.EntityMapValue;

public class TestUpdateAggregateEntityMapMapping
extends TestCase {
    private AggregateEntityMapHolder holder = null;
    protected ManyToManyMapping mapping = null;
    private boolean usePrivateOwned = false;
    private boolean oldPrivateOwnedValue = false;

    public TestUpdateAggregateEntityMapMapping() {
    }

    public TestUpdateAggregateEntityMapMapping(boolean usePrivateOwned) {
        this();
        this.usePrivateOwned = usePrivateOwned;
        this.setName("TestUpdateAggregateEntityMapMapping privateOwned=" + usePrivateOwned);
    }

    public void setup() {
        this.mapping = (ManyToManyMapping)this.getSession().getProject().getDescriptor(AggregateEntityMapHolder.class).getMappingForAttributeName("aggregateToEntityMap");
        this.oldPrivateOwnedValue = this.mapping.isPrivateOwned();
        this.mapping.setIsPrivateOwned(this.usePrivateOwned);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.holder = new AggregateEntityMapHolder();
        EntityMapValue value = new EntityMapValue();
        value.setId(1);
        AggregateMapKey key = new AggregateMapKey();
        key.setKey(11);
        this.holder.addAggregateToEntityMapItem(key, value);
        EntityMapValue value2 = new EntityMapValue();
        value2.setId(2);
        key = new AggregateMapKey();
        key.setKey(22);
        this.holder.addAggregateToEntityMapItem(key, value2);
        uow.registerObject((Object)this.holder);
        uow.registerObject((Object)value);
        uow.registerObject((Object)value2);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.holder = (AggregateEntityMapHolder)uow.readObject((Object)this.holder);
        EntityMapValue value = new EntityMapValue();
        value.setId(3);
        AggregateMapKey mapKey = new AggregateMapKey();
        mapKey.setKey(33);
        this.holder.addAggregateToEntityMapItem(mapKey, value);
        mapKey = new AggregateMapKey();
        mapKey.setKey(11);
        this.holder.getAggregateToEntityMap().remove(mapKey);
        uow.commit();
        Object holderForComparison = uow.readObject((Object)this.holder);
        if (!this.compareObjects(this.holder, holderForComparison)) {
            throw new TestErrorException("Objects do not match after write");
        }
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        AggregateEntityMapHolder changedHolder = this.holder;
        this.holder = (AggregateEntityMapHolder)this.getSession().readObject((Object)this.holder);
        if (this.holder == null) {
            throw new TestErrorException("AggregateKeyMapHolder could not be read.");
        }
        if (!this.compareObjects(this.holder, changedHolder)) {
            throw new TestErrorException("Objects do not match reinitialize");
        }
        if (this.holder.getAggregateToEntityMap().size() != 2) {
            throw new TestErrorException("Incorrect Number of MapEntityValues was read.");
        }
        AggregateMapKey mapKey = new AggregateMapKey();
        mapKey.setKey(33);
        EntityMapValue value = (EntityMapValue)this.holder.getAggregateToEntityMap().get(mapKey);
        if (value.getId() != 3) {
            throw new TestErrorException("MapEntityValue was not added properly.");
        }
        mapKey = new AggregateMapKey();
        mapKey.setKey(11);
        value = (EntityMapValue)this.holder.getAggregateToEntityMap().get(mapKey);
        if (value != null) {
            throw new TestErrorException("Deleted EntityMapValue still around.");
        }
        if (this.mapping.isPrivateOwned()) {
            ReadObjectQuery query = new ReadObjectQuery(EntityMapValue.class);
            ExpressionBuilder values = new ExpressionBuilder();
            Expression criteria = values.get("id").equal(1);
            query.setSelectionCriteria(criteria);
            value = (EntityMapValue)this.getSession().executeQuery((DatabaseQuery)query);
            if (value != null) {
                throw new TestErrorException("PrivateOwned EntityMapValue was not deleted.");
            }
        }
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Iterator j = this.holder.getAggregateToEntityMap().keySet().iterator();
        while (j.hasNext()) {
            uow.deleteObject(this.holder.getAggregateToEntityMap().get(j.next()));
        }
        uow.deleteObject((Object)this.holder);
        uow.commit();
        this.mapping.setIsPrivateOwned(this.oldPrivateOwnedValue);
    }
}

