/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.platform.database.DerbyPlatform;
import org.eclipse.persistence.platform.database.MySQLPlatform;
import org.eclipse.persistence.platform.database.PostgreSQLPlatform;
import org.eclipse.persistence.tools.dbws.ProcedureOperationModel;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.dbws.jdbc.DbColumn;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredArgument;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredFunction;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredProcedure;
import org.eclipse.persistence.tools.dbws.jdbc.DbTable;

public class JDBCHelper {
    public static final int TABLESINFO_CATALOG = 1;
    public static final int TABLESINFO_SCHEMA = 2;
    public static final int TABLESINFO_NAME = 3;
    public static final int TABLESINFO_TYPE = 4;
    public static final int COLUMNSINFO_COLUMN_NAME = 4;
    public static final int COLUMNSINFO_DATA_TYPE = 5;
    public static final int COLUMNSINFO_TYPE_NAME = 6;
    public static final int COLUMNSINFO_COLUMN_SIZE = 7;
    public static final int COLUMNSINFO_DECIMAL_DIGITS = 9;
    public static final int COLUMNSINFO_NULLABLE = 11;
    public static final int COLUMNSINFO_ORDINAL_POSITION = 17;
    public static final int PKSINFO_KEY_SEQ = 5;
    public static final int PKSINFO_PK_NAME = 6;
    public static final int INDEXINFO_NON_UNIQUE = 4;
    public static final int INDEXINFO_TYPE = 7;
    public static final int INDEXINFO_ORDINAL_POSITION = 8;
    public static final int PROCS_INFO_CATALOG = 1;
    public static final int PROCS_INFO_SCHEMA = 2;
    public static final int PROCS_INFO_NAME = 3;
    public static final int PROCS_INFO_TYPE = 8;
    public static final int PROC_COLS_INFO_CATALOG = 1;
    public static final int PROC_COLS_INFO_SCHEMA = 2;
    public static final int PROC_COLS_INFO_NAME = 3;
    public static final int PROC_COLS_INFO_COLNAME = 4;
    public static final int PROC_COLS_INFO_TYPE = 5;
    public static final int PROC_COLS_INFO_DATA_TYPE = 6;
    public static final int PROC_COLS_INFO_TYPE_NAME = 7;
    public static final int PROC_COLS_INFO_PRECISION = 8;
    public static final int PROC_COLS_INFO_LENGTH = 9;
    public static final int PROC_COLS_INFO_SCALE = 10;
    public static final int PROC_COLS_INFO_RADIX = 11;
    public static final int PROC_COLS_INFO_NULLABLE = 12;
    public static final int PROC_COLS_INFO_ORA_SEQUENCE = 14;
    public static final int PROC_COLS_INFO_ORA_OVERLOAD = 15;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<DbTable> buildDbTable(Connection connection, DatabasePlatform platform, String originalCatalogPattern, String originalSchemaPattern, String originalTablePattern) {
        dbTables = null;
        isOracle = platform.getClass().getName().contains("Oracle") != false;
        schemaPattern = Util.escapePunctuation(originalSchemaPattern, isOracle);
        tablePattern = Util.escapePunctuation(originalTablePattern, isOracle);
        databaseMetaData = JDBCHelper.getDatabaseMetaData(connection);
        supportsCatalogsInTableDefinitions = true;
        try {
            supportsCatalogsInTableDefinitions = databaseMetaData.supportsCatalogsInTableDefinitions();
        }
        catch (SQLException sqlException) {
            // empty catch block
        }
        catalogPattern = Util.escapePunctuation(supportsCatalogsInTableDefinitions != false ? originalCatalogPattern : "", isOracle);
        tablesInfo = null;
        try {
            tablesInfo = databaseMetaData.getTables(catalogPattern, schemaPattern, tablePattern, null);
        }
        catch (SQLException sqlException) {
            throw new IllegalStateException("failure retrieving JDBC table metadata", sqlException);
        }
        if (tablesInfo == null) return dbTables;
        dbTables = new ArrayList<DbTable>();
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                if (!tablesInfo.next()) {
                    tablesInfo.close();
                    return dbTables;
                }
                actualTableCatalog = null;
                try {
                    actualTableCatalog = tablesInfo.getString(1);
                }
                catch (SQLException sqlException) {
                    // empty catch block
                }
                if (actualTableCatalog != null && actualTableCatalog.length() == 0 && isOracle) {
                    actualTableCatalog = null;
                }
                actualTableSchema = null;
                try {
                    actualTableSchema = tablesInfo.getString(2);
                }
                catch (SQLException sqlException) {
                    // empty catch block
                }
                if (actualTableSchema != null && actualTableSchema.length() == 0 && isOracle) {
                    actualTableSchema = null;
                }
                actualTableName = tablesInfo.getString(3);
                tableType = null;
                try {
                    tableType = tablesInfo.getString(4);
                }
                catch (SQLException sqlException) {
                    // empty catch block
                }
                dbTable = new DbTable();
                dbTable.setCatalog(actualTableCatalog);
                dbTable.setSchema(actualTableSchema);
                dbTable.setName(actualTableName);
                if (tableType != null) {
                    dbTable.setType(tableType);
                }
                dbTables.add(dbTable);
                columnInfo = databaseMetaData.getColumns(actualTableCatalog, actualTableSchema, actualTableName, "%");
                while (columnInfo.next()) {
                    dbColumn = new DbColumn();
                    dbColumn.setName(columnInfo.getString(4));
                    dbColumn.setOrdinalPosition(columnInfo.getInt(17));
                    try {
                        dbColumn.setPrecision(columnInfo.getInt(7));
                    }
                    catch (NumberFormatException nfe) {
                        dbColumn.setPrecision(-1);
                    }
                    dbColumn.setScale(columnInfo.getInt(9));
                    dbColumn.setNullable(columnInfo.getInt(11) == 1);
                    dbColumn.setJDBCType(columnInfo.getInt(5));
                    dbColumn.setJDBCTypeName(columnInfo.getString(6));
                    dbTable.getColumns().add(dbColumn.getOrdinalPosition() - 1, dbColumn);
                }
                columnInfo.close();
                pksInfo = databaseMetaData.getPrimaryKeys(actualTableCatalog, actualTableSchema, actualTableName);
                if (pksInfo != null) {
                    while (pksInfo.next()) {
                        keySeq = pksInfo.getShort(5);
                        pkConstraintName = pksInfo.getString(6);
                        dbColumn = dbTable.getColumns().get(keySeq - 1);
                        dbColumn.setPK(true);
                        dbColumn.setPkConstraintName(pkConstraintName);
                    }
                }
                pksInfo.close();
                try {
                    indexInfo = databaseMetaData.getIndexInfo(actualTableCatalog, actualTableSchema, actualTableName, true, false);
                    if (indexInfo != null) {
                        while (indexInfo.next()) {
                            nonUnique = indexInfo.getBoolean(4);
                            if (nonUnique || (type = indexInfo.getShort(7)) == 0) continue;
                            pos = indexInfo.getShort(8);
                            dbColumn = dbTable.getColumns().get(pos - 1);
                            if (dbColumn.isPK()) continue;
                            dbColumn.setUnique(true);
                        }
                    }
                    indexInfo.close();
                }
                catch (SQLException sqlException) {
                    continue;
                }
                break;
            }
        }
        catch (SQLException sqlException) {
            throw new IllegalStateException("failure retrieving JDBC table metadata", sqlException);
        }
        ** GOTO lbl-1000
    }

    public static List<DbStoredProcedure> buildStoredProcedure(Connection connection, DatabasePlatform platform, ProcedureOperationModel procedureModel) {
        ArrayList<DbStoredProcedure> dbStoredProcedures = null;
        boolean catalogMatchDontCare = false;
        if (platform instanceof MySQLPlatform || platform instanceof DerbyPlatform || platform instanceof PostgreSQLPlatform) {
            catalogMatchDontCare = true;
        }
        boolean isOracle = platform.getClass().getName().contains("Oracle");
        String originalCatalogPattern = procedureModel.getCatalogPattern();
        String originalSchemaPattern = procedureModel.getSchemaPattern();
        String originalProcedurePattern = procedureModel.getProcedurePattern();
        String catalogPattern = Util.escapePunctuation(originalCatalogPattern, isOracle);
        String schemaPattern = Util.escapePunctuation(originalSchemaPattern, isOracle);
        String procedurePattern = Util.escapePunctuation(originalProcedurePattern, isOracle);
        ResultSet procsInfo = null;
        try {
            DatabaseMetaData databaseMetaData = JDBCHelper.getDatabaseMetaData(connection);
            procsInfo = databaseMetaData.getProcedures(catalogPattern, schemaPattern, procedurePattern);
            if (procsInfo != null) {
                ArrayList<DbStoredProcedure> tmpProcs = new ArrayList<DbStoredProcedure>();
                while (procsInfo.next()) {
                    String actualCatalogName = procsInfo.getString(1);
                    String actualSchemaName = procsInfo.getString(2);
                    String actualProcedureName = procsInfo.getString(3);
                    short procedureType = procsInfo.getShort(8);
                    DbStoredProcedure dbStoredProcedure = procedureType == 2 ? new DbStoredFunction(actualProcedureName) : new DbStoredProcedure(actualProcedureName);
                    if (actualCatalogName != null && actualCatalogName.length() > 0) {
                        dbStoredProcedure.setCatalog(actualCatalogName);
                    }
                    if (actualSchemaName != null && actualSchemaName.length() > 0) {
                        dbStoredProcedure.setSchema(actualSchemaName);
                    }
                    tmpProcs.add(dbStoredProcedure);
                }
                procsInfo.close();
                int numProcs = tmpProcs.size();
                if (numProcs > 0) {
                    dbStoredProcedures = new ArrayList<DbStoredProcedure>(numProcs);
                    ArrayList<OverloadHolder> overloadHolderList = new ArrayList<OverloadHolder>();
                    ResultSet procedureColumnsInfo = null;
                    procedureColumnsInfo = databaseMetaData.getProcedureColumns(catalogPattern, schemaPattern, procedurePattern, "%");
                    while (procedureColumnsInfo.next()) {
                        short overload;
                        String actualCatalogName = procedureColumnsInfo.getString(1);
                        String actualSchemaName = procedureColumnsInfo.getString(2);
                        String actualProcedureName = procedureColumnsInfo.getString(3);
                        String argName = procedureColumnsInfo.getString(4);
                        if (argName == null) {
                            argName = "";
                        }
                        DbStoredArgument dbStoredArgument = new DbStoredArgument(argName);
                        short inOut = procedureColumnsInfo.getShort(5);
                        if (inOut == 2) {
                            dbStoredArgument.setInOut(Util.InOut.INOUT);
                        } else if (inOut == 4) {
                            dbStoredArgument.setInOut(Util.InOut.OUT);
                        } else if (inOut == 5) {
                            dbStoredArgument.setInOut(Util.InOut.RETURN);
                        }
                        dbStoredArgument.setJdbcType(procedureColumnsInfo.getInt(6));
                        dbStoredArgument.setJdbcTypeName(procedureColumnsInfo.getString(7));
                        dbStoredArgument.setPrecision(procedureColumnsInfo.getInt(8));
                        dbStoredArgument.setScale(procedureColumnsInfo.getInt(10));
                        dbStoredArgument.setRadix(procedureColumnsInfo.getShort(11));
                        dbStoredArgument.setNullable(procedureColumnsInfo.getShort(12) == 1);
                        if (isOracle) {
                            dbStoredArgument.setSeq(procedureColumnsInfo.getShort(14));
                        }
                        short s = overload = isOracle ? procedureColumnsInfo.getShort(15) : (short)0;
                        if (overload == 0) {
                            DbStoredProcedure matchingProc = null;
                            for (int i = 0; i < tmpProcs.size(); ++i) {
                                DbStoredProcedure tmpProc = (DbStoredProcedure)tmpProcs.get(i);
                                if (!tmpProc.matches(actualCatalogName, actualSchemaName, actualProcedureName, isOracle, catalogMatchDontCare)) continue;
                                matchingProc = tmpProc;
                                dbStoredProcedures.add(matchingProc);
                                break;
                            }
                            if (matchingProc == null) {
                                for (DbStoredProcedure dbStoredProcedure : dbStoredProcedures) {
                                    if (!dbStoredProcedure.matches(actualCatalogName, actualSchemaName, actualProcedureName, isOracle, catalogMatchDontCare)) continue;
                                    matchingProc = dbStoredProcedure;
                                    break;
                                }
                            }
                            if (matchingProc == null) continue;
                            if (matchingProc.isFunction() && (isOracle ? dbStoredArgument.getName() == null : dbStoredArgument.getName().equalsIgnoreCase("")) && dbStoredArgument.getSeq() == (isOracle ? 1 : 0)) {
                                ((DbStoredFunction)matchingProc).setReturnArg(dbStoredArgument);
                            } else {
                                matchingProc.getArguments().add(dbStoredArgument);
                            }
                            tmpProcs.remove(matchingProc);
                            continue;
                        }
                        OverloadHolder overloadHolder = null;
                        for (OverloadHolder ovrldhldr : overloadHolderList) {
                            if (ovrldhldr.overload != overload || !ovrldhldr.packageName.equals(actualCatalogName) || !ovrldhldr.procedureSchema.equals(actualSchemaName) || !ovrldhldr.procedureName.equals(actualProcedureName)) continue;
                            overloadHolder = ovrldhldr;
                            break;
                        }
                        if (overloadHolder == null) {
                            overloadHolder = new OverloadHolder(actualCatalogName, actualSchemaName, actualProcedureName, overload);
                            overloadHolderList.add(overloadHolder);
                        }
                        overloadHolder.getArgs().add(dbStoredArgument);
                    }
                    procedureColumnsInfo.close();
                    for (OverloadHolder ovrldhldr : overloadHolderList) {
                        Collections.sort(ovrldhldr.getArgs(), new Comparator<DbStoredArgument>(){

                            @Override
                            public int compare(DbStoredArgument o1, DbStoredArgument o2) {
                                return o1.getSeq() - o2.getSeq();
                            }
                        });
                        DbStoredProcedure matchingProc = null;
                        for (int j = 0; j < tmpProcs.size(); ++j) {
                            DbStoredProcedure dbStoredProcedure = (DbStoredProcedure)tmpProcs.get(j);
                            if (!dbStoredProcedure.matches(ovrldhldr.packageName, ovrldhldr.procedureSchema, ovrldhldr.procedureName, true, false)) continue;
                            DbStoredArgument firstArg = ovrldhldr.getArgs().get(0);
                            if (firstArg.getName() == null && firstArg.getSeq() == 1) {
                                if (!dbStoredProcedure.isFunction()) continue;
                                matchingProc = (DbStoredProcedure)tmpProcs.remove(j);
                                break;
                            }
                            matchingProc = (DbStoredProcedure)tmpProcs.remove(j);
                            break;
                        }
                        if (matchingProc == null) continue;
                        if (matchingProc.isFunction()) {
                            DbStoredArgument returnArg = ovrldhldr.getArgs().remove(0);
                            ((DbStoredFunction)matchingProc).setReturnArg(returnArg);
                        }
                        matchingProc.setOverload(ovrldhldr.overload);
                        matchingProc.getArguments().addAll(ovrldhldr.getArgs());
                        dbStoredProcedures.add(matchingProc);
                    }
                    if (!tmpProcs.isEmpty()) {
                        dbStoredProcedures.addAll(tmpProcs);
                    }
                }
            }
        }
        catch (SQLException sqlException) {
            throw new IllegalStateException("failure retrieving Stored Procedure metadata", sqlException);
        }
        if (dbStoredProcedures != null && !dbStoredProcedures.isEmpty()) {
            Collections.sort(dbStoredProcedures, new Comparator<DbStoredProcedure>(){

                @Override
                public int compare(DbStoredProcedure o1, DbStoredProcedure o2) {
                    String name2;
                    String name1 = o1.getName();
                    if (!name1.equals(name2 = o2.getName())) {
                        return name1.compareTo(name2);
                    }
                    return o1.getOverload() - o2.getOverload();
                }
            });
        }
        return dbStoredProcedures;
    }

    public static DatabaseMetaData getDatabaseMetaData(Connection connection) {
        DatabaseMetaData databaseMetaData = null;
        try {
            databaseMetaData = connection.getMetaData();
        }
        catch (SQLException sqlException) {
            throw new IllegalStateException("failure retrieving JDBC metadata", sqlException);
        }
        return databaseMetaData;
    }

    public static List<DbColumn> buildDbColumns(Connection connection, String secondarySql) {
        ArrayList<DbColumn> columns = null;
        ResultSet resultSet = null;
        try {
            Statement statement = connection.createStatement();
            resultSet = statement.executeQuery(secondarySql);
        }
        catch (SQLException sqlException) {
            throw new IllegalStateException("failure executing secondary SQL: " + secondarySql, sqlException);
        }
        if (resultSet != null) {
            ResultSetMetaData rsMetaData = null;
            try {
                rsMetaData = resultSet.getMetaData();
            }
            catch (SQLException sqlException) {
                throw new IllegalStateException("failure retrieving resultSet metadata", sqlException);
            }
            if (rsMetaData != null) {
                int columnCount = 0;
                try {
                    columnCount = rsMetaData.getColumnCount();
                }
                catch (SQLException sqlException) {
                    throw new IllegalStateException("failure retrieving columnCount", sqlException);
                }
                if (columnCount > 0) {
                    columns = new ArrayList<DbColumn>(columnCount);
                    try {
                        for (int i = 1; i <= columnCount; ++i) {
                            DbColumn dbColumn = new DbColumn();
                            dbColumn.setOrdinalPosition(i);
                            dbColumn.setName(rsMetaData.getColumnLabel(i));
                            dbColumn.setJDBCType(rsMetaData.getColumnType(i));
                            dbColumn.setJDBCTypeName(rsMetaData.getColumnTypeName(i));
                            dbColumn.setPrecision(rsMetaData.getPrecision(i));
                            dbColumn.setScale(rsMetaData.getScale(i));
                            dbColumn.setNullable(rsMetaData.isNullable(i) == 1);
                            columns.add(dbColumn);
                        }
                    }
                    catch (SQLException sqlException) {
                        throw new IllegalStateException("failure retrieving column information", sqlException);
                    }
                }
            }
        }
        return columns;
    }

    public static class OverloadHolder {
        String packageName;
        String procedureSchema;
        String procedureName;
        short overload;
        List<DbStoredArgument> overloadedArgs;

        public OverloadHolder(String packageName, String procedureSchema, String procedureName, short overload) {
            this.packageName = packageName;
            this.procedureSchema = procedureSchema;
            this.procedureName = procedureName;
            this.overload = overload;
            this.overloadedArgs = new ArrayList<DbStoredArgument>();
        }

        public List<DbStoredArgument> getArgs() {
            return this.overloadedArgs;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.overload);
            sb.append(' ');
            sb.append(this.packageName);
            sb.append('-');
            sb.append(this.procedureSchema);
            sb.append('-');
            sb.append(this.procedureName);
            sb.append(' ');
            sb.append(this.overloadedArgs);
            return sb.toString();
        }
    }
}

