/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.JavaName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.LangName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Name;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.TypeClass;

public class SqlName
extends Name {
    public static final String ROWTYPE = "ROWTYPE";
    public static final String ROWTYPE_PL = "ROWTYPE_PL";
    public static final String ROWTYPE_SQL = "ROWTYPE_SQL";
    private static int m_rowtypeDistinguisher = 0;
    private static final String PUBLIC = "PUBLIC.";
    static String m_defaultSchema;
    static int m_case;
    static int m_targetLang;
    protected static int m_sql2PLCounter;
    protected static int m_pl2SQLCounter;
    protected boolean m_fromDB;
    protected boolean m_contextFromIntype;
    protected int m_line = 0;
    protected int m_column = 0;
    protected boolean m_quoted;
    protected boolean m_printAsIs;
    protected String m_sourceName;
    protected boolean m_isRowType = false;
    protected boolean m_isReused = false;
    protected boolean m_predefined = false;
    protected Boolean m_hasConversion;
    protected String m_convertOutOf;
    protected String m_convertInto;
    protected String m_convertOutOfQualified;
    protected String m_convertIntoQualified;

    public SqlName(String schema, String type, boolean fromDB, int line, int col, SqlReflector reflector) {
        this(schema, type, fromDB, line, col, false, false, null, null, null, reflector);
    }

    public SqlName(String schema, String type, boolean fromDB, SqlReflector reflector) {
        this(schema, type, fromDB, 0, 0, false, false, null, null, null, reflector);
    }

    SqlName(String plsql, String sql) {
        this(null, plsql, true, true, true, null, null, sql, null);
    }

    public SqlName(String schema, String type, boolean fromDB, boolean printAsIs, boolean predefined, String convertInto, String convertOutOf, String conversionTarget, SqlReflector reflector) {
        this(schema, type, fromDB, 0, 0, printAsIs, predefined, convertInto, convertOutOf, conversionTarget, reflector);
    }

    protected SqlName(String schema, String type, boolean fromDB, int line, int col, boolean printAsIs, boolean predefined, String convertInto, String convertOutOf, String conversionTarget, SqlReflector reflector) {
        super(SqlName.massageSchema(schema, fromDB, predefined, reflector), fromDB ? type : reflector.getViewCache().dbifyName(type));
        if (this.m_context == null) {
            this.m_context = "";
        }
        this.m_fromDB = fromDB;
        this.m_contextFromIntype = schema != null && !fromDB;
        this.m_line = line;
        this.m_column = col;
        this.m_quoted = SqlName.isQuoted(type);
        this.m_printAsIs = printAsIs;
        this.m_predefined = predefined;
        this.m_convertOutOf = convertOutOf;
        this.m_convertInto = convertInto;
        if (conversionTarget != null) {
            this.m_sourceName = this.m_name;
            this.m_name = conversionTarget;
        } else {
            this.m_sourceName = this.m_name;
        }
        this.m_convertOutOfQualified = convertOutOf;
        this.m_convertIntoQualified = convertInto;
    }

    public SqlName(String schema, String type, boolean fromDB, int line, int col, String packageName, SqlType parentType, SqlReflector reflector) {
        this(schema, null, fromDB, line, col, false, false, null, null, null, reflector);
        this.m_sourceName = type;
        if ((this.m_context == null || this.m_context.equals("")) && type.indexOf(46) >= 0) {
            this.m_context = type.substring(0, type.indexOf(46));
            this.m_sourceName = type.substring(type.indexOf(46) + 1);
        }
        String[] mSourceName = new String[]{this.m_sourceName};
        boolean[] mIsRowType = new boolean[]{this.m_isRowType};
        this.m_name = SqlName.determineSqlName(packageName, mSourceName, parentType, mIsRowType, reflector);
        this.m_sourceName = mSourceName[0];
        this.m_isRowType = mIsRowType[0];
        this.m_name = this.m_fromDB ? this.m_name : SqlName.dbifyName(this.m_name, reflector);
    }

    public static String interfaceIfPossible(SqlName sqlName, boolean itfIfPossible) {
        if (itfIfPossible && sqlName.hasUseItf()) {
            return sqlName.getUseItf();
        }
        if (sqlName.hasUseClass()) {
            return sqlName.getUseClass();
        }
        if (itfIfPossible && sqlName.hasDeclItf()) {
            return sqlName.getDeclItf();
        }
        return sqlName.getDeclClass();
    }

    public static String determineSqlName(String packageName, String[] sourceName, TypeClass parentType, boolean[] isRowType, SqlReflector reflector) {
        SqlName parentSqlName;
        String parentName = null;
        if (parentType != null && (parentSqlName = (SqlName)parentType.getNameObject()) != null) {
            parentName = SqlName.interfaceIfPossible(parentSqlName, true).toUpperCase();
        }
        String name = sourceName[0];
        reflector.addAllGeneratedTypeNames(name);
        if (name.indexOf(46) >= 0 && parentName != null) {
            name = parentName + "_" + name.substring(name.indexOf(46) + 1);
            reflector.addAllGeneratedTypeNames(parentName);
        }
        name = name.replace('.', '_').replace(' ', '_');
        boolean toBeDistinguished = false;
        if (sourceName[0].equals("PL/SQL RECORD")) {
            isRowType[0] = true;
            sourceName[0] = ROWTYPE_PL + m_rowtypeDistinguisher++;
            name = ROWTYPE_SQL;
            if (packageName != null && !packageName.equals("")) {
                name = parentName != null ? parentName + "_" + name : packageName + "_" + name;
            }
            toBeDistinguished = true;
        }
        return reflector.determineSqlName(name, toBeDistinguished);
    }

    public static void initStaticVariables() {
        SqlName.setDefaultSchema("");
        m_rowtypeDistinguisher = 0;
        m_sql2PLCounter = 0;
        m_pl2SQLCounter = 0;
    }

    public String getSchemaName() {
        return this.m_context;
    }

    public String getTypeName() {
        return this.m_sourceName;
    }

    public String getTargetTypeName() {
        if (this.m_name.equals("TIMESTAMP WITH LOCAL TZ")) {
            return "TIMESTAMP WITH LOCAL TIME ZONE";
        }
        if (this.m_name.equals("TIMESTAMP WITH TZ")) {
            return "TIMESTAMP WITH TIME ZONE";
        }
        if (this.m_name.equals("BOOLEAN")) {
            return "INTEGER";
        }
        return this.m_name;
    }

    public String getFullTargetTypeName(int schemaName) {
        return this.getFullTypeName(this.getTargetTypeName(), schemaName);
    }

    @Override
    public String getUseClass(String currPackage) {
        return ((JavaName)this.getLangName()).getUseClass(currPackage);
    }

    @Override
    public String getUseClass() {
        return ((JavaName)this.getLangName()).getUseClass();
    }

    @Override
    public String getUseClass(boolean full) {
        return ((JavaName)this.getLangName()).getUseClass(full);
    }

    @Override
    public String getUsePackage() {
        return ((JavaName)this.getLangName()).getUsePackage();
    }

    @Override
    public boolean hasUseClass() {
        return ((JavaName)this.getLangName()).hasUseClass();
    }

    @Override
    public String getUseItf() {
        return ((JavaName)this.getLangName()).getUseItf();
    }

    public String getUseItf(String currPackage) {
        return ((JavaName)this.getLangName()).getUseItf(currPackage);
    }

    @Override
    public String getUseItfPackage() {
        return ((JavaName)this.getLangName()).getUseItfPackage();
    }

    @Override
    public boolean hasUseItf() {
        return this.getUseItf() != null;
    }

    @Override
    public boolean hasDeclItf() {
        return this.getDeclItf() != null;
    }

    public boolean getFromDB() {
        return this.m_fromDB;
    }

    public int getLine() {
        return this.m_line;
    }

    public int getColumn() {
        return this.m_column;
    }

    public boolean isQuoted() {
        return this.m_quoted;
    }

    public static boolean isQuoted(String str) {
        return str != null && str.startsWith("\"") && str.endsWith("\"");
    }

    @Override
    public String getDeclClass() {
        return this.getLangName().getDeclClass();
    }

    @Override
    public String getDeclPackage() {
        return this.getLangName().getDeclPackage();
    }

    public String getDeclClass(String currPackage) {
        return ((JavaName)this.getLangName()).getDeclClass(currPackage);
    }

    @Override
    public String getDeclItf() {
        return ((JavaName)this.getLangName()).getDeclItf();
    }

    public String getDeclItf(String currPackage) {
        return ((JavaName)this.getLangName()).getDeclItf(currPackage);
    }

    @Override
    public String getDeclItfPackage() {
        return ((JavaName)this.getLangName()).getDeclItfPackage();
    }

    public LangName getLangName() {
        LangName j = (LangName)this.getAnnotation();
        if (j == null) {
            j = this.setLangName("", null, null, null, null, null, null, null, true);
        }
        return j;
    }

    public LangName setLangName(String packageName, String useName, String useItf, String generatedName, String generatedItf, String hfile, SqlType firstParent, String cppfile, boolean userNameGiven) {
        LangName langName = (LangName)this.getAnnotation();
        if (langName == null) {
            if (useName == null) {
                useName = SqlName.sqlIdToJavaId(this.m_name, true);
            }
            langName = new JavaName(packageName, useName, useItf, generatedName, generatedItf);
            this.setAnnotation(langName);
        }
        return langName;
    }

    @Override
    public String toString() {
        String fullName;
        String string = this.m_sourceName.equals("") ? "<top-level scope>" : (fullName = this.m_printAsIs || this.m_sourceName.indexOf(".") < 0 ? this.m_sourceName : "\"" + this.m_sourceName + "\"");
        if (this.m_context != "") {
            String schemaName = this.m_printAsIs || this.m_context.indexOf(".") < 0 ? this.m_context : "\"" + this.m_context + "\"";
            fullName = schemaName + "." + fullName;
        }
        return this.stripPublic(fullName);
    }

    public String toQuotedString(boolean omitSchemaName) {
        return "\"" + this.toString(omitSchemaName) + "\"";
    }

    private String toString(boolean omitSchemaName) {
        if (!this.m_context.equals(m_defaultSchema)) {
            omitSchemaName = false;
        }
        String name = null;
        name = omitSchemaName || this.m_context == null || this.m_context.equals("") ? this.getTargetTypeName() : this.m_context + "." + this.getTargetTypeName();
        return this.stripPublic(name);
    }

    public String getQuotedSimpleName() {
        return (this.m_quoted ? "\"" : "") + this.getSimpleName() + (this.m_quoted ? "\"" : "");
    }

    public static void setDefaultSchema(String defaultSchema) {
        m_defaultSchema = defaultSchema;
    }

    public static void setCase(int caseOption) {
        m_case = caseOption;
    }

    public static int getCase() {
        return m_case;
    }

    public static void setTargetLang(int targetLang) {
        m_targetLang = targetLang;
    }

    public static int getTargetLang() {
        return m_targetLang;
    }

    public static boolean langIsOtt() {
        return false;
    }

    public static boolean langIsC() {
        return false;
    }

    public static boolean langIsCpp() {
        return false;
    }

    public static boolean containsLowerChar(String s) {
        for (char ch : s.toCharArray()) {
            if (!Character.isLetterOrDigit(ch) || !Character.isLowerCase(ch)) continue;
            return true;
        }
        return false;
    }

    public static String sqlIdToJavaId(String s, boolean wordBoundary) {
        return SqlName.sqlIdToJavaId(s, wordBoundary, false);
    }

    public static String sqlIdToJavaId(String s, boolean wordBoundary, boolean avoidJavaPrimitives) {
        if (s.equals("__return")) {
            return "_return";
        }
        boolean needToWarn = false;
        char[] carr = s.toCharArray();
        int len = carr.length;
        int destPos = 0;
        if (m_case == 4) {
            for (int sourcePos = 0; sourcePos < len; ++sourcePos) {
                char ch = carr[sourcePos];
                if (Character.isLetterOrDigit(ch)) {
                    carr[destPos++] = wordBoundary ? Character.toTitleCase(ch) : Character.toLowerCase(ch);
                    wordBoundary = false;
                    continue;
                }
                wordBoundary = true;
            }
        } else {
            for (int sourcePos = 0; sourcePos < len; ++sourcePos) {
                char ch = carr[sourcePos];
                if (Character.isJavaIdentifierPart(ch)) {
                    switch (m_case) {
                        case 2: {
                            carr[destPos] = Character.toUpperCase(ch);
                            break;
                        }
                        case 3: {
                            carr[destPos] = Character.toLowerCase(ch);
                            break;
                        }
                        case 5: {
                            if (Character.isUpperCase(ch)) {
                                carr[destPos] = Character.toLowerCase(ch);
                                break;
                            }
                            if (!Character.isLowerCase(ch)) break;
                            carr[destPos] = Character.toUpperCase(ch);
                            break;
                        }
                        default: {
                            carr[destPos] = ch;
                        }
                    }
                    ++destPos;
                    continue;
                }
                needToWarn = true;
            }
        }
        if (destPos == 0 || needToWarn) {
            // empty if block
        }
        return new String(carr, 0, destPos);
    }

    public static boolean isAlpha(char ch) {
        String lettersStr = new String("abcdefghijklmnopqrstuvwxyz");
        char[] chars = lettersStr.toCharArray();
        ch = Character.toLowerCase(ch);
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            if (chars[i] != ch) continue;
            return true;
        }
        return false;
    }

    private static String massageSchema(String schema, boolean fromDB, boolean predefined, SqlReflector reflector) {
        if (schema == null) {
            schema = "";
        }
        if (predefined) {
            schema = schema.length() > 0 ? reflector.getViewCache().dbifyName(schema) : schema;
        } else if (!fromDB) {
            schema = schema.length() > 0 ? reflector.getViewCache().dbifyName(schema) : m_defaultSchema;
        }
        return schema;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlName)) {
            return false;
        }
        SqlName n = (SqlName)obj;
        boolean eq = this.m_context == null || n.m_context == null || this.m_context.equals("") || n.m_context.equals("") ? this.m_sourceName.equalsIgnoreCase(n.m_sourceName) : this.m_context.equalsIgnoreCase(n.m_context) && this.m_sourceName.equalsIgnoreCase(n.m_sourceName);
        return eq;
    }

    @Override
    public int hashCode() {
        return this.m_sourceName.hashCode();
    }

    public boolean isRowType() {
        return this.m_isRowType;
    }

    public boolean isPredefined() {
        return this.m_predefined;
    }

    public boolean hasConversion() {
        if (this.m_hasConversion == null) {
            this.m_hasConversion = this.getIntoConversion() != null || this.getOutOfConversion() != null;
        }
        return this.m_hasConversion;
    }

    public String getOutOfConversion() {
        if (this.m_name.equals(this.m_sourceName)) {
            return null;
        }
        if (this.isPredefined()) {
            return this.m_convertOutOf;
        }
        if (this.m_convertOutOf != null) {
            return this.m_convertOutOf;
        }
        this.m_convertOutOf = "PL_TO_SQL" + m_pl2SQLCounter++;
        return this.m_convertOutOf;
    }

    public String getIntoConversion() {
        if (this.m_name.equals(this.m_sourceName)) {
            return null;
        }
        if (this.isPredefined()) {
            return this.m_convertInto;
        }
        if (this.m_convertInto != null) {
            return this.m_convertInto;
        }
        this.m_convertInto = "SQL_TO_PL" + m_sql2PLCounter++;
        return this.m_convertInto;
    }

    public String getOutOfConversionQualified() {
        if (this.getOutOfConversion() == null) {
            return null;
        }
        return this.m_convertOutOfQualified;
    }

    public String getIntoConversionQualified() {
        if (this.getIntoConversion() == null) {
            return null;
        }
        return this.m_convertIntoQualified;
    }

    public String getFullTypeName(int schemaName) {
        return this.getFullTypeName(this.getTypeName(), schemaName);
    }

    private String getFullTypeName(String typeName, int schemaName) {
        String name = null;
        name = this.m_context != null && !this.m_context.equals("") && this.m_contextFromIntype ? this.m_context + "." + typeName : typeName;
        return this.stripPublic(name);
    }

    public boolean isReused() {
        return this.m_isReused;
    }

    public static String dbifyName(String s, SqlReflector reflector) {
        if (s == null || s.equals("") || reflector == null || reflector.getConnection() == null) {
            return s;
        }
        return SqlName.dbifyName(s, reflector.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dbifyName(String s, Connection conn) {
        String upper_s = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT UPPER(:1) AS UPPER_NAME FROM DUAL");
            stmt.setString(1, s);
            rs = stmt.executeQuery();
            if (rs.next()) {
                upper_s = rs.getString(1);
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            upper_s = s;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException _) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException _) {}
            }
        }
        String dbName = SqlName.isQuoted(s) ? s.substring(1, s.length() - 1) : (upper_s == null ? "" : upper_s);
        return dbName;
    }

    private String stripPublic(String name) {
        if (name.startsWith(PUBLIC)) {
            name = name.substring(PUBLIC.length());
        }
        return name;
    }

    static {
        m_sql2PLCounter = 0;
        m_pl2SQLCounter = 0;
    }
}

