/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import org.eclipse.persistence.annotations.Direction;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLComplexTypeMetadata;
import org.eclipse.persistence.platform.database.jdbc.JDBCTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.OraclePLSQLTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredFunctionCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLrecord;

public class PLSQLParameterMetadata
extends ORMetadata {
    private String m_direction;
    private Boolean m_optional;
    private String m_databaseType;
    private String m_name;
    private String m_queryParameter;
    private Integer m_length;
    private Integer m_precision;
    private Integer m_scale;

    public PLSQLParameterMetadata() {
        super("<plsql-parameter>");
    }

    public PLSQLParameterMetadata(MetadataAnnotation storedProcedureParameter, MetadataAccessor accessor) {
        super(storedProcedureParameter, accessor);
        this.m_direction = (String)storedProcedureParameter.getAttribute("direction");
        this.m_name = (String)storedProcedureParameter.getAttribute("name");
        this.m_queryParameter = (String)storedProcedureParameter.getAttribute("queryParameter");
        this.m_databaseType = (String)storedProcedureParameter.getAttribute("databaseType");
        this.m_optional = (Boolean)storedProcedureParameter.getAttribute("optional");
        this.m_length = (Integer)storedProcedureParameter.getAttribute("length");
        this.m_precision = (Integer)storedProcedureParameter.getAttribute("precision");
        this.m_scale = (Integer)storedProcedureParameter.getAttribute("scale");
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof PLSQLParameterMetadata) {
            PLSQLParameterMetadata parameter = (PLSQLParameterMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_databaseType, parameter.getDatabaseType())) {
                return false;
            }
            if (!this.valuesMatch(this.m_direction, parameter.getDirection())) {
                return false;
            }
            if (!this.valuesMatch(this.m_length, parameter.getLength())) {
                return false;
            }
            if (!this.valuesMatch(this.m_precision, parameter.getPrecision())) {
                return false;
            }
            if (!this.valuesMatch(this.m_name, parameter.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_optional, parameter.getOptional())) {
                return false;
            }
            return this.valuesMatch(this.m_queryParameter, parameter.getQueryParameter());
        }
        return false;
    }

    public String getDatabaseType() {
        return this.m_databaseType;
    }

    public static DatabaseType getDatabaseTypeEnum(String type, MetadataProject project) {
        if (type == null) {
            return JDBCTypes.VARCHAR_TYPE;
        }
        try {
            return JDBCTypes.valueOf((String)type);
        }
        catch (Exception invalid) {
            try {
                return OraclePLSQLTypes.valueOf((String)type);
            }
            catch (Exception alsoInvalid) {
                PLSQLComplexTypeMetadata typeMetadata = project.getPLSQLComplexType(type);
                if (typeMetadata != null) {
                    return typeMetadata.process(project);
                }
                PLSQLrecord record = new PLSQLrecord();
                record.setTypeName(type);
                return record;
            }
        }
    }

    public String getDirection() {
        return this.m_direction;
    }

    public Integer getLength() {
        return this.m_length;
    }

    public String getName() {
        return this.m_name;
    }

    public Boolean getOptional() {
        return this.m_optional;
    }

    public Integer getPrecision() {
        return this.m_precision;
    }

    public String getQueryParameter() {
        return this.m_queryParameter;
    }

    public Integer getScale() {
        return this.m_scale;
    }

    public void process(PLSQLStoredProcedureCall call, MetadataProject project, boolean functionReturn) {
        String procedureParameterName = this.m_name;
        if (this.m_name == null || this.m_name.equals("")) {
            procedureParameterName = this.m_queryParameter;
        }
        if (this.m_optional != null && this.m_optional.booleanValue()) {
            call.addOptionalArgument(procedureParameterName);
        }
        DatabaseType type = PLSQLParameterMetadata.getDatabaseTypeEnum(this.getDatabaseType(), project);
        if (functionReturn) {
            if (this.getLength() != null) {
                ((PLSQLStoredFunctionCall)call).setResult(type, this.getLength().intValue());
            } else if (this.getPrecision() != null) {
                ((PLSQLStoredFunctionCall)call).setResult(type, this.getPrecision().intValue(), this.getScale().intValue());
            } else {
                ((PLSQLStoredFunctionCall)call).setResult(type);
            }
        } else if (this.m_direction == null || this.m_direction.equals(Direction.IN.name())) {
            if (this.getLength() != null) {
                call.addNamedArgument(procedureParameterName, type, this.getLength().intValue());
            } else if (this.getPrecision() != null) {
                call.addNamedArgument(procedureParameterName, type, this.getPrecision().intValue(), this.getScale().intValue());
            } else {
                call.addNamedArgument(procedureParameterName, type);
            }
        } else if (this.m_direction.equals(Direction.OUT.name())) {
            if (this.getLength() != null) {
                call.addNamedOutputArgument(procedureParameterName, type, this.getLength().intValue());
            } else if (this.getPrecision() != null) {
                call.addNamedOutputArgument(procedureParameterName, type, this.getPrecision().intValue(), this.getScale().intValue());
            } else {
                call.addNamedOutputArgument(procedureParameterName, type);
            }
        } else if (this.m_direction.equals(Direction.IN_OUT.name())) {
            if (this.getLength() != null) {
                call.addNamedInOutputArgument(procedureParameterName, type, this.getLength().intValue());
            } else if (this.getPrecision() != null) {
                call.addNamedInOutputArgument(procedureParameterName, type, this.getPrecision().intValue(), this.getScale().intValue());
            } else {
                call.addNamedInOutputArgument(procedureParameterName, type);
            }
        } else if (this.m_direction.equals(Direction.OUT_CURSOR.name())) {
            boolean multipleCursors = false;
            if (call.getParameterTypes().contains(PLSQLStoredProcedureCall.OUT_CURSOR)) {
                multipleCursors = true;
            }
            call.useNamedCursorOutputAsResultSet(procedureParameterName);
            if (multipleCursors) {
                call.setIsCursorOutputProcedure(false);
            }
        }
    }

    protected void setDatabaseFieldSettings(DatabaseField field, MetadataProject project) {
        if (project.useDelimitedIdentifier()) {
            field.setUseDelimiters(true);
        } else if (project.getShouldForceFieldNamesToUpperCase() && !field.shouldUseDelimiters()) {
            field.useUpperCaseForComparisons(true);
        }
    }

    public void setDatabaseType(String databaseType) {
        this.m_databaseType = databaseType;
    }

    public void setDirection(String direction) {
        this.m_direction = direction;
    }

    public void setLength(Integer length) {
        this.m_length = length;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setOptional(Boolean optional) {
        this.m_optional = optional;
    }

    public void setPrecision(Integer precision) {
        this.m_precision = precision;
    }

    public void setQueryParameter(String queryParameter) {
        this.m_queryParameter = queryParameter;
    }

    public void setScale(Integer scale) {
        this.m_scale = scale;
    }
}

