/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.diff.ArrayAdapter;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.DifferentiatorAdapter;
import org.eclipse.persistence.tools.workbench.utility.diff.EqualityDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.ListAdapter;
import org.eclipse.persistence.tools.workbench.utility.diff.NullDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.OrderedContainerDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.OrderedContainerElementDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.SimpleDiff;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class OrderedContainerDifferentiator
implements Differentiator {
    private Adapter adapter;
    private Differentiator elementDifferentiator;
    static final Object UNDEFINED_ELEMENT = new Object(){

        public String toString() {
            return "<undefined>";
        }
    };

    public static OrderedContainerDifferentiator forLists() {
        return new OrderedContainerDifferentiator(ListAdapter.instance());
    }

    public static OrderedContainerDifferentiator forLists(Differentiator elementDifferentiator) {
        return new OrderedContainerDifferentiator(ListAdapter.instance(), elementDifferentiator);
    }

    public static OrderedContainerDifferentiator forArrays() {
        return new OrderedContainerDifferentiator(ArrayAdapter.instance());
    }

    public static OrderedContainerDifferentiator forArrays(Differentiator elementDifferentiator) {
        return new OrderedContainerDifferentiator(ArrayAdapter.instance(), elementDifferentiator);
    }

    public OrderedContainerDifferentiator() {
        this(Adapter.INVALID_INSTANCE);
    }

    public OrderedContainerDifferentiator(Differentiator elementDifferentiator) {
        this(Adapter.INVALID_INSTANCE, elementDifferentiator);
    }

    public OrderedContainerDifferentiator(Adapter adapter) {
        this(adapter, EqualityDifferentiator.instance());
    }

    public OrderedContainerDifferentiator(Adapter adapter, Differentiator elementDifferentiator) {
        this.adapter = adapter;
        this.elementDifferentiator = elementDifferentiator;
    }

    public Diff diff(Object object1, Object object2) {
        return this.diff(object1, object2, DifferentiatorAdapter.NORMAL);
    }

    public Diff keyDiff(Object object1, Object object2) {
        return this.diff(object1, object2, DifferentiatorAdapter.KEY);
    }

    private Diff diff(Object object1, Object object2, DifferentiatorAdapter drAdapter) {
        Diff[] diffs;
        block7: {
            Diff elementDiff;
            int i;
            if (object1 == object2) {
                return new NullDiff(object1, object2, this);
            }
            if (this.diffIsFatal(object1, object2)) {
                return new SimpleDiff(object1, object2, this.fatalDescriptionTitle(), this);
            }
            int size1 = this.size(object1);
            int size2 = this.size(object2);
            int min = Math.min(size1, size2);
            int max = Math.max(size1, size2);
            diffs = new Diff[max];
            for (i = 0; i < min; ++i) {
                elementDiff = drAdapter.diff(this.elementDifferentiator, this.get(object1, i), this.get(object2, i));
                diffs[i] = new OrderedContainerElementDiff(i, elementDiff, this);
            }
            if (min == max) break block7;
            if (size1 < size2) {
                for (i = min; i < max; ++i) {
                    elementDiff = new SimpleDiff(UNDEFINED_ELEMENT, this.get(object2, i), this.missingElementDescriptionTitle(i), this);
                    diffs[i] = new OrderedContainerElementDiff(i, elementDiff, this);
                }
            } else {
                for (i = min; i < max; ++i) {
                    elementDiff = new SimpleDiff(this.get(object1, i), UNDEFINED_ELEMENT, this.missingElementDescriptionTitle(i), this);
                    diffs[i] = new OrderedContainerElementDiff(i, elementDiff, this);
                }
            }
        }
        return new OrderedContainerDiff(this.containerClass(), object1, object2, diffs, this);
    }

    private String missingElementDescriptionTitle(int index) {
        return "Only one of the " + ClassTools.shortNameFor(this.containerClass()) + "s has a value at index " + index;
    }

    private String fatalDescriptionTitle() {
        return "The two " + ClassTools.shortNameFor(this.containerClass()) + "s cannot be compared";
    }

    public boolean comparesValueObjects() {
        return false;
    }

    public Differentiator getElementDifferentiator() {
        return this.elementDifferentiator;
    }

    public void setElementDifferentiator(Differentiator elementDifferentiator) {
        this.elementDifferentiator = elementDifferentiator;
    }

    protected boolean diffIsFatal(Object object1, Object object2) {
        return this.adapter.diffIsFatal(object1, object2);
    }

    protected Class containerClass() {
        return this.adapter.containerClass();
    }

    protected int size(Object container) {
        return this.adapter.size(container);
    }

    protected Object get(Object container, int index) {
        return this.adapter.get(container, index);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.elementDifferentiator);
    }

    public static interface Adapter {
        public static final Adapter INVALID_INSTANCE = new Adapter(){

            public boolean diffIsFatal(Object object1, Object object2) {
                throw new UnsupportedOperationException();
            }

            public Class containerClass() {
                throw new UnsupportedOperationException();
            }

            public int size(Object container) {
                throw new UnsupportedOperationException();
            }

            public Object get(Object container, int index) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "InvalidAdapter";
            }
        };

        public boolean diffIsFatal(Object var1, Object var2);

        public Class containerClass();

        public int size(Object var1);

        public Object get(Object var1, int var2);
    }
}

