/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class ExceptionsAttribute
extends Attribute {
    private short count;
    private short[] exceptionIndexes;

    ExceptionsAttribute(ClassFileDataInputStream stream, short nameIndex, AttributePool pool) throws IOException {
        super(stream, nameIndex, pool);
    }

    void initializeInfo(ClassFileDataInputStream stream) throws IOException {
        short cnt = this.count = stream.readU2();
        short[] indexes = this.exceptionIndexes = new short[cnt];
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            indexes[i] = stream.readU2();
        }
    }

    void displayInfoStringOn(IndentingPrintWriter writer) {
        short cnt = this.count;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            writer.println(this.exceptionClassName(i));
        }
    }

    public String exceptionClassName(short index) {
        return this.constantPool().getClassConstant(this.exceptionIndexes[index]).name();
    }

    public String[] exceptionClassNames() {
        short cnt = this.count;
        if (cnt == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] exceptionClassNames = new String[cnt];
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            exceptionClassNames[i] = this.exceptionClassName(i);
        }
        return exceptionClassNames;
    }

    public void printThrowsClauseOn(PrintWriter writer) {
        short cnt = this.count;
        if (cnt == 0) {
            return;
        }
        writer.print(" throws ");
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            if (i != 0) {
                writer.print(", ");
            }
            writer.print(this.exceptionClassName(i));
        }
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public short getCount() {
        return this.count;
    }

    public short[] getExceptionIndexes() {
        return this.exceptionIndexes;
    }

    public short getExceptionIndex(short index) {
        return this.exceptionIndexes[index];
    }

    void toString(StringBuffer sb) {
        sb.append(this.count);
        sb.append(" exception(s)");
    }
}

