/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.tools.workbench.utility.Bag;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.Range;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionTools {
    private static final Random RANDOM = new Random();

    public static Object[] add(Object[] array, Object o) {
        int len = array.length;
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), len + 1);
        System.arraycopy(array, 0, result, 0, len);
        result[len] = o;
        return result;
    }

    public static Object[] add(Object[] array, int index, Object o) {
        int len = array.length;
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), len + 1);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        result[index] = o;
        if (len > index) {
            System.arraycopy(array, index, result, index + 1, len - index);
        }
        return result;
    }

    public static char[] add(char[] array, char value) {
        int len = array.length;
        char[] result = new char[len + 1];
        System.arraycopy(array, 0, result, 0, len);
        result[len] = value;
        return result;
    }

    public static char[] add(char[] array, int index, char value) {
        int len = array.length;
        char[] result = new char[len + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, len - index);
        return result;
    }

    public static int[] add(int[] array, int value) {
        int len = array.length;
        int[] result = new int[len + 1];
        System.arraycopy(array, 0, result, 0, len);
        result[len] = value;
        return result;
    }

    public static int[] add(int[] array, int index, int value) {
        int len = array.length;
        int[] result = new int[len + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, len - index);
        return result;
    }

    public static boolean addAll(Collection collection, Iterator iterator) {
        boolean modified = false;
        while (iterator.hasNext()) {
            modified |= collection.add(iterator.next());
        }
        return modified;
    }

    public static boolean addAll(Collection collection, Object[] array) {
        boolean modified = false;
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            modified |= collection.add(array[i]);
        }
        return modified;
    }

    public static Object[] addAll(Object[] array, Collection c) {
        int len = array.length;
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + c.size());
        System.arraycopy(array, 0, result, 0, len);
        int i = len;
        Iterator stream = c.iterator();
        while (stream.hasNext()) {
            result[i] = stream.next();
            ++i;
        }
        return result;
    }

    public static Object[] addAll(Object[] array, Iterator iterator) {
        return CollectionTools.addAll(array, CollectionTools.list(iterator));
    }

    public static Object[] addAll(Object[] array1, Object[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        Object[] result = (Object[])Array.newInstance(array1.getClass().getComponentType(), len1 + len2);
        System.arraycopy(array1, 0, result, 0, len1);
        System.arraycopy(array2, 0, result, len1, len2);
        return result;
    }

    public static Object[] addAll(Object[] array1, int index, Object[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        Object[] result = (Object[])Array.newInstance(array1.getClass().getComponentType(), len1 + len2);
        System.arraycopy(array1, 0, result, 0, index);
        System.arraycopy(array2, 0, result, index, len2);
        System.arraycopy(array1, index, result, index + len2, len1 - index);
        return result;
    }

    public static char[] addAll(char[] array1, char[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        char[] result = new char[len1 + len2];
        System.arraycopy(array1, 0, result, 0, len1);
        System.arraycopy(array2, 0, result, len1, len2);
        return result;
    }

    public static char[] addAll(char[] array1, int index, char[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        char[] result = new char[len1 + len2];
        System.arraycopy(array1, 0, result, 0, index);
        System.arraycopy(array2, 0, result, index, len2);
        System.arraycopy(array1, index, result, index + len2, len1 - index);
        return result;
    }

    public static int[] addAll(int[] array1, int[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        int[] result = new int[len1 + len2];
        System.arraycopy(array1, 0, result, 0, len1);
        System.arraycopy(array2, 0, result, len1, len2);
        return result;
    }

    public static int[] addAll(int[] array1, int index, int[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        int[] result = new int[len1 + len2];
        System.arraycopy(array1, 0, result, 0, index);
        System.arraycopy(array2, 0, result, index, len2);
        System.arraycopy(array1, index, result, index + len2, len1 - index);
        return result;
    }

    public static Object[] array(Iterator iterator) {
        return CollectionTools.list(iterator).toArray();
    }

    public static Object[] array(Iterator iterator, Object[] array) {
        return CollectionTools.list(iterator).toArray(array);
    }

    public static Bag bag(Enumeration enumeration) {
        HashBag bag = new HashBag();
        while (enumeration.hasMoreElements()) {
            bag.add(enumeration.nextElement());
        }
        return bag;
    }

    public static Bag bag(Iterator iterator) {
        HashBag bag = new HashBag();
        while (iterator.hasNext()) {
            bag.add(iterator.next());
        }
        return bag;
    }

    public static Bag bag(Object[] array) {
        HashBag bag = new HashBag(array.length);
        int i = array.length;
        while (i-- > 0) {
            bag.add(array[i]);
        }
        return bag;
    }

    public static Collection collection(Enumeration enumeration) {
        return CollectionTools.bag(enumeration);
    }

    public static Collection collection(Iterator iterator) {
        return CollectionTools.bag(iterator);
    }

    public static Collection collection(Object[] array) {
        return CollectionTools.bag(array);
    }

    public static boolean contains(Enumeration enumeration, Object o) {
        if (o == null) {
            while (enumeration.hasMoreElements()) {
                if (enumeration.nextElement() != null) continue;
                return true;
            }
        } else {
            while (enumeration.hasMoreElements()) {
                if (!o.equals(enumeration.nextElement())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Iterator iterator, Object o) {
        if (o == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!o.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Object[] array, Object o) {
        if (o == null) {
            int i = array.length;
            while (i-- > 0) {
                if (array[i] != null) continue;
                return true;
            }
        } else {
            int i = array.length;
            while (i-- > 0) {
                if (!o.equals(array[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(char[] array, char value) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] array, int value) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(Collection collection, Iterator iterator) {
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Collection collection, Object[] array) {
        int i = array.length;
        while (i-- > 0) {
            if (collection.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Iterator iterator, Collection collection) {
        return CollectionTools.collection(iterator).containsAll(collection);
    }

    public static boolean containsAll(Iterator iterator1, Iterator iterator2) {
        return CollectionTools.containsAll(CollectionTools.collection(iterator1), iterator2);
    }

    public static boolean containsAll(Iterator iterator, Object[] array) {
        return CollectionTools.containsAll(CollectionTools.collection(iterator), array);
    }

    public static boolean containsAll(Object[] array, Collection collection) {
        return CollectionTools.containsAll(array, collection.iterator());
    }

    public static boolean containsAll(Object[] array, Iterator iterator) {
        while (iterator.hasNext()) {
            if (CollectionTools.contains(array, iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Object[] array1, Object[] array2) {
        int i = array2.length;
        while (i-- > 0) {
            if (CollectionTools.contains(array1, array2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(char[] array1, char[] array2) {
        int i = array2.length;
        while (i-- > 0) {
            if (CollectionTools.contains(array1, array2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(int[] array1, int[] array2) {
        int i = array2.length;
        while (i-- > 0) {
            if (CollectionTools.contains(array1, array2[i])) continue;
            return false;
        }
        return true;
    }

    public static int diffEnd(Object[] array1, Object[] array2) {
        return CollectionTools.diffEnd(Arrays.asList(array1), Arrays.asList(array2));
    }

    public static int diffEnd(List list1, List list2) {
        int size2;
        int size1 = list1.size();
        if (size1 != (size2 = list2.size())) {
            return Math.max(size1, size2) - 1;
        }
        int end = size1 - 1;
        while (end > -1) {
            Object e = list1.get(end);
            if (e == null) {
                if (list2.get(end) == null) {
                    --end;
                    continue;
                }
                return end;
            }
            if (e.equals(list2.get(end))) {
                --end;
                continue;
            }
            return end;
        }
        return end;
    }

    public static Range diffRange(Object[] array1, Object[] array2) {
        return CollectionTools.diffRange(Arrays.asList(array1), Arrays.asList(array2));
    }

    public static Range diffRange(List list1, List list2) {
        int end = CollectionTools.diffEnd(list1, list2);
        if (end == -1) {
            return new Range(list1.size(), end);
        }
        return new Range(CollectionTools.diffStart(list1, list2), end);
    }

    public static int diffStart(Object[] array1, Object[] array2) {
        return CollectionTools.diffStart(Arrays.asList(array1), Arrays.asList(array2));
    }

    public static int diffStart(List list1, List list2) {
        int end = Math.min(list1.size(), list2.size());
        int start = 0;
        while (start < end) {
            Object e = list1.get(start);
            if (e == null) {
                if (list2.get(start) == null) {
                    ++start;
                    continue;
                }
                return start;
            }
            if (e.equals(list2.get(start))) {
                ++start;
                continue;
            }
            return start;
        }
        return start;
    }

    public static boolean equals(ListIterator iterator1, ListIterator iterator2) {
        while (iterator1.hasNext() && iterator2.hasNext()) {
            Object o1 = iterator1.next();
            Object o2 = iterator2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static Object get(ListIterator iterator, int index) {
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (iterator.previousIndex() != index) continue;
            return next;
        }
        throw new IndexOutOfBoundsException(String.valueOf(index) + ':' + String.valueOf(iterator.previousIndex()));
    }

    public static boolean identical(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        int length = array1.length;
        if (array2.length != length) {
            return false;
        }
        int i = length;
        while (i-- > 0) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean identical(ListIterator iterator1, ListIterator iterator2) {
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (iterator1.next() == iterator2.next()) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static int identityDiffEnd(Object[] array1, Object[] array2) {
        return CollectionTools.identityDiffEnd(Arrays.asList(array1), Arrays.asList(array2));
    }

    public static int identityDiffEnd(List list1, List list2) {
        int end;
        int size2;
        int size1 = list1.size();
        if (size1 != (size2 = list2.size())) {
            return Math.max(size1, size2) - 1;
        }
        for (end = size1 - 1; end > -1; --end) {
            if (list1.get(end) == list2.get(end)) {
                continue;
            }
            return end;
        }
        return end;
    }

    public static Range identityDiffRange(Object[] array1, Object[] array2) {
        return CollectionTools.identityDiffRange(Arrays.asList(array1), Arrays.asList(array2));
    }

    public static Range identityDiffRange(List list1, List list2) {
        int end = CollectionTools.identityDiffEnd(list1, list2);
        if (end == -1) {
            return new Range(list1.size(), end);
        }
        return new Range(CollectionTools.identityDiffStart(list1, list2), end);
    }

    public static int identityDiffStart(Object[] array1, Object[] array2) {
        return CollectionTools.identityDiffStart(Arrays.asList(array1), Arrays.asList(array2));
    }

    public static int identityDiffStart(List list1, List list2) {
        int start;
        int end = Math.min(list1.size(), list2.size());
        for (start = 0; start < end; ++start) {
            if (list1.get(start) == list2.get(start)) {
                continue;
            }
            return start;
        }
        return start;
    }

    public static int indexOf(ListIterator iterator, Object o) {
        if (o == null) {
            int i = 0;
            while (iterator.hasNext()) {
                if (iterator.next() == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (iterator.hasNext()) {
                if (o.equals(iterator.next())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int indexOf(Object[] array, Object o) {
        int len = array.length;
        if (o == null) {
            for (int i = 0; i < len; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (!o.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(char[] array, char value) {
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int value) {
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int insertionIndexOf(List sortedList, Comparable o) {
        int len = sortedList.size();
        for (int i = 0; i < len; ++i) {
            if (o.compareTo(sortedList.get(i)) >= 0) continue;
            return i;
        }
        return len;
    }

    public static int insertionIndexOf(List sortedList, Object o, Comparator c) {
        int len = sortedList.size();
        for (int i = 0; i < len; ++i) {
            if (c.compare(o, sortedList.get(i)) >= 0) continue;
            return i;
        }
        return len;
    }

    public static int insertionIndexOf(Object[] sortedArray, Comparable o) {
        int len = sortedArray.length;
        for (int i = 0; i < len; ++i) {
            if (o.compareTo(sortedArray[i]) >= 0) continue;
            return i;
        }
        return len;
    }

    public static int insertionIndexOf(Object[] sortedArray, Object o, Comparator c) {
        int len = sortedArray.length;
        for (int i = 0; i < len; ++i) {
            if (c.compare(o, sortedArray[i]) >= 0) continue;
            return i;
        }
        return len;
    }

    public static Iterator iterator(Object[] array) {
        return new ArrayIterator(array);
    }

    public static int lastIndexOf(ListIterator iterator, Object o) {
        return CollectionTools.list(iterator).lastIndexOf(o);
    }

    public static int lastIndexOf(Object[] array, Object o) {
        int len = array.length;
        if (o == null) {
            int i = len;
            while (i-- > 0) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            int i = len;
            while (i-- > 0) {
                if (!o.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(char[] array, char value) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int value) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static List list(Iterator iterator) {
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static <T> ListIterator<T> listIterator(Iterator<T> iterator) {
        return CollectionTools.list(iterator).listIterator();
    }

    public static List list(Object[] array) {
        int len = array.length;
        ArrayList<Object> list = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static ListIterator listIterator(Object[] array) {
        return CollectionTools.listIterator(array, 0);
    }

    public static ListIterator listIterator(Object[] array, int index) {
        return Arrays.asList(array).listIterator(index);
    }

    public static char max(char[] array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        char max = array[0];
        for (int i = 1; i < len; ++i) {
            char next = array[i];
            if (next <= max) continue;
            max = next;
        }
        return max;
    }

    public static int max(int[] array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        int max = array[0];
        for (int i = 1; i < len; ++i) {
            int next = array[i];
            if (next <= max) continue;
            max = next;
        }
        return max;
    }

    public static char min(char[] array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        char min = array[0];
        for (int i = 1; i < len; ++i) {
            char next = array[i];
            if (next >= min) continue;
            min = next;
        }
        return min;
    }

    public static int min(int[] array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        int min = array[0];
        for (int i = 1; i < len; ++i) {
            int next = array[i];
            if (next >= min) continue;
            min = next;
        }
        return min;
    }

    public static Object[] replaceAll(Object[] array, Object oldValue, Object newValue) {
        if (oldValue == null) {
            int i = array.length;
            while (i-- > 0) {
                if (array[i] != null) continue;
                array[i] = newValue;
            }
        } else {
            int i = array.length;
            while (i-- > 0) {
                if (!oldValue.equals(array[i])) continue;
                array[i] = newValue;
            }
        }
        return array;
    }

    public static int[] replaceAll(int[] array, int oldValue, int newValue) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != oldValue) continue;
            array[i] = newValue;
        }
        return array;
    }

    public static char[] replaceAll(char[] array, char oldValue, char newValue) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != oldValue) continue;
            array[i] = newValue;
        }
        return array;
    }

    public static Object[] remove(Object[] array, Object value) {
        int index = CollectionTools.indexOf(array, value);
        int len = array.length;
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), len - 1);
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + 1, result, index, len - index - 1);
        return result;
    }

    public static char[] remove(char[] array, char value) {
        int index = CollectionTools.indexOf(array, value);
        int len = array.length;
        char[] result = new char[len - 1];
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + 1, result, index, len - index - 1);
        return result;
    }

    public static int[] remove(int[] array, int value) {
        int index = CollectionTools.indexOf(array, value);
        int len = array.length;
        int[] result = new int[len - 1];
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + 1, result, index, len - index - 1);
        return result;
    }

    public static boolean removeAll(Collection collection, Iterator iterator) {
        boolean modified = false;
        while (iterator.hasNext()) {
            modified |= collection.remove(iterator.next());
        }
        return modified;
    }

    public static boolean removeAll(Collection collection, Object[] array) {
        boolean modified = false;
        int i = array.length;
        while (i-- > 0) {
            modified |= collection.remove(array[i]);
        }
        return modified;
    }

    public static Object[] removeAll(Object[] array, Collection collection) {
        Object[] result = array;
        int i = array.length;
        while (i-- > 0) {
            Object item = array[i];
            if (!collection.contains(item)) continue;
            result = CollectionTools.remove(result, item);
        }
        return result;
    }

    public static Object[] removeAll(Object[] array1, Object[] array2) {
        return CollectionTools.removeAll(array1, CollectionTools.bag(array2));
    }

    public static char[] removeAll(char[] array1, char[] array2) {
        char[] result = array1;
        int i = array1.length;
        while (i-- > 0) {
            char item = array1[i];
            if (!CollectionTools.contains(array2, item)) continue;
            result = CollectionTools.remove(result, item);
        }
        return result;
    }

    public static int[] removeAll(int[] array1, int[] array2) {
        int[] result = array1;
        int i = array1.length;
        while (i-- > 0) {
            int item = array1[i];
            if (!CollectionTools.contains(array2, item)) continue;
            result = CollectionTools.remove(result, item);
        }
        return result;
    }

    public static boolean removeAllOccurrences(Collection collection, Object value) {
        boolean modified = false;
        Iterator stream = collection.iterator();
        if (value == null) {
            while (stream.hasNext()) {
                if (stream.next() != null) continue;
                stream.remove();
                modified = true;
            }
        } else {
            while (stream.hasNext()) {
                if (!value.equals(stream.next())) continue;
                stream.remove();
                modified = true;
            }
        }
        return modified;
    }

    public static Object[] removeAllOccurrences(Object[] array, Object value) {
        Object[] result = array;
        if (value == null) {
            int i = array.length;
            while (i-- > 0) {
                if (array[i] != null) continue;
                result = CollectionTools.remove(result, null);
            }
        } else {
            int i = array.length;
            while (i-- > 0) {
                if (!value.equals(array[i])) continue;
                result = CollectionTools.remove(result, value);
            }
        }
        return result;
    }

    public static char[] removeAllOccurrences(char[] array, char value) {
        char[] result = array;
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != value) continue;
            result = CollectionTools.remove(result, value);
        }
        return result;
    }

    public static int[] removeAllOccurrences(int[] array, int value) {
        int[] result = array;
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != value) continue;
            result = CollectionTools.remove(result, value);
        }
        return result;
    }

    public static Object[] removeDuplicateElements(Object[] array) {
        List list = CollectionTools.removeDuplicateElements(Arrays.asList(array));
        return list.toArray((Object[])Array.newInstance(array.getClass().getComponentType(), list.size()));
    }

    public static List removeDuplicateElements(List list) {
        ArrayList result = new ArrayList(list.size());
        HashSet set = new HashSet(list.size());
        for (Object o : list) {
            if (!set.add(o)) continue;
            result.add(o);
        }
        return result;
    }

    public static boolean retainAll(Collection collection, Iterator iterator) {
        return collection.retainAll(CollectionTools.collection(iterator));
    }

    public static boolean retainAll(Collection collection, Object[] array) {
        boolean modified = false;
        Iterator stream = collection.iterator();
        while (stream.hasNext()) {
            if (CollectionTools.contains(array, stream.next())) continue;
            stream.remove();
            modified = true;
        }
        return modified;
    }

    public static Object[] retainAll(Object[] array, Collection collection) {
        Object[] result = array;
        int i = array.length;
        while (i-- > 0) {
            Object item = array[i];
            if (collection.contains(item)) continue;
            result = CollectionTools.remove(result, item);
        }
        return result;
    }

    public static Object[] retainAll(Object[] array1, Object[] array2) {
        return CollectionTools.retainAll(array1, CollectionTools.bag(array2));
    }

    public static char[] retainAll(char[] array1, char[] array2) {
        char[] result = array1;
        int i = array1.length;
        while (i-- > 0) {
            char item = array1[i];
            if (CollectionTools.contains(array2, item)) continue;
            result = CollectionTools.remove(result, item);
        }
        return result;
    }

    public static int[] retainAll(int[] array1, int[] array2) {
        int[] result = array1;
        int i = array1.length;
        while (i-- > 0) {
            int item = array1[i];
            if (CollectionTools.contains(array2, item)) continue;
            result = CollectionTools.remove(result, item);
        }
        return result;
    }

    public static Object[] reverse(Object[] array) {
        int len = array.length;
        int i = 0;
        int mid = len >> 1;
        int j = len - 1;
        while (i < mid) {
            CollectionTools.swap(array, i, j);
            ++i;
            --j;
        }
        return array;
    }

    public static char[] reverse(char[] array) {
        int len = array.length;
        int i = 0;
        int mid = len >> 1;
        int j = len - 1;
        while (i < mid) {
            CollectionTools.swap(array, i, j);
            ++i;
            --j;
        }
        return array;
    }

    public static int[] reverse(int[] array) {
        int len = array.length;
        int i = 0;
        int mid = len >> 1;
        int j = len - 1;
        while (i < mid) {
            CollectionTools.swap(array, i, j);
            ++i;
            --j;
        }
        return array;
    }

    public static List reverseList(Iterator iterator) {
        return CollectionTools.reverse(CollectionTools.list(iterator));
    }

    public static Object[] rotate(Object[] array) {
        return CollectionTools.rotate(array, 1);
    }

    public static Object[] rotate(Object[] array, int distance) {
        int len = array.length;
        if (len == 0) {
            return array;
        }
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return array;
        }
        int cycleStart = 0;
        int nMoved = 0;
        while (nMoved != len) {
            Object displaced = array[cycleStart];
            int i = cycleStart;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                Object temp = array[i];
                array[i] = displaced;
                displaced = temp;
                ++nMoved;
            } while (i != cycleStart);
            ++cycleStart;
        }
        return array;
    }

    public static char[] rotate(char[] array) {
        return CollectionTools.rotate(array, 1);
    }

    public static char[] rotate(char[] array, int distance) {
        int len = array.length;
        if (len == 0) {
            return array;
        }
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return array;
        }
        int cycleStart = 0;
        int nMoved = 0;
        while (nMoved != len) {
            char displaced = array[cycleStart];
            int i = cycleStart;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                char temp = array[i];
                array[i] = displaced;
                displaced = temp;
                ++nMoved;
            } while (i != cycleStart);
            ++cycleStart;
        }
        return array;
    }

    public static int[] rotate(int[] array) {
        return CollectionTools.rotate(array, 1);
    }

    public static int[] rotate(int[] array, int distance) {
        int len = array.length;
        if (len == 0) {
            return array;
        }
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return array;
        }
        int cycleStart = 0;
        int nMoved = 0;
        while (nMoved != len) {
            int displaced = array[cycleStart];
            int i = cycleStart;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                int temp = array[i];
                array[i] = displaced;
                displaced = temp;
                ++nMoved;
            } while (i != cycleStart);
            ++cycleStart;
        }
        return array;
    }

    public static Set set(Iterator iterator) {
        HashSet set = new HashSet();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static Set set(Object[] array) {
        HashSet<Object> set = new HashSet<Object>(array.length);
        int i = array.length;
        while (i-- > 0) {
            set.add(array[i]);
        }
        return set;
    }

    public static Object[] shuffle(Object[] array) {
        return CollectionTools.shuffle(array, RANDOM);
    }

    public static Object[] shuffle(Object[] array, Random r) {
        int i = array.length;
        while (i-- > 0) {
            CollectionTools.swap(array, i, r.nextInt(i));
        }
        return array;
    }

    public static char[] shuffle(char[] array) {
        return CollectionTools.shuffle(array, RANDOM);
    }

    public static char[] shuffle(char[] array, Random r) {
        int i = array.length;
        while (i-- > 0) {
            CollectionTools.swap(array, i, r.nextInt(i));
        }
        return array;
    }

    public static int[] shuffle(int[] array) {
        return CollectionTools.shuffle(array, RANDOM);
    }

    public static int[] shuffle(int[] array, Random r) {
        int i = array.length;
        while (i-- > 0) {
            CollectionTools.swap(array, i, r.nextInt(i));
        }
        return array;
    }

    public static Iterator singletonIterator(Object o) {
        return new SingleElementIterator(o);
    }

    public static int size(Iterator iterator) {
        int size = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    public static SortedSet sortedSet(Iterator iterator) {
        return CollectionTools.sortedSet(iterator, null);
    }

    public static SortedSet sortedSet(Iterator iterator, Comparator c) {
        TreeSet sortedSet = new TreeSet(c);
        sortedSet.addAll(CollectionTools.list(iterator));
        return sortedSet;
    }

    public static SortedSet sortedSet(Object[] array) {
        return CollectionTools.sortedSet(array, null);
    }

    public static SortedSet sortedSet(Object[] array, Comparator c) {
        TreeSet<Object> sortedSet = new TreeSet<Object>(c);
        sortedSet.addAll(Arrays.asList(array));
        return sortedSet;
    }

    public static Object[] swap(Object[] array, int i, int j) {
        Object temp = array[i];
        array[i] = array[j];
        array[j] = temp;
        return array;
    }

    public static char[] swap(char[] array, int i, int j) {
        char temp = array[i];
        array[i] = array[j];
        array[j] = temp;
        return array;
    }

    public static int[] swap(int[] array, int i, int j) {
        int temp = array[i];
        array[i] = array[j];
        array[j] = temp;
        return array;
    }

    public static Vector vector(Iterator iterator) {
        Vector v = new Vector();
        while (iterator.hasNext()) {
            v.addElement(iterator.next());
        }
        return v;
    }

    public static Vector vector(Object[] array) {
        int len = array.length;
        Vector<Object> v = new Vector<Object>(len);
        for (int i = 0; i < len; ++i) {
            v.addElement(array[i]);
        }
        return v;
    }

    public static List copy(List dest, List src) {
        Collections.copy(dest, src);
        return dest;
    }

    public static List fill(List list, Object o) {
        Collections.fill(list, o);
        return list;
    }

    public static List reverse(List list) {
        Collections.reverse(list);
        return list;
    }

    public static List rotate(List list) {
        return CollectionTools.rotate(list, 1);
    }

    public static List rotate(List list, int distance) {
        Collections.rotate(list, distance);
        return list;
    }

    public static List shuffle(List list) {
        Collections.shuffle(list);
        return list;
    }

    public static List shuffle(List list, Random random) {
        Collections.shuffle(list, random);
        return list;
    }

    public static List sort(List list) {
        Collections.sort(list);
        return list;
    }

    public static List sort(List list, Comparator c) {
        Collections.sort(list, c);
        return list;
    }

    public static List sort(Iterator iterator) {
        List list = CollectionTools.list(iterator);
        Collections.sort(list);
        return list;
    }

    public static List sort(Iterator iterator, Comparator c) {
        List list = CollectionTools.list(iterator);
        Collections.sort(list, c);
        return list;
    }

    public static List swap(List list, int i, int j) {
        Collections.swap(list, i, j);
        return list;
    }

    public static boolean[] fill(boolean[] a, boolean val) {
        Arrays.fill(a, val);
        return a;
    }

    public static boolean[] fill(boolean[] a, int fromIndex, int toIndex, boolean val) {
        Arrays.fill(a, fromIndex, toIndex, val);
        return a;
    }

    public static byte[] fill(byte[] a, byte val) {
        Arrays.fill(a, val);
        return a;
    }

    public static byte[] fill(byte[] a, int fromIndex, int toIndex, byte val) {
        Arrays.fill(a, fromIndex, toIndex, val);
        return a;
    }

    public static char[] fill(char[] a, char val) {
        Arrays.fill(a, val);
        return a;
    }

    public static char[] fill(char[] a, int fromIndex, int toIndex, char val) {
        Arrays.fill(a, fromIndex, toIndex, val);
        return a;
    }

    public static double[] fill(double[] a, double val) {
        Arrays.fill(a, val);
        return a;
    }

    public static double[] fill(double[] a, int fromIndex, int toIndex, double val) {
        Arrays.fill(a, fromIndex, toIndex, val);
        return a;
    }

    public static float[] fill(float[] a, float val) {
        Arrays.fill(a, val);
        return a;
    }

    public static float[] fill(float[] a, int fromIndex, int toIndex, float val) {
        Arrays.fill(a, fromIndex, toIndex, val);
        return a;
    }

    public static int[] fill(int[] a, int val) {
        Arrays.fill(a, val);
        return a;
    }

    public static int[] fill(int[] a, int fromIndex, int toIndex, int val) {
        Arrays.fill(a, fromIndex, toIndex, val);
        return a;
    }

    public static Object[] fill(Object[] a, Object val) {
        Arrays.fill(a, val);
        return a;
    }

    public static Object[] fill(Object[] a, int fromIndex, int toIndex, Object val) {
        Arrays.fill(a, fromIndex, toIndex, val);
        return a;
    }

    public static long[] fill(long[] a, long val) {
        Arrays.fill(a, val);
        return a;
    }

    public static long[] fill(long[] a, int fromIndex, int toIndex, long val) {
        Arrays.fill(a, fromIndex, toIndex, val);
        return a;
    }

    public static short[] fill(short[] a, short val) {
        Arrays.fill(a, val);
        return a;
    }

    public static short[] fill(short[] a, int fromIndex, int toIndex, short val) {
        Arrays.fill(a, fromIndex, toIndex, val);
        return a;
    }

    public static byte[] sort(byte[] a) {
        Arrays.sort(a);
        return a;
    }

    public static byte[] sort(byte[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
        return a;
    }

    public static char[] sort(char[] a) {
        Arrays.sort(a);
        return a;
    }

    public static char[] sort(char[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
        return a;
    }

    public static double[] sort(double[] a) {
        Arrays.sort(a);
        return a;
    }

    public static double[] sort(double[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
        return a;
    }

    public static float[] sort(float[] a) {
        Arrays.sort(a);
        return a;
    }

    public static float[] sort(float[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
        return a;
    }

    public static int[] sort(int[] a) {
        Arrays.sort(a);
        return a;
    }

    public static int[] sort(int[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
        return a;
    }

    public static Object[] sort(Object[] a) {
        Arrays.sort(a);
        return a;
    }

    public static Object[] sort(Object[] a, Comparator c) {
        Arrays.sort(a, c);
        return a;
    }

    public static Object[] sort(Object[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
        return a;
    }

    public static Object[] sort(Object[] a, int fromIndex, int toIndex, Comparator c) {
        Arrays.sort(a, fromIndex, toIndex, c);
        return a;
    }

    public static long[] sort(long[] a) {
        Arrays.sort(a);
        return a;
    }

    public static long[] sort(long[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
        return a;
    }

    public static short[] sort(short[] a) {
        Arrays.sort(a);
        return a;
    }

    public static short[] sort(short[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
        return a;
    }

    private CollectionTools() {
        throw new UnsupportedOperationException();
    }
}

