/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWDescriptorQueryParameterHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryParameter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBasicExpression;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWQueryParameterArgument
extends MWArgument {
    private MWDescriptorQueryParameterHandle queryParameterHandle;
    public static final String QUERY_PARAMETER_PROPERTY = "queryParameter";

    private MWQueryParameterArgument() {
    }

    MWQueryParameterArgument(MWBasicExpression expression) {
        super(expression);
    }

    MWQueryParameterArgument(MWBasicExpression expression, MWQueryParameter parameter) {
        this(expression);
        this.queryParameterHandle.setQueryParameter(parameter);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.queryParameterHandle = new MWDescriptorQueryParameterHandle(this, this.buildQueryParameterScrubber());
    }

    public String getType() {
        return "parameter";
    }

    public MWQueryParameter getQueryParameter() {
        return this.queryParameterHandle.getQueryParameter();
    }

    private MWBasicExpression getBasicExpression() {
        return (MWBasicExpression)this.getParent();
    }

    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        this.checkParameter(currentProblems);
    }

    private void checkParameter(List currentProblems) {
        if (this.getQueryParameter() == null) {
            String queryName = this.getBasicExpression().getParentQuery().getName();
            String lineNumber = this.getBasicExpression().getIndex();
            currentProblems.add(this.buildProblem("0248", lineNumber, queryName));
        }
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.queryParameterHandle);
    }

    private MWHandle.NodeReferenceScrubber buildQueryParameterScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWQueryParameterArgument.this.setQueryParameter(null);
            }

            public String toString() {
                return "MWQueryParameterArgument.buildQueryParameterScrubber()";
            }
        };
    }

    public void undoChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == QUERY_PARAMETER_PROPERTY) {
            this.setQueryParameter((MWQueryParameter)oldValue);
        }
    }

    public String displayString() {
        if (this.getQueryParameter() == null) {
            return "";
        }
        return this.getQueryParameter().getName();
    }

    public void toString(StringBuffer sb) {
        super.toString(sb);
        sb.append("queryParameter = ");
        if (this.getQueryParameter() != null) {
            sb.append(this.getQueryParameter().getName());
        }
    }

    public void setQueryParameter(MWQueryParameter queryParameter) {
        MWQueryParameter oldQueryParameter = this.getQueryParameter();
        this.queryParameterHandle.setQueryParameter(queryParameter);
        this.firePropertyChanged(QUERY_PARAMETER_PROPERTY, oldQueryParameter, this.getQueryParameter());
        this.getBasicExpression().getRootCompoundExpression().propertyChanged(this, QUERY_PARAMETER_PROPERTY, oldQueryParameter, queryParameter);
    }

    Expression runtimeExpression(ExpressionBuilder builder) {
        return builder.getParameter(this.getQueryParameter().getName());
    }

    static MWQueryParameterArgument convertFromRuntime(MWBasicExpression bldrExpression, ParameterExpression runtimeExpression) {
        String parameterName = runtimeExpression.getField().getName();
        MWQueryParameter parameter = bldrExpression.getParentQuery().getParameterNamed(parameterName);
        return new MWQueryParameterArgument(bldrExpression, parameter);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWQueryParameterArgument.class);
        descriptor.getInheritancePolicy().setParentClass(MWArgument.class);
        XMLCompositeObjectMapping queryParameterHandleMapping = new XMLCompositeObjectMapping();
        queryParameterHandleMapping.setAttributeName("queryParameterHandle");
        queryParameterHandleMapping.setGetMethodName("getQueryParameterHandleForTopLink");
        queryParameterHandleMapping.setSetMethodName("setQueryParameterHandleForTopLink");
        queryParameterHandleMapping.setReferenceClass(MWDescriptorQueryParameterHandle.class);
        queryParameterHandleMapping.setXPath("query-parameter-handle");
        descriptor.addMapping((DatabaseMapping)queryParameterHandleMapping);
        return descriptor;
    }

    private MWDescriptorQueryParameterHandle getQueryParameterHandleForTopLink() {
        return this.queryParameterHandle.getQueryParameter() == null ? null : this.queryParameterHandle;
    }

    private void setQueryParameterHandleForTopLink(MWDescriptorQueryParameterHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildQueryParameterScrubber();
        this.queryParameterHandle = handle == null ? new MWDescriptorQueryParameterHandle(this, scrubber) : handle.setScrubber(scrubber);
    }
}

