/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.List;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWCustomReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWCustomReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWDeleteQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWInsertQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalSpecificQueryOptions;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWSQLQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWStoredProcedureQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWStringQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWUpdateQuery;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class MWAbstractCustomQuery
extends MWModel
implements MWRelationalQuery {
    private volatile MWRelationalSpecificQueryOptions relationalOptions;

    protected MWAbstractCustomQuery() {
    }

    MWAbstractCustomQuery(MWQueryManager queryManager) {
        super(queryManager);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.relationalOptions = new MWRelationalSpecificQueryOptions(this);
        this.relationalOptions.setQueryFormatToSql();
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.relationalOptions);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWAbstractCustomQuery.class);
        InheritancePolicy ip = descriptor.getInheritancePolicy();
        ip.setClassIndicatorFieldName("@type");
        ip.addClassIndicator(MWInsertQuery.class, (Object)"insert");
        ip.addClassIndicator(MWDeleteQuery.class, (Object)"delete");
        ip.addClassIndicator(MWUpdateQuery.class, (Object)"update");
        ip.addClassIndicator(MWCustomReadObjectQuery.class, (Object)"read-object");
        ip.addClassIndicator(MWCustomReadAllQuery.class, (Object)"read-all");
        XMLCompositeObjectMapping relationalOptionsMaping = new XMLCompositeObjectMapping();
        relationalOptionsMaping.setAttributeName("relationalOptions");
        relationalOptionsMaping.setReferenceClass(MWRelationalSpecificQueryOptions.class);
        relationalOptionsMaping.setXPath("relational-options");
        descriptor.addMapping((DatabaseMapping)relationalOptionsMaping);
        return descriptor;
    }

    public void formatSetToEjbql() {
    }

    public void formatSetToSql() {
    }

    public MWRelationalSpecificQueryOptions getRelationalOptions() {
        return this.relationalOptions;
    }

    public String getQueryFormatType() {
        return this.relationalOptions.getQueryFormatType();
    }

    public void setQueryFormatType(String type) {
        this.relationalOptions.setQueryFormatType(type);
    }

    public MWQueryFormat getQueryFormat() {
        return this.relationalOptions.getQueryFormat();
    }

    public void setSQLString(String sql) {
        this.setQueryFormatType("sqlFormat");
        ((MWSQLQueryFormat)this.relationalOptions.getQueryFormat()).setQueryString(sql);
    }

    public TriStateBoolean isCacheStatement() {
        return this.relationalOptions.isCacheStatement();
    }

    public void setCacheStatement(TriStateBoolean cacheStatement) {
        this.relationalOptions.setCacheStatement(cacheStatement);
    }

    public TriStateBoolean isBindAllParameters() {
        return this.relationalOptions.isBindAllParameters();
    }

    public void setBindAllParameters(TriStateBoolean bindAllParameters) {
        this.relationalOptions.setBindAllParameters(bindAllParameters);
    }

    public boolean isPrepare() {
        return this.relationalOptions.isPrepare();
    }

    public void setPrepare(boolean bindAllParameters) {
        this.relationalOptions.setPrepare(bindAllParameters);
    }

    public void notifyExpressionsToRecalculateQueryables() {
        this.relationalOptions.notifyExpressionsToRecalculateQueryables();
    }

    protected abstract DatabaseQuery buildRuntimeQuery();

    public void adjustFromRuntimeQuery(DatabaseQuery runtimeQuery) {
        this.relationalOptions.adjustFromRuntime(runtimeQuery);
    }

    public void adjustRuntimeQuery(DatabaseQuery runtimeQuery) {
        this.relationalOptions.adjustRuntimeQuery(runtimeQuery);
    }

    public boolean isContentEmpty() {
        MWQueryFormat format = this.relationalOptions.getQueryFormat();
        if (format.getType().equals("sqlFormat") || format.getType().equals("ejbqlFormat")) {
            return StringTools.stringIsEmpty(((MWStringQueryFormat)format).getQueryString());
        }
        if (format.getType().equals("storedProcedure")) {
            return StringTools.stringIsEmpty(((MWStoredProcedureQueryFormat)format).getProcedure().getName());
        }
        return true;
    }
}

