/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.xdb.DirectToXMLTypeMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class MWDirectToXmlTypeMapping
extends MWRelationalDirectMapping {
    private volatile boolean readWholeDocument;
    public static final String READ_WHOLE_DOCUMENT_PROPERTY = "readWholeDocument";

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWDirectToXmlTypeMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWRelationalDirectMapping.class);
        XMLDirectMapping readWholeDocumentMapping = (XMLDirectMapping)descriptor.addDirectMapping(READ_WHOLE_DOCUMENT_PROPERTY, "read-whole-document/text()");
        readWholeDocumentMapping.setNullValue((Object)Boolean.FALSE);
        return descriptor;
    }

    private MWDirectToXmlTypeMapping() {
    }

    MWDirectToXmlTypeMapping(MWMappingDescriptor parent, MWClassAttribute attribute, String name) {
        super(parent, attribute, name);
    }

    public String iconKey() {
        return "mapping.directToXmlType";
    }

    public boolean isReadWholeDocument() {
        return this.readWholeDocument;
    }

    public void setReadWholeDocument(boolean readWholeDocument) {
        boolean oldValue = this.readWholeDocument;
        this.readWholeDocument = readWholeDocument;
        this.firePropertyChanged(READ_WHOLE_DOCUMENT_PROPERTY, oldValue, readWholeDocument);
    }

    protected void initializeOn(MWMapping newMapping) {
        newMapping.initializeFromMWDirectToXmlTypeMapping(this);
    }

    public MWDirectToXmlTypeMapping asMWDirectToXmlTypeMapping() {
        return this;
    }

    public DatabaseMapping runtimeMapping() {
        DirectToXMLTypeMapping mapping = (DirectToXMLTypeMapping)super.runtimeMapping();
        mapping.setShouldReadWholeDocument(this.isReadWholeDocument());
        return mapping;
    }

    protected DatabaseMapping buildRuntimeMapping() {
        return new DirectToXMLTypeMapping();
    }

    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.checkDatabasePlatform(newProblems);
        this.checkAttributeType(newProblems);
        this.checkColumnType(newProblems);
    }

    private void checkDatabasePlatform(List newProblems) {
        if (!this.getDatabase().getDatabasePlatform().containsDatabaseTypeNamed("XMLTYPE")) {
            newProblems.add(this.buildProblem("0440"));
        }
    }

    private void checkAttributeType(List newProblems) {
        MWClass attributeType = this.getInstanceVariable().getType();
        if (!(attributeType.mightBeAssignableTo(this.typeFor(String.class)) || attributeType.mightBeAssignableTo(this.typeFor(Document.class)) || attributeType.mightBeAssignableTo(this.typeFor(Node.class)))) {
            newProblems.add(this.buildProblem("0441"));
        }
    }

    private void checkColumnType(List newProblems) {
        if (this.getColumn() == null) {
            return;
        }
        if (!this.getColumn().getDatabaseType().getName().equals("XMLTYPE")) {
            newProblems.add(this.buildProblem("0442"));
        }
    }
}

