/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateFieldDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateRuntimeFieldNameGenerator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWVariableOneToOneMapping;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWColumnQueryKeyPair
extends MWModel
implements AggregateRuntimeFieldNameGenerator {
    private MWColumnHandle columnHandle;
    public static final String COLUMN_PROPERTY = "column";
    private volatile String queryKeyName;
    public static final String QUERY_KEY_NAME_PROPERTY = "queryKeyName";

    private MWColumnQueryKeyPair() {
    }

    MWColumnQueryKeyPair(MWVariableOneToOneMapping parent, MWColumn source, String targetQueryKeyName) {
        super(parent);
        this.columnHandle.setColumn(source);
        this.queryKeyName = targetQueryKeyName;
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.columnHandle = new MWColumnHandle(this, this.buildColumnScrubber());
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.columnHandle);
    }

    public MWRelationalDescriptor getParentDescriptor() {
        return (MWRelationalDescriptor)((Object)this.getMapping().getParentDescriptor());
    }

    public MWVariableOneToOneMapping getMapping() {
        return (MWVariableOneToOneMapping)this.getParent();
    }

    private MWHandle.NodeReferenceScrubber buildColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWColumnQueryKeyPair.this.setColumn(null);
            }

            public String toString() {
                return "MWColumnQueryKeyPair.buildColumnScrubber()";
            }
        };
    }

    public MWColumn getColumn() {
        return this.columnHandle.getColumn();
    }

    public void setColumn(MWColumn column) {
        MWColumn old = this.columnHandle.getColumn();
        this.columnHandle.setColumn(column);
        this.firePropertyChanged(COLUMN_PROPERTY, old, column);
    }

    public String getQueryKeyName() {
        return this.queryKeyName;
    }

    public void setQueryKeyName(String newQueryKeyName) {
        String oldQueryKeyNameName = this.queryKeyName;
        this.queryKeyName = newQueryKeyName;
        this.firePropertyChanged(QUERY_KEY_NAME_PROPERTY, oldQueryKeyNameName, newQueryKeyName);
    }

    public String fieldNameForRuntime() {
        return "QUERY_KEY " + this.getQueryKeyName();
    }

    public AggregateFieldDescription fullFieldDescription() {
        return new AggregateFieldDescription(){

            public String getMessageKey() {
                return "AGGREGATE_FIELD_DESCRIPTION_FOR_FIELD_QUERY_KEY_ASSOCIATION";
            }

            public Object[] getMessageArguments() {
                return new Object[]{MWColumnQueryKeyPair.this.getQueryKeyName()};
            }
        };
    }

    public boolean fieldIsWritten() {
        return true;
    }

    public MWDescriptor owningDescriptor() {
        throw new UnsupportedOperationException();
    }

    void adjustRuntimeMapping(VariableOneToOneMapping runtimeMapping) {
        if (this.getColumn() != null) {
            runtimeMapping.addForeignQueryKeyName(this.getColumn().qualifiedName(), this.getQueryKeyName());
        } else if (this.getParentDescriptor().isAggregateDescriptor()) {
            runtimeMapping.addForeignQueryKeyName(runtimeMapping.getAttributeName() + "->" + this.fieldNameForRuntime(), this.getQueryKeyName());
        }
    }

    public void toString(StringBuffer sb) {
        sb.append(this.getColumn() == null ? "null" : this.getColumn().getName());
        sb.append("=>");
        sb.append(this.getQueryKeyName());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWColumnQueryKeyPair.class);
        XMLCompositeObjectMapping columnHandleMapping = new XMLCompositeObjectMapping();
        columnHandleMapping.setAttributeName("columnHandle");
        columnHandleMapping.setGetMethodName("getColumnHandleForTopLink");
        columnHandleMapping.setSetMethodName("setColumnHandleForTopLink");
        columnHandleMapping.setReferenceClass(MWColumnHandle.class);
        columnHandleMapping.setXPath("column-handle");
        descriptor.addMapping((DatabaseMapping)columnHandleMapping);
        descriptor.addDirectMapping(QUERY_KEY_NAME_PROPERTY, "query-key-name/text()");
        return descriptor;
    }

    private MWColumnHandle getColumnHandleForTopLink() {
        return this.columnHandle.getColumn() == null ? null : this.columnHandle;
    }

    private void setColumnHandleForTopLink(MWColumnHandle columnHandle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildColumnScrubber();
        this.columnHandle = columnHandle == null ? new MWColumnHandle(this, scrubber) : columnHandle.setScrubber(scrubber);
    }
}

