/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWCollectionContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWListContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWSetContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAbstractTableReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWCollectionOrdering;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWCollectionMapping
extends MWAbstractTableReferenceMapping
implements MWIndirectableContainerMapping,
MWMapContainerMapping {
    private volatile MWContainerPolicy containerPolicy;
    private List orderings;
    public static final String ORDERINGS_LIST = "orderings";
    public static final String EJB_INDIRECT_LIST_CLASS_NAME = "org.eclipse.persistence.indirection.EJBIndirectList";
    public static final String EJB_INDIRECT_SET_CLASS_NAME = "org.eclipse.persistence.indirection.EJBIndirectSet";
    public static final String INDIRECT_LIST_CLASS_NAME = "org.eclipse.persistence.indirection.IndirectList";
    public static final String INDIRECT_MAP_CLASS_NAME = "org.eclipse.persistence.indirection.IndirectMap";
    public static final String INDIRECT_SET_CLASS_NAME = "org.eclipse.persistence.indirection.IndirectSet";

    protected MWCollectionMapping() {
    }

    protected MWCollectionMapping(MWRelationalClassDescriptor descriptor, MWClassAttribute attribute, String name) {
        super(descriptor, attribute, name);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.orderings = new Vector();
    }

    protected void initialize(MWClassAttribute attribute, String name) {
        super.initialize(attribute, name);
        if (attribute.getDimensionality() > 0) {
            this.containerPolicy = new MWListContainerPolicy(this);
            this.setUseTransparentIndirection();
        } else {
            MWClass type = null;
            if (attribute.isValueHolder()) {
                this.setUseValueHolderIndirection();
                type = attribute.getValueType();
            } else {
                this.setUseTransparentIndirection();
                type = attribute.getType();
            }
            this.containerPolicy = type.isAssignableToMap() ? new MWMapContainerPolicy(this) : (type.isAssignableToList() ? new MWListContainerPolicy(this) : (type.isAssignableToSet() ? new MWSetContainerPolicy(this) : (type.isAssignableToCollection() ? new MWCollectionContainerPolicy(this) : new MWListContainerPolicy(this))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.containerPolicy);
        List list = this.orderings;
        synchronized (list) {
            children.addAll(this.orderings);
        }
    }

    public MWContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    private void setContainerPolicy(MWContainerPolicy containerPolicy) {
        MWContainerPolicy oldValue = this.containerPolicy;
        this.containerPolicy = containerPolicy;
        this.firePropertyChanged("containerPolicy", oldValue, containerPolicy);
    }

    public MWMapContainerPolicy setMapContainerPolicy() {
        if (this.containerPolicy instanceof MWMapContainerPolicy) {
            return (MWMapContainerPolicy)this.containerPolicy;
        }
        MWMapContainerPolicy cp = new MWMapContainerPolicy(this);
        this.setContainerPolicy(cp);
        return cp;
    }

    public MWCollectionContainerPolicy setCollectionContainerPolicy() {
        if (this.containerPolicy instanceof MWCollectionContainerPolicy) {
            return (MWCollectionContainerPolicy)this.containerPolicy;
        }
        MWCollectionContainerPolicy cp = new MWCollectionContainerPolicy(this);
        this.setContainerPolicy(cp);
        return cp;
    }

    public MWListContainerPolicy setListContainerPolicy() {
        if (this.containerPolicy instanceof MWListContainerPolicy) {
            return (MWListContainerPolicy)this.containerPolicy;
        }
        MWListContainerPolicy cp = new MWListContainerPolicy(this);
        this.setContainerPolicy(cp);
        return cp;
    }

    public MWSetContainerPolicy setSetContainerPolicy() {
        if (this.containerPolicy instanceof MWSetContainerPolicy) {
            return (MWSetContainerPolicy)this.containerPolicy;
        }
        MWSetContainerPolicy cp = new MWSetContainerPolicy(this);
        this.setContainerPolicy(cp);
        return cp;
    }

    public Iterator candidateKeyMethods(Filter keyMethodFilter) {
        if (this.getReferenceDescriptor() != null) {
            return new FilteringIterator(this.getReferenceDescriptor().getMWClass().allInstanceMethods(), keyMethodFilter);
        }
        return NullIterator.instance();
    }

    protected void initializeFromMWCollectionMapping(MWCollectionMapping oldMapping) {
        super.initializeFromMWCollectionMapping(oldMapping);
        ListIterator i = this.orderings();
        while (i.hasNext()) {
            MWCollectionOrdering ordering = (MWCollectionOrdering)i.next();
            MWCollectionOrdering newOrdering = oldMapping.addOrdering(ordering.getQueryKey());
            newOrdering.setAscending(ordering.isAscending());
        }
        this.getContainerPolicy().getDefaultingContainerClass().setContainerClass(oldMapping.getContainerPolicy().getDefaultingContainerClass().getContainerClass());
    }

    protected void initializeFromMWIndirectableContainerMapping(MWIndirectableContainerMapping oldMapping) {
        super.initializeFromMWIndirectableContainerMapping(oldMapping);
        if (oldMapping.usesTransparentIndirection()) {
            this.setUseTransparentIndirection();
        }
    }

    public ListIterator orderings() {
        return new CloneListIterator(this.orderings);
    }

    public int orderingsSize() {
        return this.orderings.size();
    }

    public int indexOfOrdering(MWCollectionOrdering ordering) {
        return this.orderings.indexOf(ordering);
    }

    public void moveOrderingUp(MWCollectionOrdering ordering) {
        int index = this.indexOfOrdering(ordering);
        this.removeOrdering(index);
        this.addOrdering(index - 1, ordering);
    }

    public void moveOrderingDown(MWCollectionOrdering ordering) {
        int index = this.indexOfOrdering(ordering);
        this.removeOrdering(ordering);
        this.addOrdering(index + 1, ordering);
    }

    public MWCollectionOrdering addOrdering(MWQueryKey queryKey) {
        MWCollectionOrdering ordering = new MWCollectionOrdering(this);
        ordering.setQueryKey(queryKey);
        this.addOrdering(this.orderingsSize(), ordering);
        return ordering;
    }

    private void addOrdering(int index, MWCollectionOrdering ordering) {
        this.addItemToList(index, ordering, this.orderings, ORDERINGS_LIST);
    }

    public void removeOrdering(MWCollectionOrdering ordering) {
        this.removeOrdering(this.orderings.indexOf(ordering));
    }

    public void removeOrdering(int index) {
        this.removeItemFromList(index, this.orderings, ORDERINGS_LIST);
    }

    public void setUseTransparentIndirection() {
        this.setIndirectionType("transparentIndirection");
    }

    public void setReferenceDescriptor(MWDescriptor descriptor) {
        super.setReferenceDescriptor(descriptor);
        this.getContainerPolicy().referenceDescriptorChanged(descriptor);
    }

    public boolean usesAnyOf() {
        return true;
    }

    public boolean isTraversableForReadAllQueryOrderable() {
        return false;
    }

    public boolean usesTransparentIndirection() {
        return this.getIndirectionType() == "transparentIndirection";
    }

    public boolean isCollectionMapping() {
        return true;
    }

    protected void forceEjb20Indirection() {
        super.forceEjb20Indirection();
        this.setUseTransparentIndirection();
    }

    protected Collection buildAggregateFieldNameGenerators() {
        Collection generators = super.buildAggregateFieldNameGenerators();
        if (this.getReference() != null) {
            Iterator i = this.getReference().columnPairs();
            while (i.hasNext()) {
                MWColumnPair association = (MWColumnPair)i.next();
                generators.add(new MWAbstractTableReferenceMapping.ColumnPairAggregateRuntimeFieldNameGenerator(this, association, false));
            }
        }
        return generators;
    }

    protected boolean fieldIsWritten(MWColumnPair association) {
        return false;
    }

    public DatabaseMapping runtimeMapping() {
        CollectionMapping runtimeMapping = (CollectionMapping)super.runtimeMapping();
        if (this.usesTransparentIndirection()) {
            runtimeMapping.setIndirectionPolicy((IndirectionPolicy)new TransparentIndirectionPolicy());
        } else if (this.usesValueHolderIndirection()) {
            runtimeMapping.useBasicIndirection();
        } else {
            runtimeMapping.dontUseIndirection();
        }
        runtimeMapping.setContainerPolicy(this.containerPolicy.runtimeContainerPolicy());
        if (this.getContainerPolicy().usesSorting() && this.getContainerPolicy().getComparatorClass() != null) {
            runtimeMapping.useSortedSetClassName(this.getContainerPolicy().getDefaultingContainerClass().getContainerClass().getName(), this.getContainerPolicy().getComparatorClass().getName());
        }
        ListIterator i = this.orderings();
        while (i.hasNext()) {
            ((MWCollectionOrdering)i.next()).adjustRuntimeMapping(runtimeMapping);
        }
        return runtimeMapping;
    }

    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.checkContainerClassIsValidForTransparentIndirection(newProblems);
        this.addUsesTransparentIndirectionWhileMaintainsBiDirectionalRelationship(newProblems);
    }

    public void addWrittenFieldsTo(Collection writtenFields) {
    }

    protected void mappingAndVariableDontUseIndirectionTest(List newProblems) {
        if (!this.usesValueHolderIndirection() && this.getInstanceVariable().isValueHolder()) {
            newProblems.add(this.buildProblem("0550"));
        }
    }

    protected void mappingAndVariableUseIndirectionTest(List newProblems) {
        if (!this.getProject().usesWeaving() && this.usesValueHolderIndirection() && !this.getInstanceVariable().isValueHolder()) {
            newProblems.add(this.buildProblem("0551"));
        }
    }

    private void checkContainerClassIsValidForTransparentIndirection(List newProblems) {
        if (!this.usesTransparentIndirection()) {
            return;
        }
        MWClass collectionType = this.getContainerPolicy().getDefaultingContainerClass().getContainerClass();
        if (collectionType != null && !collectionType.mightBeAssignableToIndirectContainer()) {
            newProblems.add(this.buildProblem("0560"));
        }
    }

    private void addUsesTransparentIndirectionWhileMaintainsBiDirectionalRelationship(List newProblems) {
        if (this.maintainsBidirectionalRelationship() && (this.usesNoIndirection() || this.usesValueHolderIndirection())) {
            newProblems.add(this.buildProblem("0469"));
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWCollectionMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWAbstractTableReferenceMapping.class);
        XMLCompositeObjectMapping containerPolicyMapping = new XMLCompositeObjectMapping();
        containerPolicyMapping.setAttributeName("containerPolicy");
        containerPolicyMapping.setReferenceClass(MWContainerPolicy.MWContainerPolicyRoot.class);
        containerPolicyMapping.setXPath("container-policy");
        descriptor.addMapping((DatabaseMapping)containerPolicyMapping);
        XMLCompositeCollectionMapping orderingsMapping = new XMLCompositeCollectionMapping();
        orderingsMapping.setAttributeName(ORDERINGS_LIST);
        orderingsMapping.setReferenceClass(MWCollectionOrdering.class);
        orderingsMapping.setXPath("orderings/ordering");
        descriptor.addMapping((DatabaseMapping)orderingsMapping);
        return descriptor;
    }
}

