/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWTableHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWRelationalDescriptorInheritancePolicy
extends MWDescriptorInheritancePolicy
implements MWRelationalClassIndicatorFieldPolicy.Parent {
    private volatile boolean readSubclassesOnQuery;
    public static String READ_SUBCLASSES_ON_QUERY_PROPERTY = "readSubclassesOnQuery";
    private MWTableHandle readAllSubclassesViewHandle;
    public static String READ_ALL_SUBCLASSES_VIEW_PROPERTY = "readAllSubclassesView";
    private volatile boolean outerJoinAllSubclasses;
    public static String OUTER_JOIN_ALL_SUBCLASSES = "outerJoinAllSubclasses";

    private MWRelationalDescriptorInheritancePolicy() {
    }

    MWRelationalDescriptorInheritancePolicy(MWMappingDescriptor descriptor) {
        super(descriptor);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.readSubclassesOnQuery = true;
        this.outerJoinAllSubclasses = false;
        this.readAllSubclassesViewHandle = new MWTableHandle(this, this.buildReadAllSubclassesViewScrubber());
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.readAllSubclassesViewHandle);
    }

    private MWHandle.NodeReferenceScrubber buildReadAllSubclassesViewScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWRelationalDescriptorInheritancePolicy.this.setReadAllSubclassesView(null);
            }

            public String toString() {
                return "MWRelationalDescriptorInheritancePolicy.buildReadAllSubclassesViewScrubber()";
            }
        };
    }

    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        super.adjustRuntimeDescriptor(runtimeDescriptor);
        InheritancePolicy runtimeInheritancePolicy = runtimeDescriptor.getInheritancePolicy();
        if (this.getReadAllSubclassesView() != null) {
            runtimeInheritancePolicy.setReadAllSubclassesViewName(this.getReadAllSubclassesView().getName());
        }
        runtimeInheritancePolicy.setShouldOuterJoinSubclasses(this.isOuterJoinAllSubclasses());
        runtimeInheritancePolicy.setShouldReadSubclasses(this.isReadSubclassesOnQuery());
    }

    protected MWClassIndicatorFieldPolicy buildClassIndicatorFieldPolicy() {
        return new MWRelationalClassIndicatorFieldPolicy(this, this.getAllDescriptorsAvailableForIndicatorDictionary().iterator());
    }

    public MWTable getReadAllSubclassesView() {
        return this.readAllSubclassesViewHandle.getTable();
    }

    public void dispose() {
        super.dispose();
        ((MWRelationalProject)this.getProject()).notifyExpressionsToRecalculateQueryables();
    }

    public void setParentDescriptor(MWMappingDescriptor newValue) {
        super.setParentDescriptor(newValue);
        ((MWRelationalProject)this.getProject()).notifyExpressionsToRecalculateQueryables();
    }

    public void setReadAllSubclassesView(MWTable newReadAllSubclassesView) {
        MWTable oldValue = this.readAllSubclassesViewHandle.getTable();
        this.readAllSubclassesViewHandle.setTable(newReadAllSubclassesView);
        this.firePropertyChanged(READ_ALL_SUBCLASSES_VIEW_PROPERTY, oldValue, newReadAllSubclassesView);
    }

    public void setReadSubclassesOnQuery(boolean newReadSubclassesOnQuery) {
        boolean oldValue = this.isReadSubclassesOnQuery();
        this.readSubclassesOnQuery = newReadSubclassesOnQuery;
        this.firePropertyChanged(READ_SUBCLASSES_ON_QUERY_PROPERTY, oldValue, this.isReadSubclassesOnQuery());
    }

    public boolean isReadSubclassesOnQuery() {
        return this.readSubclassesOnQuery;
    }

    protected void setClassIndicatorPolicy(MWClassIndicatorPolicy classIndicatorPolicy) {
        super.setClassIndicatorPolicy(classIndicatorPolicy);
        this.getProject().recalculateAggregatePathsToColumn(this.getOwningDescriptor());
    }

    public boolean isOuterJoinAllSubclasses() {
        return this.outerJoinAllSubclasses;
    }

    public void setOuterJoinAllSubclasses(boolean newOuterJoinAllSubclasses) {
        boolean oldValue = this.isOuterJoinAllSubclasses();
        this.outerJoinAllSubclasses = newOuterJoinAllSubclasses;
        this.firePropertyChanged(OUTER_JOIN_ALL_SUBCLASSES, oldValue, this.isOuterJoinAllSubclasses());
    }

    public void automap() {
        super.automap();
        this.getClassIndicatorPolicy().automap();
    }

    protected String descendantDescriptorTypeMismatchProblemString() {
        return "0325";
    }

    protected boolean checkDescendantsForDescriptorTypeMismatch() {
        Iterator stream = this.descendentDescriptors();
        while (stream.hasNext()) {
            MWRelationalDescriptor currentDescriptor = (MWRelationalDescriptor)stream.next();
            if (currentDescriptor.isAggregateDescriptor() == ((MWRelationalDescriptor)((Object)this.getOwningDescriptor())).isAggregateDescriptor()) continue;
            return true;
        }
        return false;
    }

    public void addClassIndicatorFieldNotSpecifiedProblemTo(List newProblems) {
        ((MWClassIndicatorFieldPolicy)this.getClassIndicatorPolicy()).checkClassIndicatorField(newProblems);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.getInheritancePolicy().setParentClass(MWDescriptorInheritancePolicy.class);
        descriptor.setJavaClass(MWRelationalDescriptorInheritancePolicy.class);
        XMLDirectMapping readSubclassesMapping = new XMLDirectMapping();
        readSubclassesMapping.setAttributeName("readSubclassesOnQuery");
        readSubclassesMapping.setXPath("read-subclasses-on-query/text()");
        readSubclassesMapping.setNullValue((Object)Boolean.TRUE);
        descriptor.addMapping((DatabaseMapping)readSubclassesMapping);
        XMLDirectMapping outerJoinAllSubclassesMapping = new XMLDirectMapping();
        outerJoinAllSubclassesMapping.setAttributeName("outerJoinAllSubclasses");
        outerJoinAllSubclassesMapping.setXPath("outer-join-all-subclasses/text()");
        outerJoinAllSubclassesMapping.setNullValue((Object)Boolean.FALSE);
        descriptor.addMapping((DatabaseMapping)outerJoinAllSubclassesMapping);
        XMLCompositeObjectMapping rasvhMapping = new XMLCompositeObjectMapping();
        rasvhMapping.setAttributeName("readAllSubclassesViewHandle");
        rasvhMapping.setGetMethodName("getReadAllSubclassesViewHandleForTopLink");
        rasvhMapping.setSetMethodName("setReadAllSubclassesViewHandleForTopLink");
        rasvhMapping.setReferenceClass(MWTableHandle.class);
        rasvhMapping.setXPath("read-all-subclasses-view-handle");
        descriptor.addMapping((DatabaseMapping)rasvhMapping);
        return descriptor;
    }

    private MWTableHandle getReadAllSubclassesViewHandleForTopLink() {
        return this.readAllSubclassesViewHandle.getTable() == null ? null : this.readAllSubclassesViewHandle;
    }

    private void setReadAllSubclassesViewHandleForTopLink(MWTableHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildReadAllSubclassesViewScrubber();
        this.readAllSubclassesViewHandle = handle == null ? new MWTableHandle(this, scrubber) : handle.setScrubber(scrubber);
    }
}

