/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWUserDefinedQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAbstractTableReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAggregateMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;

public final class MWAggregateDescriptor
extends MWRelationalClassDescriptor {
    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWAggregateDescriptor.class);
        descriptor.getInheritancePolicy().setParentClass(MWRelationalClassDescriptor.class);
        return descriptor;
    }

    private MWAggregateDescriptor() {
    }

    public MWAggregateDescriptor(MWRelationalProject project, MWClass type, String name) {
        super(project, type, name);
    }

    public Iterator associatedTables() {
        return NullIterator.instance();
    }

    public int associatedTablesSize() {
        return 0;
    }

    public void notifyExpressionsToRecalculateQueryables() {
    }

    public void addMapping(MWMapping mapping) {
        super.addMapping(mapping);
        this.getProject().recalculateAggregatePathsToColumn(this);
    }

    public void removeMapping(MWMapping mapping) {
        super.removeMapping(mapping);
        this.getProject().recalculateAggregatePathsToColumn(this);
    }

    protected void setInheritancePolicy(MWDescriptorInheritancePolicy newValue) {
        super.setInheritancePolicy(newValue);
        this.getProject().recalculateAggregatePathsToColumn(this);
    }

    public MWAggregateDescriptor asMWAggregateDescriptor() {
        return this;
    }

    public void initializeOn(MWDescriptor newDescriptor) {
        ((MWRelationalDescriptor)((Object)newDescriptor)).initializeFromMWAggregateDescriptor(this);
    }

    protected void initializeFromMWMappingDescriptor(MWMappingDescriptor oldDescriptor) {
        super.initializeFromMWMappingDescriptor(oldDescriptor);
        Iterator mappings = this.mappings();
        while (mappings.hasNext()) {
            MWMapping mapping = (MWMapping)mappings.next();
            mapping.parentDescriptorMorphedToAggregate();
        }
        this.getInheritancePolicy().parentDescriptorMorphedToAggregate();
    }

    public void initializeFromMWRelationalClassDescriptor(MWRelationalClassDescriptor oldDescriptor) {
        super.initializeFromMWRelationalClassDescriptor(oldDescriptor);
        Iterator i = this.userDefinedQueryKeys();
        while (i.hasNext()) {
            ((MWUserDefinedQueryKey)i.next()).setColumn(null);
        }
    }

    public boolean isAggregateDescriptor() {
        return true;
    }

    public void applyAdvancedPolicyDefaults(MWProjectDefaultsPolicy defaultsPolicy) {
        defaultsPolicy.applyAdvancedPolicyDefaults(this);
    }

    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.checkReferences(newProblems);
        this.checkSharedAggregates(newProblems);
    }

    protected void checkMultipleMappingsWriteField(List newProblems) {
    }

    protected String multipleMappingsWriteFieldProblemResourceStringKey() {
        throw new UnsupportedOperationException();
    }

    private void checkReferences(List newProblems) {
        Iterator allDescriptors = this.getProject().mappingDescriptors();
        while (allDescriptors.hasNext()) {
            MWMappingDescriptor descriptor = (MWMappingDescriptor)allDescriptors.next();
            Iterator mappings = descriptor.mappings();
            while (mappings.hasNext()) {
                MWAbstractTableReferenceMapping tableRefMapping;
                MWMapping mapping = (MWMapping)mappings.next();
                if (!(mapping instanceof MWAbstractTableReferenceMapping) || (tableRefMapping = (MWAbstractTableReferenceMapping)mapping).getReferenceDescriptor() != this) continue;
                newProblems.add(this.buildProblem("0221"));
            }
        }
    }

    private void checkSharedAggregates(List newProblems) {
        int count = 0;
        Iterator allDescriptors = this.getProject().mappingDescriptors();
        while (allDescriptors.hasNext()) {
            MWMappingDescriptor descriptor = (MWMappingDescriptor)allDescriptors.next();
            Iterator mappings = descriptor.mappings();
            while (mappings.hasNext()) {
                MWAggregateMapping aggMapping;
                MWMapping mapping = (MWMapping)mappings.next();
                if (!(mapping instanceof MWAggregateMapping) || (aggMapping = (MWAggregateMapping)mapping).getReferenceDescriptor() != this) continue;
                ++count;
            }
        }
        if (count < 2) {
            return;
        }
        Iterator mappings = this.mappings();
        while (mappings.hasNext()) {
            MWMapping mapping = (MWMapping)mappings.next();
            if (!(mapping instanceof MWCollectionMapping)) continue;
            newProblems.add(this.buildProblem("0220"));
        }
    }

    protected ClassDescriptor buildBasicRuntimeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.descriptorIsAggregate();
        descriptor.setJavaClassName(this.getMWClass().getName());
        return descriptor;
    }

    protected void adjustUserDefinedQueryKeys(ClassDescriptor runtimeDescriptor) {
        Iterator queryKeys = this.userDefinedQueryKeys();
        while (queryKeys.hasNext()) {
            MWUserDefinedQueryKey queryKey = (MWUserDefinedQueryKey)queryKeys.next();
            DirectQueryKey runtimeQueryKey = new DirectQueryKey();
            runtimeQueryKey.setName(queryKey.getName());
            runtimeQueryKey.setFieldName(queryKey.fieldNameForRuntime());
            runtimeDescriptor.addQueryKey((QueryKey)runtimeQueryKey);
        }
    }
}

