/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.ObjectStringHolder;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

public class DescriptorStringHolder
extends ObjectStringHolder {
    public static final StringConverter DEFAULT_STRING_CONVERTER = new StringConverter(){

        public String convertToString(Object o) {
            return ((MWDescriptor)o).shortName().toLowerCase();
        }
    };

    public DescriptorStringHolder(MWDescriptor descriptor, StringConverter stringConverter) {
        super(descriptor, stringConverter);
    }

    public DescriptorStringHolder(MWDescriptor descriptor) {
        this(descriptor, DEFAULT_STRING_CONVERTER);
    }

    public MWDescriptor getDescriptor() {
        return (MWDescriptor)this.object;
    }

    public static DescriptorStringHolder[] buildHolders(Iterator descriptors) {
        return DescriptorStringHolder.buildHolders(CollectionTools.list(descriptors));
    }

    public static DescriptorStringHolder[] buildHolders(Collection descriptors) {
        MWDescriptor[] descriptorArray = descriptors.toArray(new MWDescriptor[descriptors.size()]);
        DescriptorStringHolder[] holders = new DescriptorStringHolder[descriptorArray.length];
        int i = descriptorArray.length;
        while (i-- > 0) {
            holders[i] = new DescriptorStringHolder(descriptorArray[i]);
        }
        return holders;
    }
}

