/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.db;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.schemaframework.ForeignKeyConstraint;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWTableHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalForeignKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalForeignKeyColumnPair;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWReference
extends MWModel {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private MWTableHandle targetTableHandle;
    public static final String TARGET_TABLE_PROPERTY = "targetTable";
    private Collection columnPairs;
    public static final String COLUMN_PAIRS_COLLECTION = "columnPairs";
    private volatile boolean onDatabase;
    public static final String ON_DATABASE_PROPERTY = "onDatabase";

    private MWReference() {
    }

    MWReference(MWTable parent, String name, MWTable targetTable) {
        super(parent);
        this.name = name;
        this.targetTableHandle.setTable(targetTable);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.targetTableHandle = new MWTableHandle(this, this.buildTargetTableScrubber());
        this.columnPairs = new Vector();
        this.onDatabase = false;
    }

    public MWTable getSourceTable() {
        return (MWTable)this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.getSourceTable().checkReferenceName(name);
        String old = this.name;
        this.name = name;
        this.firePropertyChanged(NAME_PROPERTY, old, name);
        if (this.attributeValueHasChanged(old, name)) {
            this.getProject().nodeRenamed(this);
        }
    }

    public MWTable getTargetTable() {
        return this.targetTableHandle.getTable();
    }

    public void setTargetTable(MWTable targetTable) {
        MWTable old = this.targetTableHandle.getTable();
        this.targetTableHandle.setTable(targetTable);
        this.firePropertyChanged(TARGET_TABLE_PROPERTY, old, targetTable);
        if (this.attributeValueHasChanged(old, targetTable)) {
            this.clearColumnPairs();
        }
    }

    public boolean isOnDatabase() {
        return this.onDatabase;
    }

    public void setOnDatabase(boolean onDatabase) {
        boolean old = this.onDatabase;
        this.onDatabase = onDatabase;
        this.firePropertyChanged(ON_DATABASE_PROPERTY, old, onDatabase);
    }

    public Iterator columnPairs() {
        return new CloneIterator(this.columnPairs){

            protected void remove(Object current) {
                MWReference.this.removeColumnPair((MWColumnPair)current);
            }
        };
    }

    public int columnPairsSize() {
        return this.columnPairs.size();
    }

    public MWColumnPair addColumnPair(MWColumn sourceColumn, MWColumn targetColumn) {
        if (sourceColumn.getTable() != this.getSourceTable()) {
            throw new IllegalArgumentException("invalid source column: " + sourceColumn);
        }
        if (targetColumn.getTable() != this.getTargetTable()) {
            throw new IllegalArgumentException("invalid target column: " + targetColumn);
        }
        return this.addColumnPair(new MWColumnPair(this, sourceColumn, targetColumn));
    }

    private MWColumnPair addColumnPair(MWColumnPair columnPair) {
        this.addItemToCollection(columnPair, this.columnPairs, COLUMN_PAIRS_COLLECTION);
        return columnPair;
    }

    public void removeColumnPair(MWColumnPair columnPair) {
        this.removeItemFromCollection(columnPair, this.columnPairs, COLUMN_PAIRS_COLLECTION);
    }

    public void removeColumnPairs(Iterator pairs) {
        while (pairs.hasNext()) {
            this.removeColumnPair((MWColumnPair)pairs.next());
        }
    }

    public void removeColumnPairs(Collection pairs) {
        this.removeColumnPairs(pairs.iterator());
    }

    private void clearColumnPairs() {
        Iterator stream = this.columnPairs();
        while (stream.hasNext()) {
            stream.next();
            stream.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWColumnPair columnPairNamed(String columnPairName) {
        Collection collection = this.columnPairs;
        synchronized (collection) {
            for (MWColumnPair pair : this.columnPairs) {
                if (!pair.getName().equals(columnPairName)) continue;
                return pair;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWColumnPair columnPairFor(MWColumn sourceColumn, MWColumn targetColumn) {
        Collection collection = this.columnPairs;
        synchronized (collection) {
            for (MWColumnPair pair : this.columnPairs) {
                if (!pair.pairs(sourceColumn, targetColumn)) continue;
                return pair;
            }
        }
        return null;
    }

    public boolean isForeignKeyReference() {
        return !this.isPrimaryKeyReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPrimaryKeyReference() {
        Collection sourcePrimaryKeys = CollectionTools.collection(this.getSourceTable().primaryKeyColumns());
        if (sourcePrimaryKeys.size() != this.columnPairs.size()) {
            return false;
        }
        Collection targetPrimaryKeys = CollectionTools.collection(this.getTargetTable().primaryKeyColumns());
        if (targetPrimaryKeys.size() != this.columnPairs.size()) {
            return false;
        }
        Collection collection = this.columnPairs;
        synchronized (collection) {
            for (MWColumnPair pair : this.columnPairs) {
                if (!sourcePrimaryKeys.remove(pair.getSourceColumn())) {
                    return false;
                }
                if (targetPrimaryKeys.remove(pair.getTargetColumn())) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.targetTableHandle);
        Collection collection = this.columnPairs;
        synchronized (collection) {
            children.addAll(this.columnPairs);
        }
    }

    private MWHandle.NodeReferenceScrubber buildTargetTableScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWReference.this.setTargetTable(null);
            }

            public String toString() {
                return "MWReference.buildTargetTableScrubber()";
            }
        };
    }

    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        if (this.columnPairs.isEmpty()) {
            currentProblems.add(this.buildProblem("0703", this.getName()));
        }
        if (this.getTargetTable() == null) {
            currentProblems.add(this.buildProblem("0707", this.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshColumnPairs(ExternalForeignKey externalForeignKey) {
        HashSet removedColumnPairs;
        Collection collection = this.columnPairs;
        synchronized (collection) {
            removedColumnPairs = new HashSet(this.columnPairs);
        }
        ExternalForeignKeyColumnPair[] externalPairs = externalForeignKey.getColumnPairs();
        int i = externalPairs.length;
        while (i-- > 0) {
            this.refreshColumnPair(externalPairs[i], removedColumnPairs);
        }
        this.removeColumnPairs(removedColumnPairs);
    }

    private void refreshColumnPair(ExternalForeignKeyColumnPair externalPair, Collection removedColumnPairs) {
        Iterator stream = removedColumnPairs.iterator();
        while (stream.hasNext()) {
            if (!((MWColumnPair)stream.next()).matches(externalPair)) continue;
            stream.remove();
            return;
        }
        this.addColumnPair(this.sourceColumn(externalPair), this.targetColumn(externalPair));
    }

    MWColumn sourceColumn(ExternalForeignKeyColumnPair externalPair) {
        return this.getSourceTable().column(externalPair.getSourceColumn());
    }

    MWColumn targetColumn(ExternalForeignKeyColumnPair externalPair) {
        return this.getTargetTable().column(externalPair.getTargetColumn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean matchesColumnPairs(ExternalForeignKey externalForeignKey) {
        HashSet columnPairsCopy;
        ExternalForeignKeyColumnPair[] externalPairs = externalForeignKey.getColumnPairs();
        int externalPairsLength = externalPairs.length;
        if (this.columnPairs.size() != externalPairsLength) {
            return false;
        }
        Collection collection = this.columnPairs;
        synchronized (collection) {
            columnPairsCopy = new HashSet(this.columnPairs);
        }
        int i = externalPairsLength;
        while (i-- > 0) {
            ExternalForeignKeyColumnPair externalPair = externalPairs[i];
            boolean match = false;
            Iterator stream = columnPairsCopy.iterator();
            while (stream.hasNext()) {
                if (!((MWColumnPair)stream.next()).matches(externalPair)) continue;
                stream.remove();
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ForeignKeyConstraint buildRuntimeConstraint() {
        ForeignKeyConstraint fkc = new ForeignKeyConstraint();
        fkc.setName(this.getName());
        if (this.getTargetTable() != null) {
            fkc.setTargetTable(this.getTargetTable().getName());
        }
        Collection collection = this.columnPairs;
        synchronized (collection) {
            Iterator stream = this.columnPairs.iterator();
            while (stream.hasNext()) {
                ((MWColumnPair)stream.next()).configureRuntimeConstraint(fkc);
            }
        }
        return fkc;
    }

    public String displayString() {
        return this.name;
    }

    public void toString(StringBuffer sb) {
        sb.append(this.name);
        sb.append(" : ");
        this.printTableNameOn(this.getSourceTable(), sb);
        sb.append("=>");
        this.printTableNameOn(this.getTargetTable(), sb);
    }

    private void printTableNameOn(MWTable table, StringBuffer sb) {
        sb.append(table == null ? "null" : table.getName());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWReference.class);
        descriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        XMLCompositeObjectMapping targetTableHandleMapping = new XMLCompositeObjectMapping();
        targetTableHandleMapping.setAttributeName("targetTableHandle");
        targetTableHandleMapping.setGetMethodName("getTargetTableHandleForTopLink");
        targetTableHandleMapping.setSetMethodName("setTargetTableHandleForTopLink");
        targetTableHandleMapping.setReferenceClass(MWTableHandle.class);
        targetTableHandleMapping.setXPath("target-table-handle");
        descriptor.addMapping((DatabaseMapping)targetTableHandleMapping);
        ((XMLDirectMapping)descriptor.addDirectMapping(ON_DATABASE_PROPERTY, "on-database/text()")).setNullValue((Object)Boolean.FALSE);
        XMLCompositeCollectionMapping columnPairsMapping = new XMLCompositeCollectionMapping();
        columnPairsMapping.setAttributeName(COLUMN_PAIRS_COLLECTION);
        columnPairsMapping.setReferenceClass(MWColumnPair.class);
        columnPairsMapping.setXPath("column-pairs/column-pair");
        descriptor.addMapping((DatabaseMapping)columnPairsMapping);
        return descriptor;
    }

    private MWTableHandle getTargetTableHandleForTopLink() {
        return this.targetTableHandle.getTable() == null ? null : this.targetTableHandle;
    }

    private void setTargetTableHandleForTopLink(MWTableHandle targetTableHandle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildTargetTableScrubber();
        this.targetTableHandle = targetTableHandle == null ? new MWTableHandle(this, scrubber) : targetTableHandle.setScrubber(scrubber);
    }
}

