/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.cell;

import java.awt.Color;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.cell.LabeledTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TreeCellEditorAdapter;

public class SpinnerTreeCellRenderer
extends LabeledTreeCellRenderer
implements TreeCellEditorAdapter.Renderer {
    protected TreeCellEditorAdapter.ImmediateEditListener immediateEditListener;

    public SpinnerTreeCellRenderer(String labelText, Icon labelIcon) {
        super(labelText, labelIcon);
    }

    public SpinnerTreeCellRenderer(String labelText) {
        super(labelText);
    }

    public SpinnerTreeCellRenderer(Icon labelIcon) {
        super(labelIcon);
    }

    public SpinnerTreeCellRenderer() {
    }

    public SpinnerTreeCellRenderer(String labelText, SpinnerModel model) {
        this(labelText);
        this.setModel(model);
    }

    public SpinnerTreeCellRenderer(SpinnerModel model) {
        this();
        this.setModel(model);
    }

    protected JComponent buildComponent() {
        JSpinner spinner = new JSpinner();
        spinner.addChangeListener(this.buildChangeListener());
        return spinner;
    }

    private ChangeListener buildChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (SpinnerTreeCellRenderer.this.immediateEditListener != null) {
                    SpinnerTreeCellRenderer.this.immediateEditListener.immediateEdit();
                }
            }
        };
    }

    protected JSpinner getSpinner() {
        return (JSpinner)this.component;
    }

    protected JComponent editor() {
        JComponent editor = this.getSpinner().getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            editor = ((JSpinner.DefaultEditor)editor).getTextField();
        }
        return editor;
    }

    protected void setForeground(Color c) {
        super.setForeground(c);
        this.editor().setForeground(c);
    }

    protected void setBackground(Color c) {
        super.setBackground(c);
        this.editor().setBackground(c);
    }

    protected void setValue(Object value) {
        this.getSpinner().setValue(value);
    }

    public Object getValue() {
        return this.getSpinner().getValue();
    }

    public void setImmediateEditListener(TreeCellEditorAdapter.ImmediateEditListener listener) {
        this.immediateEditListener = listener;
    }

    public void setModel(SpinnerModel model) {
        this.getSpinner().setModel(model);
    }

    protected void addActionListener(ActionListener listener) {
        JComponent editor = this.editor();
        if (!(editor instanceof JTextField)) {
            throw new UnsupportedOperationException(editor.getClass().getName());
        }
        ((JTextField)editor).addActionListener(listener);
    }
}

