/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.io.Serializable;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;

public abstract class AbstractTreeModel
implements TreeModel,
Serializable {
    protected EventListenerList listenerList;

    protected AbstractTreeModel() {
        this.initialize();
    }

    protected void initialize() {
        this.listenerList = new EventListenerList();
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    public TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
    }

    protected boolean hasNoTreeModelListeners() {
        return this.listenerList.getListenerCount(TreeModelListener.class) == 0;
    }

    protected boolean hasTreeModelListeners() {
        return !this.hasNoTreeModelListeners();
    }

    protected void fireTreeNodesChanged(Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    protected void fireTreeNodeChanged(Object[] path, int childIndex, Object child) {
        this.fireTreeNodesChanged(path, new int[]{childIndex}, new Object[]{child});
    }

    protected void fireTreeRootChanged(Object root) {
        this.fireTreeNodesChanged(new Object[]{root}, null, null);
    }

    protected void fireTreeNodesInserted(Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    protected void fireTreeNodeInserted(Object[] path, int childIndex, Object child) {
        this.fireTreeNodesInserted(path, new int[]{childIndex}, new Object[]{child});
    }

    protected void fireTreeNodesRemoved(Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    protected void fireTreeNodeRemoved(Object[] path, int childIndex, Object child) {
        this.fireTreeNodesRemoved(path, new int[]{childIndex}, new Object[]{child});
    }

    protected void fireTreeStructureChanged(Object[] path) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, path);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    protected void fireTreeRootReplaced(Object newRoot) {
        this.fireTreeStructureChanged(new Object[]{newRoot});
    }
}

