/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModelChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

public class PropertyCollectionValueModelAdapter
extends AbstractModel
implements CollectionValueModel {
    protected PropertyValueModel valueHolder;
    protected PropertyChangeListener propertyChangeListener;
    protected Object value;

    public PropertyCollectionValueModelAdapter(PropertyValueModel valueHolder) {
        if (valueHolder == null) {
            throw new NullPointerException();
        }
        this.valueHolder = valueHolder;
    }

    protected void initialize() {
        super.initialize();
        this.propertyChangeListener = this.buildPropertyChangeListener();
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ValueModelChangeSupport(this);
    }

    protected PropertyChangeListener buildPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                PropertyCollectionValueModelAdapter.this.valueChanged(e.getNewValue());
            }

            public String toString() {
                return "property change listener";
            }
        };
    }

    public Object getValue() {
        if (this.value == null) {
            return NullIterator.instance();
        }
        return new SingleElementIterator(this.value);
    }

    public void addItem(Object item) {
        throw new UnsupportedOperationException();
    }

    public void addItems(Collection items) {
        throw new UnsupportedOperationException();
    }

    public void removeItem(Object item) {
        throw new UnsupportedOperationException();
    }

    public void removeItems(Collection items) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.value == null ? 0 : 1;
    }

    public void addCollectionChangeListener(CollectionChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addCollectionChangeListener(listener);
    }

    public void addCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        if (collectionName == "value" && this.hasNoListeners()) {
            this.engageModel();
        }
        super.addCollectionChangeListener(collectionName, listener);
    }

    public void removeCollectionChangeListener(CollectionChangeListener listener) {
        super.removeCollectionChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    public void removeCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        super.removeCollectionChangeListener(collectionName, listener);
        if (collectionName == "value" && this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasListeners() {
        return this.hasAnyCollectionChangeListeners("value");
    }

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected void engageModel() {
        this.valueHolder.addPropertyChangeListener("value", this.propertyChangeListener);
        this.value = this.valueHolder.getValue();
    }

    protected void disengageModel() {
        this.valueHolder.removePropertyChangeListener("value", this.propertyChangeListener);
        this.value = null;
    }

    protected void valueChanged(Object newValue) {
        if (this.value != null) {
            Object oldValue = this.value;
            this.value = null;
            this.fireItemRemoved("value", oldValue);
        }
        this.value = newValue;
        if (this.value != null) {
            this.fireItemAdded("value", this.value);
        }
    }

    public void toString(StringBuffer sb) {
        sb.append(this.valueHolder);
    }
}

