/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.framework.uitools.TriStateBooleanCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic.EventListenersPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;

public final class SessionOptionsPropertiesPage
extends ScrollablePropertiesPage {
    public SessionOptionsPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    private ValueModel buildClassRepositoryHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                SCAdapter adapter = (SCAdapter)((Object)this.subject);
                return adapter.getClassRepository();
            }
        };
    }

    private JButton buildExceptionHandlerBrowseButton() {
        return ClassChooserTools.buildBrowseButton(this.getWorkbenchContextHolder(), "OPTIONS_EXCEPTION_HANDLER_BROWSE_BUTTON", this.buildClassRepositoryHolder(), this.buildExceptionHandlerHolder());
    }

    private Document buildExceptionHandlerDocumentAdapter() {
        return new DocumentAdapter(this.buildExceptionHandlerHolder(), new RegexpDocument(3));
    }

    private PropertyValueModel buildExceptionHandlerHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "exceptionHandlerClass"){

            protected Object getValueFromSubject() {
                SessionAdapter adapter = (SessionAdapter)this.subject;
                return adapter.getExceptionHandlerClass();
            }

            protected void setValueOnSubject(Object value) {
                SessionAdapter adapter = (SessionAdapter)this.subject;
                adapter.setExceptionHandlerClass((String)value);
            }
        };
    }

    protected Component buildPage() {
        GridBagConstraints constraints = new GridBagConstraints();
        Insets offset = BorderFactory.createTitledBorder("m").getBorderInsets(this);
        offset.right += 5;
        offset.left += 5;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JComponent profilerWidgets = this.buildLabeledComboBox("OPTIONS_PROFILER_COMBO_BOX", this.buildProfilerComboBoxAdapter(), new AdaptableListCellRenderer(this.buildProfilerLabelDecorator()));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, offset.left, 0, offset.right);
        panel.add((Component)profilerWidgets, constraints);
        this.addHelpTopicId(profilerWidgets, "session.options.profiler");
        JComponent exceptionHandlerWidgets = this.buildLabeledTextField("OPTIONS_EXCEPTION_HANDLER_FIELD", this.buildExceptionHandlerDocumentAdapter(), this.buildExceptionHandlerBrowseButton());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, offset.left, 0, offset.right);
        panel.add((Component)exceptionHandlerWidgets, constraints);
        this.addHelpTopicId(exceptionHandlerWidgets, "session.options.exceptionHandler");
        JComponent sessionCustomizerClassWidgets = this.buildLabeledTextField("OPTIONS_SESSION_CUSTOMIZER_CLASS_FIELD", this.buildSessionCustomizerClassDocumentAdapter(), this.buildSessionCustomizerBrowseButton());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, offset.left, 0, offset.right);
        panel.add((Component)sessionCustomizerClassWidgets, constraints);
        this.addHelpTopicId(sessionCustomizerClassWidgets, "session.options.sessionCustomizerClass");
        EventListenersPane eventListenersPane = new EventListenersPane(this.getSelectionHolder(), this.getWorkbenchContextHolder());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)eventListenersPane, constraints);
        this.addPaneForAlignment(eventListenersPane);
        this.addHelpTopicId(panel, "session.options");
        return panel;
    }

    private CollectionValueModel buildProfilerCollectionHolder() {
        Vector<TriStateBoolean> booleanValues = new Vector<TriStateBoolean>();
        booleanValues.add(TriStateBoolean.UNDEFINED);
        if (this.isTopLinkProfilerFirst()) {
            booleanValues.add(TriStateBoolean.TRUE);
            booleanValues.add(TriStateBoolean.FALSE);
        } else {
            booleanValues.add(TriStateBoolean.FALSE);
            booleanValues.add(TriStateBoolean.TRUE);
        }
        return new ReadOnlyCollectionValueModel(booleanValues);
    }

    private ComboBoxModel buildProfilerComboBoxAdapter() {
        return new ComboBoxModelAdapter(this.buildProfilerCollectionHolder(), this.buildProfilerSelectionHolder());
    }

    private CellRendererAdapter buildProfilerLabelDecorator() {
        return new TriStateBooleanCellRendererAdapter(this.resourceRepository()){

            protected String undefinedResourceKey() {
                return "OPTIONS_PROFILER_NO_PROFILER_CHOICE";
            }

            protected String trueResourceKey() {
                return "OPTIONS_PROFILER_TOPLINK_CHOICE";
            }

            protected String falseResourceKey() {
                return "OPTIONS_PROFILER_DMS_CHOICE";
            }
        };
    }

    private PropertyValueModel buildProfilerSelectionHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "profiler"){

            protected Object getValueFromSubject() {
                SessionAdapter adapter = (SessionAdapter)this.subject;
                String profiler = adapter.getProfiler();
                if (profiler == null) {
                    return TriStateBoolean.UNDEFINED;
                }
                boolean useTopLinkProfiler = "toplink".equals(profiler);
                return TriStateBoolean.valueOf((boolean)useTopLinkProfiler);
            }

            protected void setValueOnSubject(Object value) {
                SessionAdapter session = (SessionAdapter)this.subject;
                if (TriStateBoolean.UNDEFINED.equals(value)) {
                    session.setProfiler(null);
                } else if (TriStateBoolean.TRUE.equals(value)) {
                    session.setProfiler("toplink");
                } else {
                    session.setProfiler("dms");
                }
            }
        };
    }

    private JButton buildSessionCustomizerBrowseButton() {
        return ClassChooserTools.buildBrowseButton(this.getWorkbenchContextHolder(), "OPTIONS_SESSION_CUSTOMIZER_CLASS_BROWSE_BUTTON", this.buildClassRepositoryHolder(), this.buildSessionCustomizerClassHolder());
    }

    private Document buildSessionCustomizerClassDocumentAdapter() {
        return new DocumentAdapter(this.buildSessionCustomizerClassHolder(), new RegexpDocument(3));
    }

    private PropertyValueModel buildSessionCustomizerClassHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "sessionCustomizerClass"){

            protected Object getValueFromSubject() {
                SessionAdapter adapter = (SessionAdapter)this.subject;
                return adapter.getSessionCustomizerClass();
            }

            protected void setValueOnSubject(Object value) {
                SessionAdapter adapter = (SessionAdapter)this.subject;
                adapter.setSessionCustomizerClass((String)value);
            }
        };
    }

    private boolean isTopLinkProfilerFirst() {
        Vector<String> orderedList = new Vector<String>();
        orderedList.add(this.resourceRepository().getString("OPTIONS_PROFILER_TOPLINK_CHOICE"));
        orderedList.add(this.resourceRepository().getString("OPTIONS_PROFILER_DMS_CHOICE"));
        Collections.sort(orderedList);
        return orderedList.firstElement().equals(this.resourceRepository().getString("OPTIONS_PROFILER_TOPLINK_CHOICE"));
    }
}

