/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.SequenceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.SequencingConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.SequenceType;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DefaultSequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NativeSequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TableSequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.UnaryTableSequenceAdapter;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequencingAdapter
extends SCAdapter {
    public static final String DEFAULT_SEQUENCE_NAME = "Default";
    public static final String NATIVE_SEQUENCE_NAME = "Native";
    public static final String CUSTOM_SEQUENCE_NAME = "Custom";
    private List<SequenceAdapter> sequences;
    private volatile SequenceAdapter defaultSequence;

    SequencingAdapter(SCAdapter parent, SequencingConfig scConfig) {
        super(parent, scConfig);
    }

    protected SequencingAdapter(SCAdapter parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        List<SequenceAdapter> list = this.sequences;
        synchronized (list) {
            children.addAll(this.sequences);
        }
        if (this.defaultSequence != null) {
            children.add(this.defaultSequence);
        }
    }

    @Override
    protected Object buildModel() {
        return new SequencingConfig();
    }

    private final SequencingConfig config() {
        return (SequencingConfig)this.getModel();
    }

    int getDefaultSequencePreallocationSize() {
        return this.defaultSequence.getPreallocationSize();
    }

    void setDefaultSequencePreallocationSize(int value) {
        this.defaultSequence.setPreallocationSize(value);
    }

    String getTableSequenceTable() {
        if (this.defaultSequence.isNative()) {
            return null;
        }
        return ((TableSequenceAdapter)this.defaultSequence).getSequenceTable();
    }

    void setTableSequenceTable(String value) {
        ((TableSequenceAdapter)this.defaultSequence).setSequenceTable(value);
    }

    String getTableSequenceNameField() {
        if (this.defaultSequence.isNative()) {
            return null;
        }
        return ((TableSequenceAdapter)this.defaultSequence).getSequenceNameField();
    }

    void setTableSequenceNameField(String value) {
        ((TableSequenceAdapter)this.defaultSequence).setSequenceNameField(value);
    }

    String getTableSequenceCounterField() {
        if (this.defaultSequence.isNative()) {
            return null;
        }
        return ((TableSequenceAdapter)this.defaultSequence).getSequenceCounterField();
    }

    void setTableSequenceCounterField(String value) {
        ((TableSequenceAdapter)this.defaultSequence).setSequenceCounterField(value);
    }

    private boolean defaultSequenceNameEquals(String name) {
        return this.defaultSequence != null && this.defaultSequence.getName().equals(name);
    }

    SequenceAdapter setDefaultTableSequenceTable(String name, int preallocationSize) {
        if (this.defaultSequenceNameEquals(name)) {
            return this.defaultSequence;
        }
        this.defaultSequence = new TableSequenceAdapter(this, name, preallocationSize);
        this.config().setDefaultSequenceConfig((SequenceConfig)this.defaultSequence.getModel());
        this.initializeDefaultSequenceDefaults();
        return this.defaultSequence;
    }

    SequenceAdapter setNativeSequencing(String name, int preallocationSize) {
        if (this.defaultSequenceNameEquals(name)) {
            return this.defaultSequence;
        }
        this.defaultSequence = new NativeSequenceAdapter(this, name, preallocationSize);
        this.config().setDefaultSequenceConfig((SequenceConfig)this.defaultSequence.getModel());
        return this.defaultSequence;
    }

    private void initializeDefaultSequenceDefaults() {
        TableSequenceAdapter sequence = (TableSequenceAdapter)this.defaultSequence;
        sequence.setSequenceTable("SEQUENCE");
        sequence.setSequenceCounterField("SEQ_COUNT");
        sequence.setSequenceNameField("SEQ_NAME");
    }

    SequenceAdapter removeDefaultSequence() {
        if (this.defaultSequence == null) {
            return null;
        }
        SequenceAdapter removedSequence = this.defaultSequence;
        this.config().setDefaultSequenceConfig(null);
        this.defaultSequence = null;
        return removedSequence;
    }

    SequenceAdapter removeSequenceNamed(String name) {
        return this.removeSequence(this.sequenceNamed(name));
    }

    private SequenceAdapter addSequence(SequenceAdapter sequenceAdapter) {
        this.getSequenceConfigs().add((SequenceConfig)sequenceAdapter.getModel());
        this.sequences.add(sequenceAdapter);
        return sequenceAdapter;
    }

    public SequenceAdapter addSequence(String name, SequenceType sequenceType) {
        SequenceAdapter sequence = this.buildSequence(name, sequenceType);
        return this.addSequence(sequence);
    }

    private SequenceAdapter buildSequence(String name, SequenceType sequenceType) {
        switch (sequenceType) {
            case DEFAULT: {
                return new DefaultSequenceAdapter(this, name, 50);
            }
            case NATIVE: {
                return new NativeSequenceAdapter(this, name, 50);
            }
            case TABLE: {
                return new TableSequenceAdapter(this, name, 50);
            }
            case UNARY_TABLE: {
                return new UnaryTableSequenceAdapter(this, name, 50);
            }
        }
        return null;
    }

    public SequenceAdapter removeSequence(SequenceAdapter sequenceAdapter) {
        this.getSequenceConfigs().remove(sequenceAdapter.getModel());
        this.sequences.remove(sequenceAdapter);
        return sequenceAdapter;
    }

    private Collection getSequenceConfigs() {
        return this.config().getSequenceConfigs();
    }

    boolean usesNativeSequencing() {
        return this.defaultSequenceNameEquals(NATIVE_SEQUENCE_NAME);
    }

    public SequenceAdapter getDefaultSequence() {
        return this.defaultSequence;
    }

    public void setDefaultSequence(SequenceAdapter adapter) {
        this.defaultSequence.setTheDefaultSequence(false);
        this.defaultSequence = adapter;
        adapter.setTheDefaultSequence(true);
        this.config().setDefaultSequenceConfig((SequenceConfig)this.defaultSequence.getModel());
    }

    public SequenceAdapter createAndSetDefaultSequence(String name, SequenceType type) {
        SequenceAdapter adapter = this.buildSequence(name, type);
        this.setDefaultSequence(adapter);
        return adapter;
    }

    protected SequenceAdapter buildDefaultSequence() {
        TableSequenceAdapter sequence = new TableSequenceAdapter(this, DEFAULT_SEQUENCE_NAME, 50);
        sequence.setTheDefaultSequence(true);
        this.config().setDefaultSequenceConfig((SequenceConfig)sequence.getModel());
        return sequence;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.sequences = new Vector<SequenceAdapter>();
    }

    @Override
    protected void initialize(Object newConfig) {
        super.initialize(newConfig);
        this.defaultSequence = this.buildDefaultSequence();
        this.config().setSequenceConfigs(new Vector());
    }

    @Override
    protected void initializeDefaults() {
        super.initializeDefaults();
        this.setDefaultSequencePreallocationSize(50);
    }

    @Override
    protected void initializeFromModel(Object scConfig) {
        super.initializeFromModel(scConfig);
        this.defaultSequence = (SequenceAdapter)this.adapt(this.config().getDefaultSequenceConfig());
        if (this.defaultSequence == null) {
            this.defaultSequence = this.buildDefaultSequence();
        } else {
            this.defaultSequence.setTheDefaultSequence(true);
        }
        if (this.getSequenceConfigs() != null) {
            this.sequences.addAll(this.adaptAll(this.getSequenceConfigs()));
        }
    }

    SequenceAdapter sequenceNamed(String name) {
        ListIterator<SequenceAdapter> i = this.sequences();
        while (i.hasNext()) {
            SequenceAdapter sequence = (SequenceAdapter)i.next();
            if (!name.equals(sequence.getName())) continue;
            return sequence;
        }
        return null;
    }

    public ListIterator<SequenceAdapter> sequences() {
        return new CloneListIterator(this.sequences);
    }

    public Iterator<String> sequenceNames() {
        ListIterator<SequenceAdapter> sequencesIter = this.sequences();
        ArrayList<String> names = new ArrayList<String>(this.sequencesSize());
        while (sequencesIter.hasNext()) {
            names.add(((SequenceAdapter)sequencesIter.next()).getName());
        }
        return names.iterator();
    }

    public int sequencesSize() {
        return this.sequences.size();
    }

    boolean isDefault() {
        return this.defaultSequence.isDefault();
    }

    boolean isNative() {
        return this.defaultSequence.isNative();
    }

    boolean isCustom() {
        return this.defaultSequence.isCustom();
    }
}

