/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.scplugin.model.SCModel;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.ClassRepository;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public abstract class SCAdapter
extends SCModel {
    private static final String adapterPackageName = ClassTools.packageNameFor(SCAdapter.class) + ".";
    private static final String adapterClassSuffix = "Adapter";
    public static final String modelClassSuffix = "Config";
    private volatile Object config;
    private volatile boolean configClean;
    private volatile boolean configRequired;

    SCAdapter() {
    }

    protected SCAdapter(SCAdapter parent) {
        super(parent);
        this.initialize(this.buildModel());
        this.initializeDefaults();
        this.setConfigClean(true);
    }

    SCAdapter(SCAdapter parent, Object configObject) {
        super(parent);
        this.initializeFromModel(configObject);
        this.setConfigClean(false);
    }

    protected abstract Object buildModel();

    Preferences preferences() {
        return ((SCAdapter)this.getParent()).preferences();
    }

    public ClassRepository getClassRepository() {
        return ((SCAdapter)this.getParent()).getClassRepository();
    }

    protected Object getModel() {
        return this.config;
    }

    protected final String getConfigFileVersion() {
        if (this.getParent() == null) {
            return ((TopLinkSessionsAdapter)this).getVersion();
        }
        return ((SCAdapter)this.getParent()).getConfigFileVersion();
    }

    protected final boolean configVersionIsPre10g() {
        char c;
        String versionString = this.getConfigFileVersion();
        int version = 0;
        for (int i = 0; i < versionString.length() && Character.isDigit(c = versionString.charAt(i)); ++i) {
            version *= 10;
            version += Character.digit(c, 10);
        }
        return version > 3 && version < 10;
    }

    public boolean hasNoConfigToSave() {
        return this.isACleanConfig() && !this.isARequiredConfig();
    }

    protected boolean isACleanConfig() {
        return this.configClean;
    }

    public boolean isARequiredConfig() {
        return this.configRequired;
    }

    private final void setModel(Object config) {
        this.config = config;
    }

    protected final void setConfigClean(boolean clean) {
        this.configClean = clean;
    }

    protected final void setConfigRequired(boolean required) {
        this.configRequired = required;
    }

    protected void markEntireConfigurationClean() {
        this.setConfigClean(true);
        Iterator i = this.children();
        while (i.hasNext()) {
            ((SCAdapter)((Object)i.next())).setConfigClean(true);
        }
    }

    public void markBranchDirty() {
        super.markBranchDirty();
        this.setConfigClean(false);
    }

    protected void preSaving() {
    }

    protected void postSaving() {
    }

    protected Collection adaptAll(Collection configObjects) {
        ArrayList<SCAdapter> result = new ArrayList<SCAdapter>(configObjects.size());
        Iterator i = configObjects.iterator();
        while (i.hasNext()) {
            result.add(this.adapt(i.next()));
        }
        return result;
    }

    protected SCAdapter adapt(Object configObject) {
        if (configObject == null) {
            return null;
        }
        Constructor adapterConstructor = this.adapterConstructorFor(configObject);
        return SCAdapter.buildsAdapterWith(adapterConstructor, new Object[]{this, configObject});
    }

    protected Collection modelObjectsFrom(Collection adapters) {
        TransformationIterator iterator = new TransformationIterator(adapters.iterator()){

            protected Object transform(Object next) {
                return ((SCAdapter)((Object)next)).getModel();
            }
        };
        return CollectionTools.collection((Iterator)iterator);
    }

    protected SCAdapter findAdapterFor(Object modelObject, Iterator iterator) {
        Iterator i = iterator;
        while (i.hasNext()) {
            SCAdapter adapter = (SCAdapter)((Object)i.next());
            if (adapter.getModel() != modelObject) continue;
            return adapter;
        }
        return null;
    }

    private final Constructor adapterConstructorFor(Object configObject) {
        Class adapterClass = this.adapterClassFor(configObject);
        Class<?> configClass = configObject.getClass();
        return SCAdapter.adapterConstructorFor(configClass, adapterClass, 2);
    }

    static final Constructor adapterConstructor(Class adapterClass) {
        Object configObject = null;
        try {
            configObject = ((SCAdapter)((Object)adapterClass.newInstance())).buildModel();
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Instantiation Exception When Instantiating " + adapterClass.getName(), ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Illegal Access Exception When Instantiating " + adapterClass.getName(), iae);
        }
        return SCAdapter.adapterConstructorFor(configObject.getClass(), adapterClass, 1);
    }

    private static final Constructor adapterConstructorFor(Class configClass, Class adapterClass, int numberOfConstructorParameter) {
        ArrayIterator i = new ArrayIterator((Object[])adapterClass.getDeclaredConstructors());
        while (i.hasNext()) {
            Constructor adapterConstructor = (Constructor)i.next();
            Class<?>[] parameters = adapterConstructor.getParameterTypes();
            if (parameters.length != numberOfConstructorParameter) continue;
            if (parameters.length == 2 && parameters[0].isAssignableFrom(SCAdapter.class) && parameters[1].isAssignableFrom(configClass)) {
                return adapterConstructor;
            }
            if (parameters.length == 1 && parameters[0].isAssignableFrom(SCAdapter.class)) {
                return adapterConstructor;
            }
            if (parameters.length != 0) continue;
            return adapterConstructor;
        }
        throw new NoSuchElementException("No Valid Constructor Found for: " + adapterClass.getName());
    }

    private final Class adapterClassFor(Object configObject) {
        String configClassName = ClassTools.shortNameFor(configObject.getClass());
        return SCAdapter.adapterClassNamed(configClassName);
    }

    static final Class adapterClassNamed(String configClassName) {
        String adapterClassName = adapterPackageName + configClassName.substring(0, configClassName.lastIndexOf(modelClassSuffix)) + adapterClassSuffix;
        Class adapterClass = null;
        try {
            adapterClass = ClassTools.classForName((String)adapterClassName);
        }
        catch (RuntimeException e) {
            throw new NoSuchElementException("Adapter Class Not Known For SC Model Class: " + configClassName);
        }
        return adapterClass;
    }

    static final SCAdapter buildsAdapterWith(Constructor adapterConstructor, Object[] parameters) {
        SCAdapter newAdapter = null;
        try {
            newAdapter = (SCAdapter)((Object)adapterConstructor.newInstance(parameters));
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException("InvocationTarget Exception When Instantiating " + adapterConstructor.getName(), ite);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Instantiation Exception When Instantiating " + adapterConstructor.getName(), ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Illegal Access Exception When Instantiating " + adapterConstructor.getName(), iae);
        }
        return newAdapter;
    }

    protected void initializeFromModel(Object configObject) {
        this.setModel(configObject);
    }

    protected void postInitializationFromModel() {
        Iterator iter = this.children();
        while (iter.hasNext()) {
            ((SCAdapter)((Object)iter.next())).postInitializationFromModel();
        }
    }

    protected void initialize() {
        super.initialize();
        this.setConfigRequired(false);
    }

    protected void initialize(Object newConfig) {
        this.setModel(newConfig);
    }

    protected void initializeDefaults() {
    }
}

