/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamespace;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractTreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.NullListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TreeModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.DisplayableTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class SchemaComplexTypeChooserDialog
extends AbstractDialog {
    private MWXmlSchema schema;
    private PropertyValueModel complexTypeHolder;
    private PropertyValueModel selectedComplexTypeHolder;
    private TreeSelectionModel treeSelectionModel;

    SchemaComplexTypeChooserDialog(WorkbenchContext context, MWXmlSchema schema, PropertyValueModel complexTypeHolder) {
        super(context);
        this.initialize(schema, complexTypeHolder);
    }

    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("SCHEMA_COMPLEX_TYPE_CHOOSER_DIALOG.TITLE"));
        this.getOKAction().setEnabled(false);
    }

    private void initialize(MWXmlSchema schema, PropertyValueModel complexTypeHolder) {
        this.schema = schema;
        this.complexTypeHolder = complexTypeHolder;
        this.selectedComplexTypeHolder = this.buildSelectedComplexTypeHolder();
        this.treeSelectionModel = this.buildTreeSelectionModel();
    }

    private PropertyValueModel buildSelectedComplexTypeHolder() {
        SimplePropertyValueModel selectedComplexTypeHolder = new SimplePropertyValueModel(null);
        selectedComplexTypeHolder.addPropertyChangeListener("value", this.buildSelectedComplexTypeListener());
        return selectedComplexTypeHolder;
    }

    private PropertyChangeListener buildSelectedComplexTypeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SchemaComplexTypeChooserDialog.this.getOKAction().setEnabled(evt.getNewValue() != null);
            }
        };
    }

    private TreeSelectionModel buildTreeSelectionModel() {
        DefaultTreeSelectionModel treeSelectionModel = new DefaultTreeSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        treeSelectionModel.addTreeSelectionListener(this.buildTreeSelectionListener());
        return treeSelectionModel;
    }

    private TreeSelectionListener buildTreeSelectionListener() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent tse) {
                SchemaComplexTypeChooserDialog.this.treeSelectionChanged();
            }
        };
    }

    protected Component buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setPreferredSize(new Dimension(350, 350));
        panel.add((Component)this.buildTreePane(), "Center");
        return panel;
    }

    private JScrollPane buildTreePane() {
        return new JScrollPane(this.buildTree());
    }

    private JTree buildTree() {
        JTree tree = SwingComponentFactory.buildTree(this.buildTreeModel());
        tree.setSelectionModel(this.treeSelectionModel);
        tree.setCellRenderer(this.buildTreeCellRenderer());
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setRowHeight(20);
        tree.setDoubleBuffered(true);
        tree.expandRow(0);
        return tree;
    }

    private TreeModelAdapter buildTreeModel() {
        return new TreeModelAdapter(this.buildTreeRoot());
    }

    private SchemaNode buildTreeRoot() {
        return new SchemaNode(this.schema);
    }

    private TreeCellRenderer buildTreeCellRenderer() {
        return new DisplayableTreeCellRenderer();
    }

    private void treeSelectionChanged() {
        TreePath selectedPath = this.treeSelectionModel.getSelectionPath();
        Object newElement = null;
        if (selectedPath != null) {
            newElement = ((ComplexTypeNode)this.treeSelectionModel.getSelectionPath().getLastPathComponent()).getValue();
        }
        this.selectedComplexTypeHolder.setValue(newElement);
    }

    public MWElementDeclaration selectedRootElement() {
        return (MWElementDeclaration)this.selectedComplexTypeHolder.getValue();
    }

    protected void okConfirmed() {
        this.complexTypeHolder.setValue(this.selectedComplexTypeHolder.getValue());
        super.okConfirmed();
    }

    protected String helpTopicId() {
        return "dialog.schemaComplexTypeChooser";
    }

    public void show() {
        if (this.schema == null) {
            this.showErrorDialog();
        } else {
            super.show();
        }
    }

    private void showErrorDialog() {
        Window currentWindow = this.currentWindow();
        ResourceRepository repo = this.resourceRepository();
        String errorTitle = repo.getString("SCHEMA_COMPLEX_TYPE_CHOOSER_DIALOG.NO_CONTEXT_SPECIFIED_TITLE");
        String errorMessage = repo.getString("SCHEMA_COMPLEX_TYPE_CHOOSER_DIALOG.NO_CONTEXT_SPECIFIED_MESSAGE");
        JOptionPane.showMessageDialog(currentWindow, errorMessage, errorTitle, 2);
    }

    private static final class ComplexTypeNode
    extends AbstractTreeNodeValueModel
    implements Displayable {
        private AbstractTreeNodeValueModel parent;
        private MWComplexTypeDefinition typeDefinition;

        ComplexTypeNode(AbstractTreeNodeValueModel parent, MWComplexTypeDefinition typeDefinition) {
            this.initialize(parent, typeDefinition);
        }

        private void initialize(AbstractTreeNodeValueModel parent, MWComplexTypeDefinition complexType) {
            this.parent = parent;
            this.typeDefinition = complexType;
        }

        public Object getValue() {
            return this.typeDefinition;
        }

        public TreeNodeValueModel getParent() {
            return this.parent;
        }

        public ListValueModel getChildrenModel() {
            return NullListValueModel.instance();
        }

        protected void engageValue() {
        }

        protected void disengageValue() {
        }

        public int compareTo(Object o) {
            return ComplexTypeNodeComparator.compare(this, o);
        }

        public String displayString() {
            return this.typeDefinition.qName();
        }

        public Icon icon() {
            return null;
        }

        private static class ComplexTypeNodeComparator {
            private ComplexTypeNodeComparator() {
            }

            public static int compare(Object o1, Object o2) {
                ComplexTypeNode node1 = (ComplexTypeNode)o1;
                ComplexTypeNode node2 = (ComplexTypeNode)o2;
                MWComplexTypeDefinition type1 = node1.typeDefinition;
                MWComplexTypeDefinition type2 = node2.typeDefinition;
                int comparison = ComplexTypeNodeComparator.compare(type1.getTargetNamespace(), type2.getTargetNamespace());
                if (comparison == 0) {
                    comparison = type1.qName().compareTo(type2.qName());
                }
                return comparison;
            }

            private static int compare(MWNamespace thisNamespace, MWNamespace otherNamespace) {
                if (thisNamespace.isTargetNamespace() && !otherNamespace.isTargetNamespace()) {
                    return -1;
                }
                if (!thisNamespace.isTargetNamespace() && otherNamespace.isTargetNamespace()) {
                    return 1;
                }
                if (thisNamespace.getNamespacePrefix() != otherNamespace.getNamespacePrefix()) {
                    return thisNamespace.getNamespacePrefix().compareToIgnoreCase(otherNamespace.getNamespacePrefix());
                }
                return 0;
            }
        }
    }

    private static final class SchemaNode
    extends AbstractTreeNodeValueModel
    implements Displayable {
        private MWXmlSchema schema;
        private ListValueModel childrenModel;

        public SchemaNode(MWXmlSchema schema) {
            this.initialize(schema);
        }

        private void initialize(MWXmlSchema schema) {
            this.schema = schema;
            this.childrenModel = this.buildChildrenModel();
        }

        private ListValueModel buildChildrenModel() {
            return new SortedListValueModelAdapter(this.buildComplexTypeNodesAdapter());
        }

        private ListValueModel buildComplexTypeNodesAdapter() {
            return new TransformationListValueModelAdapter(this.buildComplexTypesAdapter()){

                protected Object transformItem(Object item) {
                    return SchemaNode.this.buildComplexTypeNode((MWComplexTypeDefinition)item);
                }
            };
        }

        private ListValueModel buildComplexTypesAdapter() {
            return new SimpleListValueModel(CollectionTools.list((Iterator)this.schema.complexTypes()));
        }

        private ComplexTypeNode buildComplexTypeNode(MWComplexTypeDefinition element) {
            return new ComplexTypeNode(this, element);
        }

        public Object getValue() {
            return this.schema;
        }

        public TreeNodeValueModel getParent() {
            return null;
        }

        public ListValueModel getChildrenModel() {
            return this.childrenModel;
        }

        protected void engageValue() {
        }

        protected void disengageValue() {
        }

        public int compareTo(Object o) {
            return DEFAULT_COMPARATOR.compare(this, o);
        }

        public String displayString() {
            return null;
        }

        public Icon icon() {
            return null;
        }
    }
}

