/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSimpleTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.NamedSchemaComponentNodeStructure;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentDetail;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentQNamedDetail;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationListIterator;

final class SimpleTypeDefinitionNodeStructure
extends NamedSchemaComponentNodeStructure {
    SimpleTypeDefinitionNodeStructure(MWSimpleTypeDefinition simpleTypeDefinition) {
        super((MWNamedSchemaComponent)simpleTypeDefinition);
    }

    protected ListIterator componentDetails() {
        return new CompositeListIterator(this.nameDetails(), this.typeDetails());
    }

    Integer topLevelOrderIndex() {
        return new Integer(4);
    }

    private ListIterator typeDetails() {
        return new CompositeListIterator((Object)this.buildVarietyDetail(), this.buildVarietySubdetails());
    }

    private SchemaComponentDetail buildVarietyDetail() {
        return new SchemaComponentDetail(this.getComponent()){

            protected String getName() {
                return "variety";
            }

            protected String getValueFromComponent() {
                return ((MWSimpleTypeDefinition)this.component).getVariety();
            }
        };
    }

    private ListIterator buildVarietySubdetails() {
        MWSimpleTypeDefinition simpleType = (MWSimpleTypeDefinition)this.getComponent();
        if (simpleType.getVariety() == "atomic") {
            return new SingleElementListIterator((Object)this.buildBaseTypeDetail());
        }
        if (simpleType.getVariety() == "list") {
            return new SingleElementListIterator((Object)this.buildItemTypeDetail());
        }
        return this.buildMemberTypeDetails();
    }

    private SchemaComponentDetail buildBaseTypeDetail() {
        return new SchemaComponentQNamedDetail(this.getComponent()){

            protected String getName() {
                return "  base";
            }

            protected MWNamedSchemaComponent getQNamedComponent() {
                return ((MWSimpleTypeDefinition)this.component).getBaseType();
            }
        };
    }

    private SchemaComponentDetail buildItemTypeDetail() {
        return new SchemaComponentQNamedDetail(this.getComponent()){

            protected String getName() {
                return "  itemType";
            }

            protected String getValueFromComponent() {
                String valueFromComponent = super.getValueFromComponent();
                if (((MWSimpleTypeDefinition)this.component).getItemType().getName() == null) {
                    valueFromComponent = "base=" + valueFromComponent;
                }
                return valueFromComponent;
            }

            protected MWNamedSchemaComponent getQNamedComponent() {
                MWSimpleTypeDefinition itemType = ((MWSimpleTypeDefinition)this.component).getItemType();
                return itemType.getName() == null ? itemType.getBaseType() : itemType;
            }
        };
    }

    private ListIterator buildMemberTypeDetails() {
        return new TransformationListIterator(((MWSimpleTypeDefinition)this.getComponent()).memberTypes()){

            protected Object transform(Object next) {
                return SimpleTypeDefinitionNodeStructure.this.buildMemberTypeDetail((MWSimpleTypeDefinition)next);
            }
        };
    }

    private SchemaComponentDetail buildMemberTypeDetail(final MWSimpleTypeDefinition memberType) {
        return new SchemaComponentQNamedDetail(this.getComponent()){

            protected String getName() {
                return "  memberType";
            }

            protected String getValueFromComponent() {
                String valueFromComponent = super.getValueFromComponent();
                if (memberType.getName() == null) {
                    valueFromComponent = "base=" + valueFromComponent;
                }
                return valueFromComponent;
            }

            protected MWNamedSchemaComponent getQNamedComponent() {
                return memberType.getName() == null ? memberType.getBaseType() : memberType;
            }
        };
    }
}

