/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.eclipse.persistence.tools.workbench.framework.Plugin;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.CompositeIconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.IconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.mappingsio.ProjectIOManager;
import org.eclipse.persistence.tools.workbench.mappingsio.ReadOnlyFilesException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWOXProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.AddOrRefreshClassesAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.AutomappableNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.CreateNewClassAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ExportDeploymentXmlAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ExportDeploymentXmlAndInitializeRuntimeDescriptorsAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ExportModelJavaSourceAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ManageNonDescriptorClassesAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPlugin;
import org.eclipse.persistence.tools.workbench.mappingsplugin.RefreshClassesAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.UiCommonBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorPackageNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MappingDescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UiDescriptorBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.UiMappingBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.DeleteProjectAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ReadOnlyFileDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.UiProjectBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.xml.EisProjectNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.xml.OXProjectNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.UiQueryBundle;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CompositeCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyCollectionValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.swing.BlockIcon;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Transformer;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class ProjectNode
extends MappingsApplicationNode
implements AutomappableNode {
    private DescriptorPackageNode.DescriptorNodeBuilder descriptorNodeBuilder;
    private CollectionChangeListener descriptorsListener;
    private PropertyChangeListener descriptorNameListener;
    private CollectionValueModel descriptorPackageNodesHolder;
    private PropertyValueModel metaDataRepositoryNodeHolder;
    private ListValueModel childrenModel;
    private boolean promptsForEjbJarXmlWrite;
    protected static final String[] PROJECT_ICON_PROPERTY_NAMES = (String[])CollectionTools.addAll((Object[])DEFAULT_ICON_PROPERTY_NAMES, (Object[])new String[]{"validating"});
    protected static final Icon VALIDATING_ICON = new BlockIcon(2);
    protected static final String[] PROJECT_DISPLAY_STRING_PROPERTY_NAMES = new String[]{"name"};
    public static final String WRITE_EJB_JAR_XML_ON_SAVE_PREFERENCE = "write ejb-jar.xml on save ";
    public static final String WRITE_EJB_JAR_XML_ON_SAVE_PREFERENCE_ALWAYS = "Yes";
    public static final String WRITE_EJB_JAR_XML_ON_SAVE_PREFERENCE_NEVER = "No";
    public static final String WRITE_EJB_JAR_XML_ON_SAVE_PREFERENCE_PROMPT = "Prompt";
    public static final String WRITE_EJB_JAR_XML_ON_SAVE_PREFERENCE_DEFAULT = "Prompt";

    public static ProjectNode forProject(MWProject project, ApplicationContext context, MappingsPlugin plugin) {
        if (project instanceof MWRelationalProject) {
            return new RelationalProjectNode((MWRelationalProject)project, context, plugin);
        }
        if (project instanceof MWOXProject) {
            return new OXProjectNode((MWOXProject)project, context, plugin);
        }
        if (project instanceof MWEisProject) {
            return new EisProjectNode((MWEisProject)project, context, plugin);
        }
        throw new IllegalArgumentException(project.toString());
    }

    protected ProjectNode(MWProject project, MappingsPlugin plugin, ApplicationContext context) {
        super((MWModel)project, context.getNodeManager().getRootNode(), (Plugin)plugin, context);
    }

    protected void initialize() {
        super.initialize();
        this.descriptorNodeBuilder = this.buildDescriptorNodeBuilder();
        this.descriptorsListener = this.buildDescriptorsListener();
        this.descriptorNameListener = this.buildDescriptorNameListener();
        this.descriptorPackageNodesHolder = new SimpleCollectionValueModel();
        this.metaDataRepositoryNodeHolder = new SimplePropertyValueModel();
        this.childrenModel = this.buildChildrenModel();
        this.promptsForEjbJarXmlWrite = true;
    }

    protected abstract DescriptorPackageNode.DescriptorNodeBuilder buildDescriptorNodeBuilder();

    private CollectionChangeListener buildDescriptorsListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                ProjectNode.this.addDescriptorNodesFor(e.items());
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                ProjectNode.this.removeDescriptorNodesFor(e.items());
            }

            public void collectionChanged(CollectionChangeEvent e) {
                ProjectNode.this.rebuildDescriptorNodes();
            }

            public String toString() {
                return "descriptors listener";
            }
        };
    }

    private PropertyChangeListener buildDescriptorNameListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String oldPackageName = ClassTools.packageNameForClassNamed((String)((String)e.getOldValue()));
                String newPackageName = ClassTools.packageNameForClassNamed((String)((String)e.getNewValue()));
                if (!newPackageName.equals(oldPackageName)) {
                    ProjectNode.this.descriptorChangedPackage((MWDescriptor)e.getSource(), oldPackageName, newPackageName);
                }
            }

            public String toString() {
                return "descriptor name listener";
            }
        };
    }

    private ListValueModel buildChildrenModel() {
        return new SortedListValueModelAdapter(this.buildChildrenDisplayStringAdapter(), Child.COMPARATOR){

            protected int indexToAddItems() {
                int index = super.indexToAddItems();
                return index > 0 ? --index : index;
            }

            public String toString() {
                return "children model";
            }
        };
    }

    private ListValueModel buildChildrenDisplayStringAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildUnsortedChildrenModel(), "displayString");
    }

    private CollectionValueModel buildUnsortedChildrenModel() {
        SimpleCollectionValueModel container = new SimpleCollectionValueModel();
        container.addItem(new PropertyCollectionValueModelAdapter(this.metaDataRepositoryNodeHolder));
        container.addItem(this.descriptorPackageNodesHolder);
        return new CompositeCollectionValueModel(container, Transformer.NULL_INSTANCE);
    }

    protected ApplicationContext expandContext(ApplicationContext context) {
        return super.expandContext(context).buildExpandedResourceRepositoryContext(UiProjectBundle.class).buildExpandedResourceRepositoryContext(UiQueryBundle.class).buildExpandedResourceRepositoryContext(UiMappingBundle.class).buildExpandedResourceRepositoryContext(UiDescriptorBundle.class).buildExpandedResourceRepositoryContext(UiCommonBundle.class);
    }

    private Iterator descriptors() {
        return new CompositeIterator((Iterator)new TransformationIterator(this.descriptorPackageNodes()){

            protected Object transform(Object next) {
                return ((DescriptorPackageNode)next).descriptors();
            }
        });
    }

    public void addDescriptorsTo(Collection descriptors) {
        CollectionTools.addAll((Collection)descriptors, (Iterator)this.descriptors());
    }

    public boolean isAutoMappable() {
        return true;
    }

    protected void engageValue() {
        super.engageValue();
        this.getProject().addCollectionChangeListener("descriptors", this.descriptorsListener);
        this.addDescriptorNodesFor(this.getProject().descriptors());
        this.metaDataRepositoryNodeHolder.setValue(this.buildMetaDataRepositoryNode());
    }

    protected abstract Child buildMetaDataRepositoryNode();

    protected void disengageValue() {
        this.metaDataRepositoryNodeHolder.setValue(null);
        this.removeDescriptorNodesFor(this.getProject().descriptors());
        this.getProject().removeCollectionChangeListener("descriptors", this.descriptorsListener);
        super.disengageValue();
    }

    protected String[] iconPropertyNames() {
        return PROJECT_ICON_PROPERTY_NAMES;
    }

    protected IconBuilder buildIconBuilder() {
        IconBuilder ib = super.buildIconBuilder();
        return this.getApplicationContext().getApplication().isDevelopmentMode() ? this.buildDevelopmentModeIconBuilder(ib) : ib;
    }

    private IconBuilder buildDevelopmentModeIconBuilder(IconBuilder ib) {
        return new CompositeIconBuilder(ib, this.getProject().isValidating(), VALIDATING_ICON, -17, 0, 1, null);
    }

    protected String[] displayStringPropertyNames() {
        return PROJECT_DISPLAY_STRING_PROPERTY_NAMES;
    }

    public GroupContainerDescription buildMenuDescription(WorkbenchContext context) {
        RootMenuDescription desc = new RootMenuDescription();
        context = this.buildLocalWorkbenchContext(context);
        this.addToMenuDescription(desc, context);
        return desc;
    }

    protected abstract void addToMenuDescription(GroupContainerDescription var1, WorkbenchContext var2);

    protected MenuGroupDescription buildClassActionGroup(WorkbenchContext context) {
        MenuGroupDescription classActionGroup = new MenuGroupDescription();
        classActionGroup.add(this.getRefreshClassesAction(context));
        classActionGroup.add(this.getAddOrRefreshClassesAction(context));
        classActionGroup.add(this.getCreateNewClassAction(context));
        classActionGroup.add(this.getManageNonDescriptorClassesAction(context));
        return classActionGroup;
    }

    protected MenuGroupDescription buildCloseDeleteActionGroup(WorkbenchContext context) {
        MenuGroupDescription closeDeleteActionGroup = new MenuGroupDescription();
        closeDeleteActionGroup.add(this.getCloseAction(context));
        closeDeleteActionGroup.add(this.getDeleteProjectAction(context));
        return closeDeleteActionGroup;
    }

    protected MenuGroupDescription buildSaveActionGroup(WorkbenchContext context) {
        MenuGroupDescription saveGroup = new MenuGroupDescription();
        saveGroup.add(this.getSaveAction(context));
        saveGroup.add(this.getSaveAsAction(context));
        return saveGroup;
    }

    protected MenuGroupDescription buildExportActionGroup(WorkbenchContext context) {
        MenuGroupDescription exportGroup = new MenuGroupDescription();
        exportGroup.add(this.buildExportMenuDescription(context));
        return exportGroup;
    }

    protected abstract GroupContainerDescription buildExportMenuDescription(WorkbenchContext var1);

    public ListValueModel getChildrenModel() {
        return this.childrenModel;
    }

    public String helpTopicID() {
        return "project";
    }

    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        return new ToolBarDescription();
    }

    protected final FrameworkAction getDeleteProjectAction(WorkbenchContext context) {
        return new DeleteProjectAction(context);
    }

    protected ExportDeploymentXmlAction getExportDeploymentXmlAction(WorkbenchContext context) {
        return this.getMappingsPlugin().getExportDeploymentXmlAction(context);
    }

    protected ExportDeploymentXmlAndInitializeRuntimeDescriptorsAction getExportDeploymentXmlAndInitializeRuntimeDescriptorsAction(WorkbenchContext context) {
        return this.getMappingsPlugin().getExportDeploymentXmlAndInitializeRuntimeDescriptorsAction(context);
    }

    protected RefreshClassesAction getRefreshClassesAction(WorkbenchContext context) {
        return this.getMappingsPlugin().getRefreshClassesAction(context);
    }

    protected AddOrRefreshClassesAction getAddOrRefreshClassesAction(WorkbenchContext context) {
        return this.getMappingsPlugin().getAddOrRefreshClassesAction(context);
    }

    protected CreateNewClassAction getCreateNewClassAction(WorkbenchContext context) {
        return this.getMappingsPlugin().getCreateNewClassAction(context);
    }

    protected ManageNonDescriptorClassesAction getManageNonDescriptorClassesAction(WorkbenchContext context) {
        return this.getMappingsPlugin().getManageNonDescriptorClassesAction(context);
    }

    protected ExportModelJavaSourceAction getModelJavaSourceAction(WorkbenchContext context) {
        return this.getMappingsPlugin().getExportModelJavaSourceAction(context);
    }

    protected FrameworkAction getSaveAction(WorkbenchContext workbenchContext) {
        return workbenchContext.getActionRepository().getSaveAction();
    }

    protected FrameworkAction getSaveAsAction(WorkbenchContext workbenchContext) {
        return workbenchContext.getActionRepository().getSaveAsAction();
    }

    protected FrameworkAction getCloseAction(WorkbenchContext workbenchContext) {
        return workbenchContext.getActionRepository().getCloseAction();
    }

    public File saveFile() {
        return this.getProject().saveFile();
    }

    public boolean save(File mostRecentSaveDirectory, WorkbenchContext workbenchContext) {
        boolean persistLastRefresh = this.preferences().getBoolean("last refresh", true);
        this.getProject().getClassRepository().setPersistLastRefresh(persistLastRefresh);
        File saveFile = this.saveFile();
        if (saveFile == null) {
            if (this.getProject().isLegacyProject()) {
                JOptionPane.showMessageDialog(workbenchContext.getCurrentWindow(), this.resourceRepository().getString("PROJECT_SAVED_IN_NEW_FILE_FORMAT_DIALOG"));
            }
            return this.saveAs(mostRecentSaveDirectory, workbenchContext);
        }
        workbenchContext = this.buildLocalWorkbenchContext(workbenchContext);
        return this.saveInternal(saveFile, workbenchContext);
    }

    private boolean promptToWriteEjbJarXml(WorkbenchContext workbenchContext) {
        if (this.preferences().get(WRITE_EJB_JAR_XML_ON_SAVE_PREFERENCE, "Prompt").equals(WRITE_EJB_JAR_XML_ON_SAVE_PREFERENCE_ALWAYS)) {
            return true;
        }
        if (this.preferences().get(WRITE_EJB_JAR_XML_ON_SAVE_PREFERENCE, "Prompt").equals(WRITE_EJB_JAR_XML_ON_SAVE_PREFERENCE_NEVER)) {
            return false;
        }
        int option = JOptionPane.showConfirmDialog(workbenchContext.getCurrentWindow(), this.resourceRepository().getString("WRITE_PROJECT_EJB_JAR_ON_SAVE_DIALOG"), this.resourceRepository().getString("WRITE_PROJECT_EJB_JAR_ON_SAVE_DIALOG.title"), 0);
        return option == 0;
    }

    public boolean saveAs(File mostRecentSaveDirectory, WorkbenchContext workbenchContext) {
        File saveFile = this.saveFile();
        File directory = this.getProject().getSaveDirectory();
        if (directory == null) {
            directory = mostRecentSaveDirectory;
            saveFile = new File(mostRecentSaveDirectory, this.getProject().getName() + ".mwp");
        }
        workbenchContext = this.buildLocalWorkbenchContext(workbenchContext);
        LocalFileChooser chooser = new LocalFileChooser(workbenchContext);
        chooser.setDialogTitle(this.resourceRepository().getString("SAVE_AS_DIALOG_TITLE"));
        chooser.setCurrentDirectory(directory);
        chooser.setSelectedFile(saveFile);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(this.buildSaveAsDialogFileFilter(workbenchContext));
        int result = chooser.showSaveDialog(workbenchContext.getCurrentWindow());
        if (result != 0) {
            return false;
        }
        saveFile = chooser.getSelectedFile();
        File saveDir = saveFile.getParentFile();
        this.getProject().setSaveDirectory(saveDir);
        String projectName = saveFile.getName();
        if (projectName.toLowerCase().endsWith(".mwp")) {
            projectName = FileTools.stripExtension((String)projectName);
        }
        this.getProject().setName(projectName);
        workbenchContext.getNavigatorSelectionModel().pushExpansionState();
        boolean saved = this.saveInternal(saveFile, workbenchContext);
        workbenchContext.getNavigatorSelectionModel().popAndRestoreExpansionState();
        return saved;
    }

    private FileFilter buildSaveAsDialogFileFilter(final WorkbenchContext workbenchContext) {
        return new FileFilter(){

            public String getDescription() {
                return workbenchContext.getApplicationContext().getResourceRepository().getString("SAVE_AS_DIALOG_MWP_FILE_FILTER");
            }

            public boolean accept(File file) {
                return file.isDirectory() || ".mwp".equals(FileTools.extension((File)file));
            }
        };
    }

    private boolean saveInternal(File saveFile, WorkbenchContext workbenchContext) {
        boolean saved;
        block3: {
            saved = false;
            ProjectIOManager ioMgr = this.getMappingsPlugin().getIOManager();
            try {
                ioMgr.write(this.getProject());
                saved = true;
            }
            catch (ReadOnlyFilesException exception) {
                ReadOnlyFileDialog dialog = new ReadOnlyFileDialog(workbenchContext, CollectionTools.collection((Object[])exception.getFiles()));
                dialog.show();
                if (dialog.saveAsWasPressed()) {
                    return this.saveAs(null, workbenchContext);
                }
                if (!dialog.saveWasPressed()) break block3;
                return this.saveInternal(saveFile, workbenchContext);
            }
        }
        return saved;
    }

    public String getAutomapSuccessfulStringKey() {
        return "AUTOMAP_PROJECT_SUCCESSFUL";
    }

    public boolean canAutomapDescriptors() {
        return this.getProject().canAutomapDescriptors();
    }

    public abstract String getCannotAutomapDescriptorsStringKey();

    public MWProject getProject() {
        return (MWProject)this.getValue();
    }

    private Iterator descriptorPackageNodes() {
        return (Iterator)this.descriptorPackageNodesHolder.getValue();
    }

    private DescriptorPackageNode descriptorPackageNodeFor(MWDescriptor descriptor) {
        return this.descriptorPackageNodeNamed(descriptor.packageName());
    }

    public DescriptorPackageNode descriptorPackageNodeNamed(String name) {
        Iterator stream = this.descriptorPackageNodes();
        while (stream.hasNext()) {
            DescriptorPackageNode descriptorPackageNode = (DescriptorPackageNode)stream.next();
            if (!descriptorPackageNode.getName().equals(name)) continue;
            return descriptorPackageNode;
        }
        return null;
    }

    public DescriptorNode descriptorNodeFor(MWDescriptor descriptor) {
        return this.descriptorPackageNodeNamed(descriptor.packageName()).descriptorNodeFor(descriptor);
    }

    public abstract boolean supportsExportProjectJavaSource();

    public abstract boolean supportsExportTableCreatorJavaSource();

    protected DescriptorPackageNode.DescriptorNodeBuilder getDescriptorNodeBuilder() {
        return this.descriptorNodeBuilder;
    }

    public void selectDescriptorNodeFor(MWDescriptor descriptor, NavigatorSelectionModel navigatorSelectionModel) {
        this.selectDescriptorNode(this.descriptorNodeFor(descriptor), navigatorSelectionModel);
    }

    public void selectDescriptorNode(DescriptorNode descriptorNode, NavigatorSelectionModel navigatorSelectionModel) {
        navigatorSelectionModel.setSelectedNode(descriptorNode);
    }

    public void selectMappingNodeFor(MWMapping mapping, NavigatorSelectionModel nsm) {
        MappingDescriptorNode descriptorNode = (MappingDescriptorNode)this.descriptorNodeFor((MWDescriptor)mapping.getParentDescriptor());
        descriptorNode.selectMappingNodeFor(mapping, nsm);
    }

    public void selectMappingNodeFor(MWClassAttribute attribute, NavigatorSelectionModel nsm) {
        MappingDescriptorNode descriptorNode = (MappingDescriptorNode)this.descriptorNodeFor(this.getProject().descriptorForType((MWClass)attribute.getParent()));
        descriptorNode.selectMappingNodeFor(attribute, nsm);
    }

    public void selectMethod(MWMethod method, WorkbenchContext context) {
        MWDescriptor descriptor = this.getProject().descriptorForType((MWClass)method.getParent());
        if (descriptor != null) {
            MappingDescriptorNode descriptorNode = (MappingDescriptorNode)this.descriptorNodeFor(descriptor);
            this.selectDescriptorNode(descriptorNode, context.getNavigatorSelectionModel());
            descriptorNode.selectMethod(method, context);
        }
    }

    public void setPromptsForEjbJarXmlWrite(boolean b) {
        this.promptsForEjbJarXmlWrite = b;
    }

    protected abstract DescriptorPackageNode buildDescriptorPackageNodeFor(MWDescriptor var1);

    void addDescriptorNodesFor(Iterator descriptors) {
        while (descriptors.hasNext()) {
            this.addDescriptorNodeFor((MWDescriptor)descriptors.next());
        }
    }

    private void addDescriptorNodeFor(MWDescriptor descriptor) {
        descriptor.addPropertyChangeListener("name", this.descriptorNameListener);
        this.addDescriptorNodeTo(descriptor, this.descriptorPackageNodeFor(descriptor));
    }

    private void addDescriptorNodeTo(MWDescriptor descriptor, DescriptorPackageNode dpn) {
        if (dpn == null) {
            dpn = this.buildDescriptorPackageNodeFor(descriptor);
            this.descriptorPackageNodesHolder.addItem(dpn);
        }
        dpn.addDescriptorNodeFor(descriptor);
    }

    void removeDescriptorNodesFor(Iterator descriptors) {
        while (descriptors.hasNext()) {
            this.removeDescriptorNodeFor((MWDescriptor)descriptors.next());
        }
    }

    private void removeDescriptorNodeFor(MWDescriptor descriptor) {
        this.removeDescriptorNodeFrom(descriptor, this.descriptorPackageNodeFor(descriptor));
        descriptor.removePropertyChangeListener("name", this.descriptorNameListener);
    }

    private void removeDescriptorNodeFrom(MWDescriptor descriptor, DescriptorPackageNode dpn) {
        dpn.removeDescriptorNodeFor(descriptor);
        if (dpn.descriptorNodesSize() == 0) {
            this.descriptorPackageNodesHolder.removeItem(dpn);
        }
    }

    void rebuildDescriptorNodes() {
        List descriptors = CollectionTools.list((Iterator)this.descriptors());
        this.removeDescriptorNodesFor(descriptors.iterator());
        this.addDescriptorNodesFor(this.getProject().descriptors());
    }

    void descriptorChangedPackage(MWDescriptor descriptor, String oldPackageName, String newPackageName) {
        this.removeDescriptorNodeFrom(descriptor, this.descriptorPackageNodeNamed(oldPackageName));
        this.addDescriptorNodeTo(descriptor, this.descriptorPackageNodeNamed(newPackageName));
    }

    private class LocalFileChooser
    extends JFileChooser {
        private WorkbenchContext workbenchContext;

        private LocalFileChooser(WorkbenchContext workbenchContext) {
            this.workbenchContext = workbenchContext;
        }

        public void approveSelection() {
            int result = this.canReplaceExistingFile();
            if (result == 0) {
                super.approveSelection();
            } else if (result == 2) {
                this.cancelSelection();
            }
        }

        private ResourceRepository resourceRepository() {
            return this.workbenchContext.getApplicationContext().getResourceRepository();
        }

        private int canReplaceExistingFile() {
            File file = this.getSelectedFile();
            String applicationName = this.workbenchContext.getApplicationContext().getApplication().getShortProductName();
            if (this.isDocumentOpened(file)) {
                String message = this.resourceRepository().getString("SAVE_AS_DIALOG_ALREADY_OPENED", applicationName, file, StringTools.CR);
                LabelArea label = new LabelArea(message);
                label.setPreferredWidth(800);
                JOptionPane.showMessageDialog(this.workbenchContext.getCurrentWindow(), label, applicationName, 2);
                return 1;
            }
            if (file.exists() && !file.canWrite()) {
                String message = this.resourceRepository().getString("SAVE_AS_DIALOG_CANT_SAVE", file, StringTools.CR);
                LabelArea label = new LabelArea(message);
                label.setPreferredWidth(800);
                JOptionPane.showMessageDialog(this.workbenchContext.getCurrentWindow(), label, applicationName, 2);
                return 1;
            }
            if (ProjectNode.this.saveFile() != null && file.exists() && ProjectNode.this.saveFile().equals(file)) {
                String message = this.resourceRepository().getString("SAVE_AS_DIALOG_REPLACE", this.getSelectedFile().getPath());
                LabelArea label = new LabelArea(message);
                label.setPreferredWidth(800);
                return JOptionPane.showConfirmDialog(this.workbenchContext.getCurrentWindow(), label, applicationName, 1);
            }
            if (!this.isValidSaveDirectory(file.getParentFile())) {
                String message = this.resourceRepository().getString("NEED_EMPTY_DIRECTORY_TO_SAVE_DIALOG.message");
                LabelArea label = new LabelArea(message);
                label.setPreferredWidth(800);
                JOptionPane.showMessageDialog(this.workbenchContext.getCurrentWindow(), label, this.resourceRepository().getString("NEED_EMPTY_DIRECTORY_TO_SAVE_DIALOG.title"), 0);
                return 1;
            }
            return 0;
        }

        private boolean isValidSaveDirectory(File saveDirectory) {
            File[] files = saveDirectory.listFiles();
            if (files == null || files.length == 0) {
                return true;
            }
            int i = files.length;
            while (i-- > 0) {
                File file = files[i];
                if (file.isDirectory() || !file.getName().endsWith(".mwp")) continue;
                return false;
            }
            return true;
        }

        private boolean isDocumentOpened(File file) {
            ApplicationNode[] appNodes = ProjectNode.this.nodeManager().projectNodesFor(ProjectNode.this.getPlugin());
            for (int i = 0; i < appNodes.length; ++i) {
                File anotherOpenedFile;
                ProjectNode node = (ProjectNode)appNodes[i];
                if (node == ProjectNode.this || (anotherOpenedFile = node.saveFile()) == null || !file.equals(anotherOpenedFile)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface Child
    extends Comparable {
        public static final Comparator COMPARATOR = new Comparator(){

            public int compare(Object o1, Object o2) {
                int priority2;
                int priority1 = ((Child)o1).getProjectNodeChildPriority();
                if (priority1 == (priority2 = ((Child)o2).getProjectNodeChildPriority())) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return priority1 - priority2;
            }

            public String toString() {
                return "ProjectNode.Child.COMPARATOR";
            }
        };

        public int getProjectNodeChildPriority();
    }
}

