/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWObjectTypeConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.TypeDeclarationCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

final class ObjectTypeConverterPanel
extends AbstractSubjectPanel {
    ObjectTypeConverterPanel(PropertyValueModel objectTypeConverterHolder, WorkbenchContextHolder contextHolder) {
        super((ValueModel)objectTypeConverterHolder, contextHolder);
    }

    MWObjectTypeConverter getObjectTypeConverter() {
        return (MWObjectTypeConverter)this.subject();
    }

    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        JComponent dataTypeWidget = this.buildLabeledComponent("DATA_TYPE_LABEL", this.buildDataTypeChooser());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)dataTypeWidget, constraints);
        JComponent attributeTypeWidget = this.buildLabeledComponent("ATTRIBUTE_TYPE_LABEL", this.buildAttributeTypeChooser());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)attributeTypeWidget, constraints);
        JLabel conversionValuesLabel = this.buildConversionValuesLabel();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)conversionValuesLabel, constraints);
        this.addAlignLeft(conversionValuesLabel);
        AbstractPanel valuePairsPanel = this.buildConversionValuesPanel();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)valuePairsPanel, constraints);
        this.addPaneForAlignment(valuePairsPanel);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private ListChooser buildDataTypeChooser() {
        DefaultListChooser chooser = new DefaultListChooser(this.buildDataTypeComboBoxModel(), this.getWorkbenchContextHolder(), this.buildDataTypeChooserDialogBuilder());
        chooser.setRenderer(this.buildMWClassListCellRenderer());
        return chooser;
    }

    private DefaultListChooserDialog.Builder buildDataTypeChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("DATA_TYPE_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("DATA_TYPE_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMWClassStringConverter());
        return builder;
    }

    private ComboBoxModel buildDataTypeComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildTypesCollectionModel(), this.buildDataTypeHolder());
    }

    private PropertyValueModel buildDataTypeHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "dataType"){

            protected Object getValueFromSubject() {
                return ((MWObjectTypeConverter)this.subject).getDataType();
            }

            protected void setValueOnSubject(Object value) {
                ((MWObjectTypeConverter)this.subject).setDataType((MWTypeDeclaration)value);
            }
        };
    }

    private CollectionValueModel buildTypesCollectionModel() {
        return new CollectionAspectAdapter(this.getSubjectHolder()){

            protected Iterator getValueFromSubject() {
                return ((MWConverter)this.subject).buildBasicTypes().iterator();
            }
        };
    }

    private StringConverter buildMWClassStringConverter() {
        return new StringConverter(){

            public String convertToString(Object o) {
                return o == null ? "" : ((MWTypeDeclaration)o).displayStringWithPackage();
            }
        };
    }

    private ListCellRenderer buildMWClassListCellRenderer() {
        return new AdaptableListCellRenderer(new TypeDeclarationCellRendererAdapter(this.resourceRepository()));
    }

    private ListChooser buildAttributeTypeChooser() {
        DefaultListChooser chooser = new DefaultListChooser(this.buildAttributeTypeComboBoxModel(), this.getWorkbenchContextHolder(), this.buildAttributeTypeChooserDialogBuilder());
        chooser.setRenderer(this.buildMWClassListCellRenderer());
        return chooser;
    }

    private DefaultListChooserDialog.Builder buildAttributeTypeChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("ATTRIBUTE_TYPE_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("ATTRIBUTE_TYPE_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMWClassStringConverter());
        return builder;
    }

    private ComboBoxModel buildAttributeTypeComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildTypesCollectionModel(), this.buildAttributeTypeHolder());
    }

    private PropertyValueModel buildAttributeTypeHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "attributeType"){

            protected Object getValueFromSubject() {
                return ((MWObjectTypeConverter)this.subject).getAttributeType();
            }

            protected void setValueOnSubject(Object value) {
                ((MWObjectTypeConverter)this.subject).setAttributeType((MWTypeDeclaration)value);
            }
        };
    }

    private JLabel buildConversionValuesLabel() {
        JLabel label = this.buildLabel("CONVERSION_VALUES_TABLE_LABEL");
        return label;
    }

    private AbstractPanel buildConversionValuesPanel() {
        return new ConversionValuesPanel(this.getSubjectHolder(), this.getWorkbenchContextHolder());
    }

    protected String helpTopicId() {
        return "mapping.converter.objectType";
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            this.getComponent(i).setEnabled(enabled);
        }
    }

    private static class ValuePairsColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 3;
        public static final int DATA_VALUE_COLUMN = 0;
        public static final int ATTRIBUTE_VALUE_COLUMN = 1;
        public static final int DEFAULT_ATTRIBUTE_VALUE_COLUMN = 2;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"DATA_VALUE_HEADER", "ATTRIBUTE_VALUE_HEADER", "DEFAULT_ATTRIBUTE_VALUE_HEADER"};

        protected ValuePairsColumnAdapter(ResourceRepository repository) {
            this.resourceRepository = repository;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int index) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[index]);
        }

        public Class getColumnClass(int index) {
            switch (index) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        public boolean isColumnEditable(int index) {
            return index == 2;
        }

        public PropertyValueModel[] cellModels(Object subject) {
            MWObjectTypeConverter.ValuePair valuePair = (MWObjectTypeConverter.ValuePair)subject;
            PropertyValueModel[] result = new PropertyValueModel[]{this.buildDataValueAdapter(valuePair), this.buildAttributeValueAdapter(valuePair), this.buildDefaultAttributeValueAdapter(valuePair)};
            return result;
        }

        private PropertyValueModel buildDataValueAdapter(MWObjectTypeConverter.ValuePair valuePair) {
            return new PropertyAspectAdapter("dataValue", (Model)valuePair){

                protected Object getValueFromSubject() {
                    return ((MWObjectTypeConverter.ValuePair)this.subject).getDataValueAsString();
                }
            };
        }

        private PropertyValueModel buildAttributeValueAdapter(MWObjectTypeConverter.ValuePair valuePair) {
            return new PropertyAspectAdapter("attributeValue", (Model)valuePair){

                protected Object getValueFromSubject() {
                    return ((MWObjectTypeConverter.ValuePair)this.subject).getAttributeValueAsString();
                }
            };
        }

        private PropertyValueModel buildDefaultAttributeValueAdapter(MWObjectTypeConverter.ValuePair valuePair) {
            return new PropertyAspectAdapter("defaultAttributeValue", (Model)valuePair){

                protected Object getValueFromSubject() {
                    return ((MWObjectTypeConverter.ValuePair)this.subject).isDefaultAttributeValue();
                }

                protected void setValueOnSubject(Object value) {
                    ((MWObjectTypeConverter.ValuePair)this.subject).setDefaultAttributeValue(((Boolean)value).booleanValue());
                }
            };
        }
    }

    private static class ConversionValueDialog
    extends AbstractDialog {
        private MWObjectTypeConverter converter;
        private MWObjectTypeConverter.ValuePair valuePair;
        private int mode;
        private static final int ADD_MODE = 0;
        private static final int EDIT_MODE = 1;
        private RegexpDocument dataValueDocument;
        private RegexpDocument attributeValueDocument;
        private Component dataValueTextField;

        static void promptToAddConversionValuePair(MWObjectTypeConverter converter, WorkbenchContext context) {
            new ConversionValueDialog(converter, null, 0, context).show();
        }

        static void promptToEditConversionValuePair(MWObjectTypeConverter.ValuePair valuePair, WorkbenchContext context) {
            new ConversionValueDialog(valuePair.getObjectTypeConverter(), valuePair, 1, context).show();
        }

        private ConversionValueDialog(MWObjectTypeConverter objectTypeConverter, MWObjectTypeConverter.ValuePair valuePair, int mode, WorkbenchContext context) {
            super(context);
            this.initialize(objectTypeConverter, valuePair, mode);
        }

        private void initialize(MWObjectTypeConverter objectTypeConverter, MWObjectTypeConverter.ValuePair vp, int m) {
            this.converter = objectTypeConverter;
            this.valuePair = vp;
            this.mode = m;
            this.dataValueDocument = this.buildDataValueDocument();
            this.attributeValueDocument = this.buildAttributeValueDocument();
        }

        protected void initialize() {
            super.initialize();
            this.getOKAction().setEnabled(false);
        }

        private String addOrEditString() {
            if (this.mode == 0) {
                return "ADD";
            }
            return "EDIT";
        }

        protected Component buildMainPanel() {
            this.setTitle(this.resourceRepository().getString("CONVERSION_VALUE_DIALOG_" + this.addOrEditString() + ".title"));
            GridBagConstraints constraints = new GridBagConstraints();
            Insets margin = UIManager.getInsets("TextField.margin");
            if (margin == null) {
                margin = new Insets(1, 2, 1, 2);
            }
            JPanel messagePanel = new JPanel(new GridBagLayout());
            JLabel dataTypeLabel = new JLabel(this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.DATA_TYPE_LABEL"));
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 21;
            constraints.insets = new Insets(5, 5, 5, 5);
            messagePanel.add((Component)dataTypeLabel, constraints);
            JTextField dataTypeField = new JTextField(this.converter.getDataType().displayStringWithPackage(), 20);
            dataTypeField.setEditable(false);
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 21;
            constraints.insets = new Insets(5, 5, 5, 5);
            messagePanel.add((Component)dataTypeField, constraints);
            JLabel dataValueLabel = new JLabel(this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.DATA_VALUE_LABEL"));
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 21;
            constraints.insets = new Insets(5, 5, 5, 5);
            messagePanel.add((Component)dataValueLabel, constraints);
            this.dataValueTextField = new JTextField(this.dataValueDocument, this.valuePairDataValueString(), 20);
            dataValueLabel.setLabelFor(this.dataValueTextField);
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 21;
            constraints.insets = new Insets(5, 5, 5, 5);
            messagePanel.add(this.dataValueTextField, constraints);
            JLabel attributeTypeLabel = new JLabel(this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ATTRIBUTE_TYPE_LABEL"));
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 21;
            constraints.insets = new Insets(15, 5, 5, 5);
            messagePanel.add((Component)attributeTypeLabel, constraints);
            JTextField objectTypeField = new JTextField(this.converter.getAttributeType().displayStringWithPackage(), 20);
            objectTypeField.setEditable(false);
            constraints.gridx = 1;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 21;
            constraints.insets = new Insets(15, 5, 5, 5);
            messagePanel.add((Component)objectTypeField, constraints);
            JLabel attributeValueLabel = new JLabel(this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ATTRIBUTE_VALUE_LABEL"));
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 21;
            constraints.insets = new Insets(5, 5, 5, 5);
            messagePanel.add((Component)attributeValueLabel, constraints);
            JTextField attributeValueTextField = new JTextField(this.attributeValueDocument, this.valuePairAttributeValueString(), 20);
            attributeValueLabel.setLabelFor(attributeValueTextField);
            constraints.gridx = 1;
            constraints.gridy = 3;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 19;
            constraints.insets = new Insets(5, 5, 5, 5);
            messagePanel.add((Component)attributeValueTextField, constraints);
            constraints.gridx = 0;
            constraints.gridy = 4;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 1.0;
            constraints.fill = 0;
            constraints.anchor = 10;
            constraints.insets = new Insets(0, 0, 0, 0);
            messagePanel.add((Component)new Spacer(), constraints);
            return messagePanel;
        }

        protected Component initialFocusComponent() {
            return this.dataValueTextField;
        }

        protected String helpTopicId() {
            return "mapping.converter.objectType.conversionValueDialog";
        }

        private RegexpDocument buildDataValueDocument() {
            this.dataValueDocument = new RegexpDocument(14);
            this.dataValueDocument.addDocumentListener(new ConversionValueDocumentHandler());
            return this.dataValueDocument;
        }

        private String valuePairDataValueString() {
            return this.valuePair == null ? "" : this.valuePair.getDataValueAsString();
        }

        private RegexpDocument buildAttributeValueDocument() {
            this.attributeValueDocument = new RegexpDocument(14);
            this.attributeValueDocument.addDocumentListener(new ConversionValueDocumentHandler());
            return this.attributeValueDocument;
        }

        private String valuePairAttributeValueString() {
            return this.valuePair == null ? "" : this.valuePair.getAttributeValueAsString();
        }

        protected boolean preConfirm() {
            return this.wasAbleToCompleteValuePair();
        }

        void updateOKButton() {
            boolean enableOKButton = !this.dataValueDocumentText().equals("") && !this.attributeValueDocumentText().equals("");
            this.getOKAction().setEnabled(enableOKButton);
        }

        private String dataValueDocumentText() {
            try {
                return this.dataValueDocument.getText(0, this.dataValueDocument.getLength());
            }
            catch (BadLocationException ble) {
                return "";
            }
        }

        private String attributeValueDocumentText() {
            try {
                return this.attributeValueDocument.getText(0, this.attributeValueDocument.getLength());
            }
            catch (BadLocationException ble) {
                return "";
            }
        }

        public boolean wasAbleToCompleteValuePair() {
            block6: {
                String dataValueText = this.dataValueDocumentText();
                String attributeValueText = this.attributeValueDocumentText();
                try {
                    if (this.mode == 0) {
                        this.converter.addValuePair(dataValueText, attributeValueText);
                    } else {
                        this.converter.editValuePair(this.valuePair, dataValueText, attributeValueText);
                    }
                }
                catch (ConversionException ce) {
                    this.showInvalidConversionDialog(ce);
                    return false;
                }
                catch (MWObjectTypeConverter.ConversionValueException cve) {
                    if (cve.isRepeatedDataValue()) {
                        this.showRepeatedDataValueDialog(dataValueText);
                        return false;
                    }
                    if (!cve.isRepeatedAttributeValue()) break block6;
                    this.showRepeatedAttributeValueDialog(attributeValueText);
                    return false;
                }
            }
            return true;
        }

        private void showInvalidConversionDialog(ConversionException ce) {
            JOptionPane.showMessageDialog(this.currentWindow(), this.getInvalidInputMessage(ce.getClassToConvertTo()), this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_FORMAT_DIALOG.title"), 2);
        }

        protected String getInvalidInputMessage(Class javaClass) {
            String javaClassName = javaClass.getName();
            if (javaClass == Boolean.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_BOOLEAN_FORMAT", new Object[]{javaClassName});
            }
            if (javaClass == Character.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_CHARACTER_FORMAT", new Object[]{javaClassName});
            }
            if (javaClass == Short.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_NUMBER_FORMAT", new Object[]{javaClassName, new Short(Short.MIN_VALUE), new Short(Short.MAX_VALUE)});
            }
            if (javaClass == Byte.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_NUMBER_FORMAT", new Object[]{javaClassName, new Byte(-128), new Byte(127)});
            }
            if (javaClass == Float.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_FLOAT_NUMBER_FORMAT", new Object[]{javaClassName, new Float(Float.MIN_VALUE), new Float(Float.MAX_VALUE)});
            }
            if (javaClass == Double.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_FLOAT_NUMBER_FORMAT", new Object[]{javaClassName, new Double(Double.MIN_VALUE), new Double(Double.MAX_VALUE)});
            }
            if (javaClass == Integer.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_NUMBER_FORMAT", new Object[]{javaClassName, new Integer(Integer.MIN_VALUE), new Integer(Integer.MAX_VALUE)});
            }
            if (javaClass == Long.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_NUMBER_FORMAT", new Object[]{javaClassName, new Long(Long.MIN_VALUE), new Long(Long.MAX_VALUE)});
            }
            if (javaClass == String.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_STRING_FORMAT", new Object[]{javaClassName});
            }
            if (javaClass == Number.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_NUMBER_CLASS_FORMAT", new Object[]{javaClassName});
            }
            if (javaClass == BigDecimal.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_BIGDECIMAL_FORMAT", new Object[]{javaClassName});
            }
            if (javaClass == BigInteger.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_BIGINTEGER_FORMAT", new Object[]{javaClassName});
            }
            if (javaClass == Date.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_SQLDATE_FORMAT", new Object[]{javaClassName});
            }
            if (javaClass == Time.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_SQLTIME_FORMAT", new Object[]{javaClassName});
            }
            if (javaClass == Timestamp.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_SQLTIMESTAMP_FORMAT", new Object[]{javaClassName});
            }
            if (javaClass == java.util.Date.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_UTILDATE_FORMAT", new Object[]{javaClassName});
            }
            if (javaClass == Calendar.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_UTILCALENDAR_FORMAT", new Object[]{javaClassName});
            }
            if (javaClass == byte[].class || javaClass == Byte[].class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_BYTEARRAY_FORMAT", new Object[]{javaClassName});
            }
            if (javaClass == char[].class || javaClass == Character[].class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_CHARARRAY_FORMAT", new Object[]{javaClassName});
            }
            return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_GENERIC_FORMAT");
        }

        private void showRepeatedDataValueDialog(String valueString) {
            JOptionPane.showMessageDialog(this.currentWindow(), this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.REPEATED_DATA_VALUE_DIALOG.message", valueString), this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.REPEATED_DATA_VALUE_DIALOG.title"), 2);
        }

        private void showRepeatedAttributeValueDialog(String valueString) {
            JOptionPane.showMessageDialog(this.currentWindow(), this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.REPEATED_OBJECT_VALUE_DIALOG.message", valueString), this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.REPEATED_OBJECT_VALUE_DIALOG.title"), 2);
        }

        private class ConversionValueDocumentHandler
        implements DocumentListener {
            private ConversionValueDocumentHandler() {
            }

            public void changedUpdate(DocumentEvent de) {
                ConversionValueDialog.this.updateOKButton();
            }

            public void insertUpdate(DocumentEvent de) {
                ConversionValueDialog.this.updateOKButton();
            }

            public void removeUpdate(DocumentEvent de) {
                ConversionValueDialog.this.updateOKButton();
            }
        }
    }

    private class ConversionValuesPanel
    extends AbstractSubjectPanel {
        ObjectListSelectionModel valuePairsTableSelectionModel;
        private Action removeAction;
        private Action editAction;

        private ConversionValuesPanel(ValueModel objectTypeConverterHolder, WorkbenchContextHolder contextHolder) {
            super(objectTypeConverterHolder, contextHolder);
        }

        protected void initializeLayout() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            JButton addButton = this.buildAddConversionValueButton();
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 10;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)addButton, constraints);
            this.addAlignRight(addButton);
            JButton editButton = this.buildEditConversionValueButton();
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 10;
            constraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)editButton, constraints);
            this.addAlignRight(editButton);
            JButton removeButton = this.buildRemoveConversionValueButton();
            constraints.gridx = 1;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 19;
            constraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)removeButton, constraints);
            this.addAlignRight(removeButton);
            JTable valuePairsTable = this.buildValuePairsTable();
            JScrollPane scrollPane = new JScrollPane(valuePairsTable);
            scrollPane.setPreferredSize(new Dimension(10, 10));
            scrollPane.getViewport().setBackground(valuePairsTable.getBackground());
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 3;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            constraints.anchor = 10;
            constraints.insets = new Insets(0, 0, 0, 5);
            this.add((Component)scrollPane, constraints);
        }

        private JButton buildAddConversionValueButton() {
            Action addAction = this.buildAddConversionValueAction();
            this.addPropertyChangeListener("enabled", this.buildAddButtonEnabler(addAction));
            return new JButton(addAction);
        }

        private Action buildAddConversionValueAction() {
            return new AbstractAction(this.resourceRepository().getString("ADD_VALUE_PAIRS_BUTTON")){

                public void actionPerformed(ActionEvent e) {
                    ConversionValueDialog.promptToAddConversionValuePair(ObjectTypeConverterPanel.this.getObjectTypeConverter(), ObjectTypeConverterPanel.this.getWorkbenchContext());
                }
            };
        }

        private PropertyChangeListener buildAddButtonEnabler(final Action action) {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    action.setEnabled((Boolean)evt.getNewValue());
                }
            };
        }

        private JButton buildEditConversionValueButton() {
            this.editAction = this.buildEditConversionValueAction();
            this.editAction.setEnabled(false);
            return new JButton(this.editAction);
        }

        private Action buildEditConversionValueAction() {
            return new AbstractAction(this.resourceRepository().getString("EDIT_VALUE_PAIRS_BUTTON")){

                public void actionPerformed(ActionEvent e) {
                    MWObjectTypeConverter.ValuePair selectedValuePair = (MWObjectTypeConverter.ValuePair)ConversionValuesPanel.this.valuePairsTableSelectionModel.getMinSelectedValue();
                    ConversionValueDialog.promptToEditConversionValuePair(selectedValuePair, ObjectTypeConverterPanel.this.getWorkbenchContext());
                }
            };
        }

        private JButton buildRemoveConversionValueButton() {
            this.removeAction = this.buildRemoveConversionValueAction();
            this.removeAction.setEnabled(false);
            return new JButton(this.removeAction);
        }

        private Action buildRemoveConversionValueAction() {
            return new AbstractAction(this.resourceRepository().getString("REMOVE_VALUE_PAIRS_BUTTON")){

                public void actionPerformed(ActionEvent e) {
                    Iterator stream = CollectionTools.iterator((Object[])ConversionValuesPanel.this.valuePairsTableSelectionModel.getSelectedValues());
                    while (stream.hasNext()) {
                        MWObjectTypeConverter.ValuePair selectedValuePair = (MWObjectTypeConverter.ValuePair)stream.next();
                        ObjectTypeConverterPanel.this.getObjectTypeConverter().removeValuePair(selectedValuePair);
                    }
                }
            };
        }

        private JTable buildValuePairsTable() {
            CollectionValueModel valuePairsHolder = this.buildValuePairsHolder();
            JTable table = SwingComponentFactory.buildTable(this.buildValuePairsTableModel(valuePairsHolder), this.buildValuePairsSelectionModel(valuePairsHolder));
            this.addPropertyChangeListener("enabled", this.buildTableEnabler(table));
            return table;
        }

        private TableModel buildValuePairsTableModel(CollectionValueModel valuePairsHolder) {
            return new TableModelAdapter(valuePairsHolder, this.buildValuePairsColumnModelAdapter());
        }

        private CollectionValueModel buildValuePairsHolder() {
            return new CollectionAspectAdapter(this.getSubjectHolder(), "valuePairs"){

                protected Iterator getValueFromSubject() {
                    return ((MWObjectTypeConverter)this.subject).valuePairs();
                }

                protected int sizeFromSubject() {
                    return ((MWObjectTypeConverter)this.subject).valuePairsSize();
                }
            };
        }

        private ColumnAdapter buildValuePairsColumnModelAdapter() {
            return new ValuePairsColumnAdapter(this.resourceRepository());
        }

        private ListSelectionModel buildValuePairsSelectionModel(CollectionValueModel valuePairsHolder) {
            this.valuePairsTableSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(valuePairsHolder));
            this.valuePairsTableSelectionModel.addListSelectionListener(this.buildValuePairsListSelectionListener(this.valuePairsTableSelectionModel));
            return this.valuePairsTableSelectionModel;
        }

        private ListSelectionListener buildValuePairsListSelectionListener(final ListSelectionModel selectionModel) {
            return new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        ConversionValuesPanel.this.updateValuePairsActions(selectionModel);
                    }
                }
            };
        }

        void updateValuePairsActions(ListSelectionModel selectionModel) {
            this.removeAction.setEnabled(!selectionModel.isSelectionEmpty());
            this.editAction.setEnabled(!selectionModel.isSelectionEmpty() && selectionModel.getMinSelectionIndex() == selectionModel.getMaxSelectionIndex());
        }

        private PropertyChangeListener buildTableEnabler(final JTable table) {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    table.setEnabled((Boolean)evt.getNewValue());
                }
            };
        }
    }
}

