/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ClassCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.ClassModifiersPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class ClassPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel mwClassHolder;

    ClassPropertiesPage(PropertyValueModel descriptorNodeHolder, WorkbenchContextHolder contextHolder) {
        super(descriptorNodeHolder, contextHolder);
    }

    protected void initialize(PropertyValueModel descriptorNodeHolder) {
        super.initialize(descriptorNodeHolder);
        this.mwClassHolder = this.buildMWClassHolder();
    }

    private PropertyValueModel buildMWClassHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWDescriptor)this.subject).getMWClass();
            }
        };
    }

    protected Component buildPage() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        JComponent classNameWidgets = this.buildLabeledComponent("CLASS_NAME_LABEL", this.buildClassNameTextField());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        panel.add((Component)classNameWidgets, constraints);
        this.addHelpTopicId(classNameWidgets, this.helpTopicId() + ".name");
        JLabel superclassLabel = this.buildLabel("SUPER_CLASS_LABEL");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 0);
        panel.add((Component)superclassLabel, constraints);
        this.addAlignLeft(superclassLabel);
        ClassChooserPanel superClassChooserPanel = ClassChooserTools.buildPanel(this.buildSuperClassHolder(), this.buildClassRepositoryHolder(), ClassChooserTools.buildDeclarableReferenceFilter(), superclassLabel, this.getWorkbenchContextHolder());
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        panel.add((Component)superClassChooserPanel, constraints);
        this.addPaneForAlignment(superClassChooserPanel);
        this.addHelpTopicId(superClassChooserPanel, this.helpTopicId() + ".superclass");
        JPanel propertiesPanel = this.buildPropertiesPanel();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 11;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)propertiesPanel, constraints);
        this.addHelpTopicId(panel, this.helpTopicId());
        return panel;
    }

    protected JPanel buildPropertiesPanel() {
        JPanel propertiesPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        ClassModifiersPanel modifiersPanel = new ClassModifiersPanel((ValueModel)this.mwClassHolder, this.getApplicationContext());
        this.addHelpTopicId(modifiersPanel, this.helpTopicId() + ".modifiers");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 11;
        constraints.insets = new Insets(5, 5, 0, 0);
        propertiesPanel.add((Component)modifiersPanel, constraints);
        AddRemoveListPanel interfacesListPanel = this.buildInterfacesListPanel();
        this.addHelpTopicId(interfacesListPanel, this.helpTopicId() + ".interfaces");
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        propertiesPanel.add((Component)interfacesListPanel, constraints);
        return propertiesPanel;
    }

    ClassRepositoryHolder buildClassRepositoryHolder() {
        return new ClassRepositoryHolder(){

            public MWClassRepository getClassRepository() {
                return ClassPropertiesPage.this.getMWClass().getRepository();
            }
        };
    }

    WorkbenchContext workbenchContext() {
        return this.getWorkbenchContext();
    }

    private JTextField buildClassNameTextField() {
        JTextField textField = SwingComponentFactory.buildTextField(this.buildClassNameTextFieldDocument());
        textField.setEditable(false);
        return textField;
    }

    private Document buildClassNameTextFieldDocument() {
        return new DocumentAdapter(this.buildClassNameHolder(), new RegexpDocument(3));
    }

    private PropertyValueModel buildClassNameHolder() {
        return new PropertyAspectAdapter(this.mwClassHolder, "name"){

            protected Object getValueFromSubject() {
                return ((MWClass)this.subject).getName();
            }
        };
    }

    private PropertyValueModel buildSuperClassHolder() {
        return new PropertyAspectAdapter(this.mwClassHolder, "superclass"){

            protected Object getValueFromSubject() {
                return ((MWClass)this.subject).getSuperclass();
            }

            protected void setValueOnSubject(Object value) {
                ((MWClass)this.subject).setSuperclass((MWClass)value);
            }
        };
    }

    private AddRemoveListPanel buildInterfacesListPanel() {
        TitledBorder interfacesImplementedTitle = new TitledBorder(this.resourceRepository().getString("INTERFACES_IMPLEMENTED_LIST"));
        AddRemoveListPanel interfacesListPanel = new AddRemoveListPanel(this.getApplicationContext(), this.buildAddRemoveListPanelAdapter(), this.buildSortedInterfacesListModel(), 2);
        interfacesListPanel.setBorder(BorderFactory.createCompoundBorder(interfacesImplementedTitle, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        interfacesListPanel.setCellRenderer(this.buildInterfacesListCellRenderer());
        interfacesListPanel.setName(this.resourceRepository().getString("INTERFACES_LIST_NAME"));
        return interfacesListPanel;
    }

    private ListCellRenderer buildInterfacesListCellRenderer() {
        return new AdaptableListCellRenderer(new ClassCellRendererAdapter(this.resourceRepository()));
    }

    private AddRemovePanel.Adapter buildAddRemoveListPanelAdapter() {
        return new AddRemovePanel.Adapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                MWClass type = ClassChooserTools.promptForType(ClassPropertiesPage.this.getMWClass().getRepository(), ClassChooserTools.buildDeclarableReferenceFilter(), ClassPropertiesPage.this.workbenchContext());
                if (type == null) {
                    return;
                }
                ClassPropertiesPage.this.getMWClass().addInterface(type);
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                ClassPropertiesPage.this.getMWClass().removeInterfaces(CollectionTools.collection((Object[])listSelectionModel.getSelectedValues()));
            }
        };
    }

    private ListValueModel buildSortedInterfacesListModel() {
        return new SortedListValueModelAdapter(this.buildItemListValueModelAdapter());
    }

    private ItemPropertyListValueModelAdapter buildItemListValueModelAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildInterfacesCollectionValueModel(), "name");
    }

    private CollectionValueModel buildInterfacesCollectionValueModel() {
        return new CollectionAspectAdapter(this.mwClassHolder, "interfaces"){

            protected Iterator getValueFromSubject() {
                return ((MWClass)this.subject).interfaces();
            }

            protected int sizeFromSubject() {
                return ((MWClass)this.subject).interfacesSize();
            }
        };
    }

    MWClass getMWClass() {
        return (MWClass)this.mwClassHolder.getValue();
    }

    protected String helpTopicId() {
        return "descriptor.classInfo.class";
    }
}

