/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CheckBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.ComboBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.SpinnerTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.NameTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public class ColumnsPropertiesPage
extends ScrollablePropertiesPage {
    private ListValueModel databaseTypesHolder;
    private ListValueModel sortedColumnsAdapter;
    private TableModel tableModel;
    private ObjectListSelectionModel rowSelectionModel;
    private PropertyValueModel selectedColumnHolder;
    private Action removeAction;
    private Action renameAction;
    private JTable table;

    public ColumnsPropertiesPage(PropertyValueModel tableNodeHolder, WorkbenchContextHolder contextHolder) {
        super(tableNodeHolder, contextHolder);
    }

    protected void initialize(PropertyValueModel nodeHolder) {
        super.initialize(nodeHolder);
        this.databaseTypesHolder = this.buildDatabaseTypesListHolder();
        this.sortedColumnsAdapter = this.buildSortedColumnsAdapter();
        this.tableModel = this.buildTableModel();
        this.selectedColumnHolder = this.buildSelectedColumnHolder();
        this.rowSelectionModel = this.buildRowSelectionModel();
    }

    private ListValueModel buildDatabaseTypesListHolder() {
        return new CollectionListValueModelAdapter(this.buildDatabaseTypesHolder());
    }

    private CollectionValueModel buildDatabaseTypesHolder() {
        return new CollectionAspectAdapter(this.buildDatabasePlatformAdapter(), "databaseTypes"){

            protected Iterator getValueFromSubject() {
                return ((DatabasePlatform)this.subject).databaseTypes();
            }

            protected int sizeFromSubject() {
                return ((DatabasePlatform)this.subject).databaseTypesSize();
            }
        };
    }

    private PropertyValueModel buildDatabasePlatformAdapter() {
        return new PropertyAspectAdapter(this.buildDatabaseAdapter(), "databasePlatform"){

            protected Object getValueFromSubject() {
                return ((MWDatabase)this.subject).getDatabasePlatform();
            }
        };
    }

    private ValueModel buildDatabaseAdapter() {
        return new TransformationPropertyValueModel(this.getSelectionHolder()){

            protected Object transform(Object value) {
                return value == null ? null : ((MWTable)value).getDatabase();
            }

            protected Object reverseTransform(Object value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private ListValueModel buildSortedColumnsAdapter() {
        return new SortedListValueModelAdapter(this.buildColumnNameAdapter());
    }

    private ListValueModel buildColumnNameAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildColumnsAdapter(), "name");
    }

    private CollectionValueModel buildColumnsAdapter() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "columns"){

            protected Iterator getValueFromSubject() {
                return ((MWTable)this.subject).columns();
            }

            protected int sizeFromSubject() {
                return ((MWTable)this.subject).columnsSize();
            }
        };
    }

    private TableModel buildTableModel() {
        return new TableModelAdapter(this.sortedColumnsAdapter, this.buildColumnAdapter());
    }

    private ColumnAdapter buildColumnAdapter() {
        return new ColumnsColumnAdapter(this.resourceRepository());
    }

    private PropertyValueModel buildSelectedColumnHolder() {
        return new SimplePropertyValueModel(null);
    }

    private ObjectListSelectionModel buildRowSelectionModel() {
        ObjectListSelectionModel model = new ObjectListSelectionModel(new ListModelAdapter(this.sortedColumnsAdapter));
        model.addListSelectionListener(this.buildRowSelectionListener());
        return model;
    }

    private ListSelectionListener buildRowSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ColumnsPropertiesPage.this.rowSelectionChanged(e);
                }
            }
        };
    }

    void rowSelectionChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        Object selection = this.rowSelectionModel.getSelectedValue();
        this.selectedColumnHolder.setValue(selection);
        boolean fieldSelected = selection != null;
        this.removeAction.setEnabled(fieldSelected);
        this.renameAction.setEnabled(fieldSelected);
    }

    protected Component buildPage() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel buttonPanel = this.buildButtonPanel();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 0, 5, 5);
        mainPanel.add((Component)buttonPanel, constraints);
        this.table = this.buildTable();
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setPreferredSize(new Dimension(50, 50));
        scrollPane.getViewport().setBackground(this.table.getBackground());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 5, 5);
        mainPanel.add((Component)scrollPane, constraints);
        this.addHelpTopicId(mainPanel, this.helpTopicId());
        return mainPanel;
    }

    private JTable buildTable() {
        JTable t = SwingComponentFactory.buildTable(this.tableModel, this.rowSelectionModel);
        t.setAutoResizeMode(0);
        t.getTableHeader().setReorderingAllowed(false);
        SwingComponentFactory.attachTableEditorCanceler(t, this.getSelectionHolder());
        this.updateTableColumns(t);
        return t;
    }

    private void updateTableColumns(JTable t) {
        int rowHeight = 20;
        TableColumn column = t.getColumnModel().getColumn(0);
        column.setPreferredWidth(100);
        column = t.getColumnModel().getColumn(1);
        column.setPreferredWidth(100);
        ComboBoxTableCellRenderer typeRenderer = this.buildDatabaseTypeComboBoxRenderer();
        column.setCellRenderer(typeRenderer);
        column.setCellEditor(new TableCellEditorAdapter(this.buildDatabaseTypeComboBoxRenderer()));
        rowHeight = Math.max(rowHeight, typeRenderer.getPreferredHeight());
        column = t.getColumnModel().getColumn(2);
        SpinnerTableCellRenderer sizeRenderer = this.buildSizeRenderer();
        column.setCellRenderer(sizeRenderer);
        column.setCellEditor(this.buildSizeEditor());
        rowHeight = Math.max(rowHeight, sizeRenderer.getPreferredHeight());
        column = t.getColumnModel().getColumn(3);
        SpinnerTableCellRenderer subSizeRenderer = this.buildSubSizeRenderer();
        column.setCellRenderer(subSizeRenderer);
        column.setCellEditor(this.buildSubSizeEditor());
        rowHeight = Math.max(rowHeight, subSizeRenderer.getPreferredHeight());
        column = t.getColumnModel().getColumn(4);
        CheckBoxTableCellRenderer allowsNullRenderer = this.buildAllowsNullRenderer();
        column.setCellRenderer(allowsNullRenderer);
        column.setCellEditor(this.buildAllowsNullEditor());
        rowHeight = Math.max(rowHeight, allowsNullRenderer.getPreferredHeight());
        column = t.getColumnModel().getColumn(5);
        CheckBoxTableCellRenderer uniqueRenderer = new CheckBoxTableCellRenderer();
        column.setCellRenderer(uniqueRenderer);
        column.setCellEditor(new TableCellEditorAdapter(new CheckBoxTableCellRenderer()));
        rowHeight = Math.max(rowHeight, uniqueRenderer.getPreferredHeight());
        column = t.getColumnModel().getColumn(6);
        CheckBoxTableCellRenderer primaryKeyRenderer = new CheckBoxTableCellRenderer();
        column.setCellRenderer(primaryKeyRenderer);
        column.setCellEditor(new TableCellEditorAdapter(new CheckBoxTableCellRenderer()));
        rowHeight = Math.max(rowHeight, primaryKeyRenderer.getPreferredHeight());
        column = t.getColumnModel().getColumn(7);
        CheckBoxTableCellRenderer identityRenderer = this.buildIdentityRenderer();
        column.setCellRenderer(identityRenderer);
        column.setCellEditor(this.buildIdentityEditor());
        rowHeight = Math.max(rowHeight, identityRenderer.getPreferredHeight());
        t.setRowHeight(rowHeight);
    }

    private SpinnerTableCellRenderer buildNumberSpinnerRenderer() {
        return new SpinnerTableCellRenderer(new NumberSpinnerModelAdapter((PropertyValueModel)new SimplePropertyValueModel(), new Integer(0), null, new Integer(1), new Integer(0)));
    }

    private SpinnerTableCellRenderer buildSizeRenderer() {
        return new SpinnerTableCellRenderer(new NumberSpinnerModelAdapter((PropertyValueModel)new SimplePropertyValueModel(), new Integer(0), null, new Integer(1), new Integer(0))){

            public Component getTableCellRendererComponent(JTable t, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (ColumnsPropertiesPage.this.column(row).getDatabaseType().allowsSize()) {
                    return super.getTableCellRendererComponent(t, value, selected, hasFocus, row, column);
                }
                return null;
            }
        };
    }

    private TableCellEditor buildSizeEditor() {
        return new TableCellEditorAdapter(this.buildNumberSpinnerRenderer()){

            public Component getTableCellEditorComponent(JTable t, Object value, boolean selected, int row, int column) {
                if (ColumnsPropertiesPage.this.column(row).getDatabaseType().allowsSize()) {
                    return super.getTableCellEditorComponent(t, value, selected, row, column);
                }
                return null;
            }
        };
    }

    private SpinnerTableCellRenderer buildSubSizeRenderer() {
        return new SpinnerTableCellRenderer(new NumberSpinnerModelAdapter((PropertyValueModel)new SimplePropertyValueModel(), new Integer(0), null, new Integer(1), new Integer(0))){

            public Component getTableCellRendererComponent(JTable t, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (ColumnsPropertiesPage.this.column(row).getDatabaseType().allowsSubSize()) {
                    return super.getTableCellRendererComponent(t, value, selected, hasFocus, row, column);
                }
                return null;
            }
        };
    }

    private TableCellEditor buildSubSizeEditor() {
        return new TableCellEditorAdapter(this.buildNumberSpinnerRenderer()){

            public Component getTableCellEditorComponent(JTable t, Object value, boolean selected, int row, int column) {
                if (ColumnsPropertiesPage.this.column(row).getDatabaseType().allowsSubSize()) {
                    return super.getTableCellEditorComponent(t, value, selected, row, column);
                }
                return null;
            }
        };
    }

    private CheckBoxTableCellRenderer buildAllowsNullRenderer() {
        return new CheckBoxTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable t, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (ColumnsPropertiesPage.this.column(row).getDatabaseType().allowsNull()) {
                    return super.getTableCellRendererComponent(t, value, selected, hasFocus, row, column);
                }
                return null;
            }
        };
    }

    private TableCellEditor buildAllowsNullEditor() {
        return new TableCellEditorAdapter(new CheckBoxTableCellRenderer()){

            public Component getTableCellEditorComponent(JTable t, Object value, boolean selected, int row, int column) {
                if (ColumnsPropertiesPage.this.column(row).getDatabaseType().allowsNull()) {
                    return super.getTableCellEditorComponent(t, value, selected, row, column);
                }
                return null;
            }
        };
    }

    private CheckBoxTableCellRenderer buildIdentityRenderer() {
        return new CheckBoxTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable t, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (ColumnsPropertiesPage.this.column(row).supportsIdentityClause()) {
                    return super.getTableCellRendererComponent(t, value, selected, hasFocus, row, column);
                }
                return null;
            }
        };
    }

    private TableCellEditor buildIdentityEditor() {
        return new TableCellEditorAdapter(new CheckBoxTableCellRenderer()){

            public Component getTableCellEditorComponent(JTable t, Object value, boolean selected, int row, int column) {
                if (ColumnsPropertiesPage.this.column(row).supportsIdentityClause()) {
                    return super.getTableCellEditorComponent(t, value, selected, row, column);
                }
                return null;
            }
        };
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        buttonPanel.add(this.buildAddButton());
        buttonPanel.add(this.buildRemoveButton());
        buttonPanel.add(this.buildRenameButton());
        return buttonPanel;
    }

    private JButton buildAddButton() {
        return new JButton(this.buildAddAction());
    }

    private Action buildAddAction() {
        AbstractFrameworkAction action = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeText("ADD_DATABASE_FIELD_BUTTON_TEXT");
                this.initializeMnemonic("ADD_DATABASE_FIELD_BUTTON_TEXT");
            }

            public void actionPerformed(ActionEvent event) {
                ColumnsPropertiesPage.this.addColumn();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void addColumn() {
        String name;
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        if ((name = this.promptUserForColumnName()) != null) {
            this.setSelectedColumn(this.table().addColumn(name));
        }
    }

    private JButton buildRemoveButton() {
        return new JButton(this.buildRemoveAction());
    }

    private Action buildRemoveAction() {
        this.removeAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeText("REMOVE_DATABASE_FIELD_BUTTON_TEXT");
                this.initializeMnemonic("REMOVE_DATABASE_FIELD_BUTTON_TEXT");
            }

            public void actionPerformed(ActionEvent event) {
                ColumnsPropertiesPage.this.removeColumn();
            }
        };
        this.removeAction.setEnabled(false);
        return this.removeAction;
    }

    void removeColumn() {
        int option;
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        if ((option = JOptionPane.showConfirmDialog(this.currentWindow(), this.resourceRepository().getString("removeField.message"), this.resourceRepository().getString("removeField.title"), 0, 3)) == 0) {
            this.table().removeColumns(this.selectedColumns());
        }
    }

    private JButton buildRenameButton() {
        return new JButton(this.buildRenameAction());
    }

    private Action buildRenameAction() {
        this.renameAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeText("RENAME_DATABASE_FIELD_BUTTON_TEXT");
                this.initializeMnemonic("RENAME_DATABASE_FIELD_BUTTON_TEXT");
            }

            public void actionPerformed(ActionEvent event) {
                ColumnsPropertiesPage.this.renameColumn();
            }
        };
        this.renameAction.setEnabled(false);
        return this.renameAction;
    }

    void renameColumn() {
        Iterator i = this.selectedColumns();
        while (i.hasNext()) {
            MWColumn column = (MWColumn)i.next();
            String name = this.promptUserForColumnName(column.getName(), "RENAME_FIELD_DIALOG", "dialog.dbFieldRename");
            if (name == null) continue;
            column.setName(name);
            this.setSelectedColumn(column);
        }
    }

    private String promptUserForColumnName() {
        String originalName = NameTools.uniqueNameFor((String)this.resourceRepository().getString("NEW_FIELD_DEFAULT_NAME"), (Iterator)this.columnNames());
        return this.promptUserForColumnName(originalName, "ADD_NEW_FIELD_DIALOG", "dialog.dbFieldAdd");
    }

    private String promptUserForColumnName(String originalName, String messageKey, String helpTopicId) {
        NewNameDialog dialog = this.buildNewNameDialog(originalName, messageKey, helpTopicId);
        dialog.show();
        return dialog.wasConfirmed() ? dialog.getNewName() : null;
    }

    protected String helpTopicId() {
        return "table.columns";
    }

    private NewNameDialog buildNewNameDialog(String originalName, String messageKey, String helpTopicId) {
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setExistingNames(this.columnNames());
        builder.setOriginalName(originalName);
        builder.setTextFieldDescription(this.resourceRepository().getString(messageKey + ".message"));
        builder.setTitle(this.resourceRepository().getString(messageKey + ".title"));
        builder.setHelpTopicId(helpTopicId);
        return builder.buildDialog(this.getWorkbenchContext());
    }

    private Iterator columnNames() {
        return new TransformationIterator(this.table().columns()){

            protected Object transform(Object next) {
                return ((MWColumn)next).getName();
            }
        };
    }

    private ComboBoxTableCellRenderer buildDatabaseTypeComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildDatabaseTypeComboBoxModel(), this.buildDatabaseTypeListCellRenderer());
    }

    private ComboBoxModel buildDatabaseTypeComboBoxModel() {
        return new ComboBoxModelAdapter(this.databaseTypesHolder, (PropertyValueModel)new SimplePropertyValueModel());
    }

    private ListCellRenderer buildDatabaseTypeListCellRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object value) {
                return ((DatabaseType)value).getName();
            }
        };
    }

    private Iterator selectedColumns() {
        return CollectionTools.iterator((Object[])this.rowSelectionModel.getSelectedValues());
    }

    void setSelectedColumn(MWColumn field) {
        this.rowSelectionModel.setSelectedValue(field);
    }

    MWColumn column(int rowIndex) {
        return (MWColumn)this.sortedColumnsAdapter.getItem(rowIndex);
    }

    private MWTable table() {
        return (MWTable)this.getSelectionHolder().getValue();
    }

    public static class ColumnsColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 8;
        public static final int NAME_COLUMN = 0;
        public static final int TYPE_COLUMN = 1;
        public static final int SIZE_COLUMN = 2;
        public static final int SUB_SIZE_COLUMN = 3;
        public static final int ALLOWS_NULL_COLUMN = 4;
        public static final int UNIQUE_COLUMN = 5;
        public static final int PRIMARY_KEY_COLUMN = 6;
        public static final int IDENTITY_COLUMN = 7;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"NAME_COLUMN_HEADER", "TYPE_COLUMN_HEADER", "SIZE_COLUMN_HEADER", "SUB_SIZE_COLUMN_HEADER", "ALLOWS_NULL_COLUMN_HEADER", "UNIQUE_COLUMN_HEADER", "PRIMARY_KEY_COLUMN_HEADER", "IDENTITY_COLUMN_HEADER"};

        protected ColumnsColumnAdapter(ResourceRepository repository) {
            this.resourceRepository = repository;
        }

        public int getColumnCount() {
            return 8;
        }

        public String getColumnName(int index) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[index]);
        }

        public Class getColumnClass(int index) {
            switch (index) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
                case 2: {
                    return Integer.class;
                }
                case 3: {
                    return Integer.class;
                }
                case 4: {
                    return Boolean.class;
                }
                case 6: {
                    return Boolean.class;
                }
                case 5: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        public boolean isColumnEditable(int index) {
            return index != 0;
        }

        public PropertyValueModel[] cellModels(Object subject) {
            MWColumn field = (MWColumn)subject;
            PropertyValueModel[] result = new PropertyValueModel[8];
            result[0] = this.buildNameAdapter(field);
            result[1] = this.buildTypeAdapter(field);
            result[2] = this.buildSizeAdapter(field);
            result[3] = this.buildSubSizeAdapter(field);
            result[4] = this.buildAllowsNullAdapter(field);
            result[6] = this.buildPrimaryKeyAdapter(field);
            result[7] = this.buildIdentityAdapter(field);
            result[5] = this.buildUniqueAdapter(field);
            return result;
        }

        private PropertyValueModel buildNameAdapter(MWColumn field) {
            return new PropertyAspectAdapter("name", (Model)field){

                protected Object getValueFromSubject() {
                    return ((MWColumn)this.subject).getName();
                }

                protected void setValueOnSubject(Object value) {
                    ((MWColumn)this.subject).setName((String)value);
                }
            };
        }

        private PropertyValueModel buildTypeAdapter(MWColumn table) {
            return new PropertyAspectAdapter("databaseType", (Model)table){

                protected Object getValueFromSubject() {
                    return ((MWColumn)this.subject).getDatabaseType();
                }

                protected void setValueOnSubject(Object value) {
                    ((MWColumn)this.subject).setDatabaseType((DatabaseType)value);
                }
            };
        }

        private PropertyValueModel buildSizeAdapter(MWColumn field) {
            return new PropertyAspectAdapter("size", (Model)field){

                protected Object getValueFromSubject() {
                    return new Integer(((MWColumn)this.subject).getSize());
                }

                protected void setValueOnSubject(Object value) {
                    ((MWColumn)this.subject).setSize(((Integer)value).intValue());
                }
            };
        }

        private PropertyValueModel buildSubSizeAdapter(MWColumn field) {
            return new PropertyAspectAdapter("subSize", (Model)field){

                protected Object getValueFromSubject() {
                    return new Integer(((MWColumn)this.subject).getSubSize());
                }

                protected void setValueOnSubject(Object value) {
                    ((MWColumn)this.subject).setSubSize(((Integer)value).intValue());
                }
            };
        }

        private PropertyValueModel buildAllowsNullAdapter(MWColumn field) {
            return new PropertyAspectAdapter("allowsNull", (Model)field){

                protected Object getValueFromSubject() {
                    return ((MWColumn)this.subject).allowsNull();
                }

                protected void setValueOnSubject(Object value) {
                    ((MWColumn)this.subject).setAllowsNull(((Boolean)value).booleanValue());
                }
            };
        }

        private PropertyValueModel buildPrimaryKeyAdapter(MWColumn field) {
            return new PropertyAspectAdapter("primaryKey", (Model)field){

                protected Object getValueFromSubject() {
                    return ((MWColumn)this.subject).isPrimaryKey();
                }

                protected void setValueOnSubject(Object value) {
                    ((MWColumn)this.subject).setPrimaryKey(((Boolean)value).booleanValue());
                }
            };
        }

        private PropertyValueModel buildIdentityAdapter(MWColumn field) {
            return new PropertyAspectAdapter("identity", (Model)field){

                protected Object getValueFromSubject() {
                    return ((MWColumn)this.subject).isIdentity();
                }

                protected void setValueOnSubject(Object value) {
                    ((MWColumn)this.subject).setIdentity(((Boolean)value).booleanValue());
                }
            };
        }

        private PropertyValueModel buildUniqueAdapter(MWColumn field) {
            return new PropertyAspectAdapter("unique", (Model)field){

                protected Object getValueFromSubject() {
                    return ((MWColumn)this.subject).isUnique();
                }

                protected void setValueOnSubject(Object value) {
                    ((MWColumn)this.subject).setUnique(((Boolean)value).booleanValue());
                }
            };
        }
    }
}

