/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.util.Iterator;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.DatabaseNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.TableNameDialog;
import org.eclipse.persistence.tools.workbench.utility.NameTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

final class AddNewTableAction
extends AbstractFrameworkAction {
    AddNewTableAction(WorkbenchContext context) {
        super(context);
    }

    protected void initialize() {
        super.initialize();
        this.initializeIcon("table.add");
        this.initializeTextAndMnemonic("ADD_NEW_TABLE_ACTION");
        this.initializeToolTipText("ADD_NEW_TABLE_ACTION.toolTipText");
    }

    protected void execute(ApplicationNode selectedNode) {
        DatabaseNode databaseNode = (DatabaseNode)selectedNode;
        MWTable newTable = this.promptToCreateNewTableFor(databaseNode.getDatabase());
        if (newTable != null) {
            databaseNode.selectDescendantNodeForValue((Node)newTable, this.navigatorSelectionModel());
        }
    }

    private MWTable promptToCreateNewTableFor(MWDatabase database) {
        String catalog = null;
        String schema = null;
        String shortName = NameTools.uniqueNameForIgnoreCase((String)this.resourceRepository().getString("NEW_TABLE_DEFAULT_NAME"), (Iterator)database.tableNames());
        while (true) {
            TableNameDialog tableNameDialog = new TableNameDialog(this.getWorkbenchContext(), this.resourceRepository().getString("ADD_NEW_TABLE_DAILOG.title"), this.resourceRepository().getString("ADD_NEW_TABLE_DAILOG.message"), catalog, schema, shortName);
            tableNameDialog.show();
            if (tableNameDialog.wasCanceled()) {
                return null;
            }
            catalog = tableNameDialog.catalog();
            schema = tableNameDialog.schema();
            shortName = tableNameDialog.shortName();
            try {
                return database.addTable(catalog, schema, shortName);
            }
            catch (IllegalArgumentException ex) {
                int input;
                String duplicateName = NameTools.buildQualifiedDatabaseObjectName((String)catalog, (String)schema, (String)shortName);
                if ((input = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("ADD_NEW_TABLE_DUPLICATE_TABLE_NAME_MESSAGE", duplicateName), this.resourceRepository().getString("ADD_NEW_TABLE_DUPLICATE_TABLE_NAME_TITLE"), 2, 3)) != 2) continue;
                return null;
            }
            break;
        }
    }
}

