/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.text.NumberFormat;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.ExceptionDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.AbstractTableGenerationAction;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

abstract class AbstractCreateTablesOnDatabaseAction
extends AbstractTableGenerationAction {
    protected AbstractCreateTablesOnDatabaseAction(WorkbenchContext context) {
        super(context);
    }

    protected abstract Collection buildTables();

    protected void execute() {
        if (!this.confirmTableCreation()) {
            return;
        }
        try {
            this.checkDevelopmentLoginSpec("CREATE_ON_DATABASE_DIALOG.title");
        }
        catch (IllegalStateException ex) {
            return;
        }
        Collection tables = this.buildTables();
        try {
            this.database().generateTables(tables);
        }
        catch (EclipseLinkException exception) {
            if (exception instanceof DatabaseException && ((DatabaseException)((Object)exception)).getDatabaseErrorCode() == 955) {
                JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("EXCEPTION955_DURING_TABLE_GEN", StringTools.CR), this.resourceRepository().getString("EXCEPTION955_DURING_TABLE_GEN.title"), 2);
            } else if (exception instanceof DatabaseException && ((DatabaseException)((Object)exception)).getDatabaseErrorCode() == 2270) {
                JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("EXCEPTION2270_DURING_TABLE_GEN", StringTools.CR), this.resourceRepository().getString("EXCEPTION2270_DURING_TABLE_GEN.title"), 0);
            } else {
                ExceptionDialog dialog = new ExceptionDialog(this.resourceRepository().getString("EXCEPTION_DURING_TABLE_GEN"), exception, this.getWorkbenchContext(), this.resourceRepository().getString("EXCEPTION_DURING_TABLE_GEN.title"));
                dialog.show();
            }
            return;
        }
        JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("CREATE_ON_DATABASE_DONE_DIALOG.message", new Object[]{NumberFormat.getInstance().format(tables.size())}), this.resourceRepository().getString("CREATE_ON_DATABASE_DONE_DIALOG.title"), 1);
    }

    private boolean confirmTableCreation() {
        int option = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), new LabelArea(this.resourceRepository().getString("TABLES_WILL_BE_OVERWRITTEN_DIALOG.message")), this.resourceRepository().getString("TABLES_WILL_BE_OVERWRITTEN_DIALOG.title"), 0, 2);
        return option == 0;
    }

    protected boolean shouldBeEnabled(ApplicationNode selectedNode) {
        return this.database().isConnected();
    }

    protected String[] enabledPropertyNames() {
        return new String[]{"connected"};
    }
}

