/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.awt.EventQueue;
import java.awt.Frame;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.MultipleClassChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.WaitDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureListener;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.StatusDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ProjectCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorCreationFailuresDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ExternalClassDescriptionClassDesciptionAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ExternalClassDescriptionClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ExternalClassLoadFailuresDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.UiProjectBundle;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public final class AddOrRefreshClassesAction
extends AbstractFrameworkAction {
    public static final String EJB_JAR_XML_EXCEPTION_ERROR = "EJB_JAR_XML_EXCEPTION_ERROR";
    public static final String EJB_JAR_XML_PROJECT_NOT_UPDATED_ERROR = "EJB_JAR_XML_PROJECT_NOT_UPDATED_ERROR";
    public static final String INVALID_DOC_TYPE_ERROR = "INVALID_DOC_TYPE_ERROR";

    AddOrRefreshClassesAction(WorkbenchContext context) {
        super(context.buildExpandedResourceRepositoryContext(UiProjectBundle.class));
    }

    protected void initialize() {
        super.initialize();
        this.initializeIcon("descriptor.refresh");
        this.initializeTextAndMnemonic("ADD_OR_REFRESH_CLASSES_ACTION");
        this.initializeToolTipText("ADD_OR_REFRESH_CLASSES_ACTION.toolTipText");
        this.initializeAccelerator("ADD_OR_REFRESH_CLASSES_ACTION.accelerator");
    }

    protected void execute() {
        ApplicationNode[] projectNodes = this.selectedProjectNodes();
        for (int i = 0; i < projectNodes.length; ++i) {
            this.execute((ProjectNode)projectNodes[i]);
        }
    }

    protected void execute(ProjectNode projectNode) {
        MWProject project = projectNode.getProject();
        MultipleClassChooserDialog dialog = this.buildDialog(project.getRepository());
        dialog.show();
        if (dialog.wasConfirmed()) {
            this.startClassImporter(project, CollectionTools.collection((Iterator)dialog.selectedClassDescriptions()));
        }
        dialog = null;
        MultipleClassChooserDialog.gc();
    }

    private MultipleClassChooserDialog buildDialog(MWClassRepository repository) {
        return new MultipleClassChooserDialog(this.getWorkbenchContext(), new LocalClassDescriptionRepository(repository), ExternalClassDescriptionClassDesciptionAdapter.instance());
    }

    private void startClassImporter(MWProject project, Collection selectedClassDescriptions) {
        Thread thread = new Thread((Runnable)new ClassImporter(project, selectedClassDescriptions), "Class Import");
        thread.setPriority(5);
        thread.start();
    }

    private class LocalStatusDialog
    extends StatusDialog {
        private LocalStatusDialog(Collection projectStatus) {
            super(AddOrRefreshClassesAction.this.getWorkbenchContext(), projectStatus, "PROJECT_EJB_UPDATE_STATUS_DIALOG_TITLE", "PROJECT_UPDATE_STATUS_DIALOG_MESSAGE", "project.export.ejb-jar.xml");
        }

        protected Action buildOKAction() {
            Action action = super.buildOKAction();
            action.putValue("Name", this.resourceRepository().getString("EJB_JAR_XML_VALIDATOR_STATUS_DIALOG_YES_BUTTON"));
            action.putValue("MnemonicKey", new Integer(this.resourceRepository().getMnemonic("EJB_JAR_XML_VALIDATOR_STATUS_DIALOG_YES_BUTTON")));
            return action;
        }

        protected Action buildCancelAction() {
            Action action = super.buildCancelAction();
            action.putValue("Name", this.resourceRepository().getString("EJB_JAR_XML_VALIDATOR_STATUS_DIALOG_NO_BUTTON"));
            action.putValue("MnemonicKey", new Integer(this.resourceRepository().getMnemonic("EJB_JAR_XML_VALIDATOR_STATUS_DIALOG_NO_BUTTON")));
            return action;
        }

        protected boolean cancelButtonIsVisible() {
            return true;
        }

        protected CellRendererAdapter buildNodeRenderer(Object value) {
            if (value instanceof MWProject) {
                return new ProjectCellRendererAdapter(this.resourceRepository());
            }
            return super.buildNodeRenderer(value);
        }
    }

    private class ClassImporter
    implements Runnable {
        private MWProject project;
        private Collection selectedClassDescriptions;

        ClassImporter(MWProject project, Collection selectedClassDescriptions) {
            this.project = project;
            this.selectedClassDescriptions = selectedClassDescriptions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ExternalClassLoadFailureContainer classFailures;
            WaitDialog waitDialog = this.buildWaitDialog();
            AbstractFrameworkAction.launchLater(waitDialog);
            DescriptorCreationFailureContainer descriptorFailures = new DescriptorCreationFailureContainer();
            this.project.getValidator().pause();
            try {
                classFailures = this.project.addDescriptorsForExternalClassDescriptions(this.selectedClassDescriptions.iterator(), (DescriptorCreationFailureListener)descriptorFailures);
            }
            finally {
                this.project.getValidator().resume();
                waitDialog.dispose();
            }
            if (classFailures.containsFailures()) {
                AbstractFrameworkAction.launchAndWait(new ExternalClassLoadFailuresDialog(this.workbenchContext(), classFailures));
            }
            if (descriptorFailures.containsFailures()) {
                AbstractFrameworkAction.launchAndWait(new DescriptorCreationFailuresDialog(descriptorFailures, this.workbenchContext()));
            }
        }

        private WaitDialog buildWaitDialog() {
            return new WaitDialog((Frame)this.workbenchContext().getCurrentWindow(), this.resourceRepository().getIcon("class.default"), this.resourceRepository().getString("CLASS_IMPORT_WAIT_DIALOG.TITLE"), this.resourceRepository().getString("CLASS_IMPORT_WAIT_MESSAGE"));
        }

        private boolean promptUserToUpdateProjectFromEjbJarXml() {
            class Prompt
            implements Runnable {
                int option = 0;

                Prompt() {
                }

                public void run() {
                    this.option = JOptionPane.showConfirmDialog(ClassImporter.this.workbenchContext().getCurrentWindow(), ClassImporter.this.resourceRepository().getString("UPDATE_PROJECT_FROM_EJB_JAR"), ClassImporter.this.resourceRepository().getString("UPDATE_PROJECT_FROM_EJB_JAR.title"), 0);
                }
            }
            Prompt prompt = new Prompt();
            try {
                EventQueue.invokeAndWait(prompt);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            return prompt.option == 0;
        }

        private boolean canReadWithProblems(LinkedHashMap problems) {
            StatusDialog.Status status = StatusDialog.createStatus((Object)this.project, problems);
            LocalStatusDialog dialog = new LocalStatusDialog(Collections.singleton(status));
            AbstractFrameworkAction.launchAndWait(dialog);
            return dialog.wasConfirmed();
        }

        private void showEJBResult(Collection results) {
            if (results.isEmpty()) {
                return;
            }
            StatusDialog dialog = new StatusDialog(this.workbenchContext(), results, "PROJECT_EJB_UPDATE_STATUS_DIALOG_TITLE", "PROJECT_EJB_UPDATE_STATUS_DIALOG_MESSAGE", "project.export.ejb-jar.xml"){

                protected CellRendererAdapter buildNodeRenderer(Object value) {
                    if (value instanceof MWProject) {
                        return new ProjectCellRendererAdapter(ClassImporter.this.resourceRepository());
                    }
                    return super.buildNodeRenderer(value);
                }
            };
            AbstractFrameworkAction.launchAndWait(dialog);
        }

        WorkbenchContext workbenchContext() {
            return AddOrRefreshClassesAction.this.getWorkbenchContext();
        }

        ResourceRepository resourceRepository() {
            return AddOrRefreshClassesAction.this.resourceRepository();
        }
    }

    private class LocalClassDescriptionRepository
    extends ExternalClassDescriptionClassDescriptionRepository {
        Set userClassNames;

        LocalClassDescriptionRepository(MWClassRepository repository) {
            super(repository);
            Classpath cp = new Classpath(CollectionTools.list((Iterator)repository.fullyQualifiedClasspathEntries()));
            this.userClassNames = new HashSet(1000);
            cp.addClassNamesTo((Collection)this.userClassNames);
        }

        protected boolean accept(String externalClassDescriptionName) {
            return super.accept(externalClassDescriptionName) && this.userClassNames.contains(externalClassDescriptionName);
        }
    }
}

