/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.chooser;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionAdapter;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionRepositoryFactory;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

public class ClassChooserPanel
extends AbstractPanel {
    private PropertyValueModel selectionHolder;
    private ClassDescriptionRepositoryFactory classDescriptionRepositoryFactory;
    ClassDescriptionAdapter classDescriptionAdapter;
    private boolean allowNullSelection;
    private String buttonKey;

    public ClassChooserPanel(PropertyValueModel selectionHolder, ClassDescriptionRepositoryFactory classDescriptionRepositoryFactory, ClassDescriptionAdapter classDescriptionAdapter, WorkbenchContextHolder contextHolder) {
        this(selectionHolder, classDescriptionRepositoryFactory, classDescriptionAdapter, null, contextHolder);
    }

    public ClassChooserPanel(PropertyValueModel selectionHolder, ClassDescriptionRepositoryFactory classDescriptionRepositoryFactory, ClassDescriptionAdapter classDescriptionAdapter, JLabel label, WorkbenchContextHolder contextHolder) {
        this(selectionHolder, classDescriptionRepositoryFactory, classDescriptionAdapter, label, contextHolder, "CLASS_CHOOSER_BROWSE_BUTTON");
    }

    public ClassChooserPanel(PropertyValueModel selectionHolder, ClassDescriptionRepositoryFactory classDescriptionRepositoryFactory, ClassDescriptionAdapter classDescriptionAdapter, JLabel label, WorkbenchContextHolder contextHolder, String buttonKey) {
        super(contextHolder);
        this.selectionHolder = selectionHolder;
        this.classDescriptionRepositoryFactory = classDescriptionRepositoryFactory;
        this.classDescriptionAdapter = classDescriptionAdapter;
        this.allowNullSelection = false;
        this.buttonKey = buttonKey;
        this.initializeLayout(label);
    }

    private void initializeLayout(JLabel label) {
        GridBagConstraints constraints = new GridBagConstraints();
        JTextField textField = new JTextField(new DocumentAdapter(this.buildClassNameHolder()), null, 1);
        textField.setEditable(false);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)textField, constraints);
        if (label != null) {
            textField.putClientProperty("labeledBy", label);
        }
        JButton button = this.buildButton(this.buttonKey);
        button.addActionListener(this.buildActionListener());
        if (label != null) {
            label.setLabelFor(button);
            SwingComponentFactory.updateButtonAccessibleName(label, button);
        }
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)button, constraints);
        this.addAlignRight(button);
    }

    private PropertyValueModel buildClassNameHolder() {
        return new TransformationPropertyValueModel(this.selectionHolder){

            protected Object transform(Object value) {
                return value == null ? "" : ClassChooserPanel.this.classDescriptionAdapter.className(value).replace('$', '.');
            }

            protected Object reverseTransform(Object value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private ActionListener buildActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassChooserPanel.this.promptUserToSelectClass();
            }
        };
    }

    private ClassDescriptionRepository buildRepository() {
        return this.classDescriptionRepositoryFactory.createClassDescriptionRepository();
    }

    private Object getSelection() {
        return this.selectionHolder.getValue();
    }

    void promptUserToSelectClass() {
        ClassChooserDialog dialog = this.buildDialog();
        dialog.setAllowNullSelection(this.allowNullSelection);
        dialog.setInitialSelection(this.getSelection());
        dialog.show();
        if (dialog.wasConfirmed()) {
            this.selectionHolder.setValue(dialog.selection());
        }
        dialog = null;
        ClassChooserDialog.gc();
    }

    private ClassChooserDialog buildDialog() {
        return ClassChooserDialog.createDialog(this.buildRepository(), this.classDescriptionAdapter, this.getWorkbenchContext());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int i = this.getComponentCount();
        while (i-- > 0) {
            this.getComponent(i).setEnabled(enabled);
        }
    }

    public void setAllowNullSelection(boolean allowNullSelection) {
        this.allowNullSelection = allowNullSelection;
    }
}

