/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.action;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.eclipse.persistence.tools.workbench.framework.Application;
import org.eclipse.persistence.tools.workbench.framework.NodeManager;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.ShellWorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;

public abstract class AbstractFrameworkAction
extends AbstractAction
implements FrameworkAction {
    private WorkbenchContext workbenchContext;
    protected static final Icon EMPTY_ICON = new EmptyIcon(16);

    protected AbstractFrameworkAction(WorkbenchContext workbenchContext) {
        this.workbenchContext = workbenchContext;
        this.initialize();
    }

    protected AbstractFrameworkAction(ApplicationContext applicationContext) {
        this(new ShellWorkbenchContext(applicationContext));
    }

    protected void initialize() {
    }

    protected void initializeText(String key) {
        this.setText(this.resourceRepository().getString(key));
    }

    protected void initializeMnemonic(String key) {
        this.setMnemonic(this.resourceRepository().getMnemonic(key));
    }

    protected void initializeTextAndMnemonic(String key) {
        this.initializeText(key);
        this.initializeMnemonic(key);
    }

    protected void initializeAccelerator(String key) {
        this.setAccelerator(this.resourceRepository().getAccelerator(key));
    }

    protected void initializeIcon(String key) {
        this.setIcon(this.resourceRepository().getIcon(key));
    }

    protected void initializeToolTipText(String key) {
        this.setToolTipText(this.resourceRepository().getString(key));
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void actionPerformed(ActionEvent e) {
        this.currentWindow().setCursor(Cursor.getPredefinedCursor(3));
        this.execute();
        this.currentWindow().setCursor(Cursor.getDefaultCursor());
    }

    protected void execute() {
        ApplicationNode[] nodes = this.selectedNodes();
        int i = nodes.length;
        while (i-- > 0) {
            this.execute(nodes[i]);
        }
    }

    protected void execute(ApplicationNode selectedNode) {
        throw new UnsupportedOperationException();
    }

    public String getText() {
        return (String)this.getValue("Name");
    }

    public int getMnemonic() {
        Integer mnemonic = (Integer)this.getValue("MnemonicKey");
        return mnemonic == null ? -1 : mnemonic;
    }

    public KeyStroke getAccelerator() {
        return (KeyStroke)this.getValue("AcceleratorKey");
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public String getToolTipText() {
        return (String)this.getValue("ShortDescription");
    }

    public void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public void setText(String text) {
        this.putValue("Name", text);
    }

    public void setToolTipText(String toolTipText) {
        this.putValue("ShortDescription", toolTipText);
    }

    public void setAccelerator(KeyStroke accelerator) {
        this.putValue("AcceleratorKey", accelerator);
    }

    public void setMnemonic(int mnemonic) {
        this.putValue("MnemonicKey", new Integer(mnemonic));
    }

    public ApplicationContext getApplicationContext() {
        return this.getWorkbenchContext().getApplicationContext();
    }

    public WorkbenchContext getWorkbenchContext() {
        return this.workbenchContext;
    }

    public Application application() {
        return this.getApplicationContext().getApplication();
    }

    public Preferences preferences() {
        return this.getApplicationContext().getPreferences();
    }

    public ResourceRepository resourceRepository() {
        return this.getApplicationContext().getResourceRepository();
    }

    public NodeManager nodeManager() {
        return this.getApplicationContext().getNodeManager();
    }

    public HelpManager helpManager() {
        return this.getApplicationContext().getHelpManager();
    }

    public Window currentWindow() {
        return this.getWorkbenchContext().getCurrentWindow();
    }

    public NavigatorSelectionModel navigatorSelectionModel() {
        return this.getWorkbenchContext().getNavigatorSelectionModel();
    }

    public ApplicationNode[] selectedNodes() {
        return this.navigatorSelectionModel().getSelectedNodes();
    }

    public ApplicationNode[] selectedProjectNodes() {
        return this.navigatorSelectionModel().getSelectedProjectNodes();
    }

    public String getClassification() {
        return this.getClass().getName();
    }

    public static Runnable buildDialogLauncher(final Dialog d) {
        return new Runnable(){

            public void run() {
                d.show();
            }
        };
    }

    public static void launchLater(Dialog d) {
        EventQueue.invokeLater(AbstractFrameworkAction.buildDialogLauncher(d));
    }

    public static void launchAndWait(Dialog d) {
        try {
            EventQueue.invokeAndWait(AbstractFrameworkAction.buildDialogLauncher(d));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

