/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.io.IOException;
import javax.xml.validation.ValidatorHandler;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLReader
implements org.xml.sax.XMLReader {
    protected static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    public static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    public static final String REPORT_IGNORED_ELEMENT_CONTENT_WHITESPACE_FEATURE = "http://java.sun.com/xml/schema/features/report-ignored-element-content-whitespace";
    private org.xml.sax.XMLReader reader;
    private boolean supportsLexicalHandler = true;
    private LexicalHandlerWrapper lexicalHandlerWrapper;
    protected ValidatingContentHandler validatingContentHandler;

    public XMLReader(org.xml.sax.XMLReader internalReader) {
        this();
        this.reader = internalReader;
    }

    public XMLReader() {
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.reader.getContentHandler();
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        if (this.validatingContentHandler != null) {
            this.validatingContentHandler.setContentHandler(handler);
        } else {
            this.reader.setContentHandler(handler);
        }
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.reader.getDTDHandler();
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.reader.setDTDHandler(handler);
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.reader.setEntityResolver(resolver);
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.reader.getEntityResolver();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.reader.getErrorHandler();
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        if (this.validatingContentHandler != null) {
            this.validatingContentHandler.setErrorHandler(handler);
        } else {
            this.reader.setErrorHandler(handler);
        }
    }

    public LexicalHandler getLexicalHandler() {
        if (this.supportsLexicalHandler) {
            try {
                return (LexicalHandler)this.reader.getProperty(LEXICAL_HANDLER_PROPERTY);
            }
            catch (SAXException e) {
                this.supportsLexicalHandler = false;
            }
        }
        return null;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        if (this.supportsLexicalHandler) {
            if (null == this.lexicalHandlerWrapper) {
                try {
                    this.lexicalHandlerWrapper = new LexicalHandlerWrapper(lexicalHandler);
                    this.reader.setProperty(LEXICAL_HANDLER_PROPERTY, this.lexicalHandlerWrapper);
                }
                catch (SAXException e) {
                    this.supportsLexicalHandler = false;
                }
            } else {
                this.lexicalHandlerWrapper.setLexicalHandler(lexicalHandler);
            }
        }
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.reader.getFeature(name);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.reader.setFeature(name, value);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (LEXICAL_HANDLER_PROPERTY.equals(name)) {
            return this.getLexicalHandler();
        }
        return this.reader.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (LEXICAL_HANDLER_PROPERTY.equals(name)) {
            this.setLexicalHandler((LexicalHandler)value);
        } else {
            this.reader.setProperty(name, value);
        }
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        try {
            this.reader.parse(input);
        }
        catch (SAXNotSupportedException e) {
            String message = e.getMessage();
            if (message != null && message.contains("namespace-prefix")) {
                this.reader.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
                this.reader.parse(input);
            }
            throw e;
        }
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        try {
            this.reader.parse(systemId);
        }
        catch (SAXNotSupportedException e) {
            String message = e.getMessage();
            if (message != null && message.contains("namespace-prefix")) {
                this.reader.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
                this.reader.parse(systemId);
            }
            throw e;
        }
    }

    public void setValidatorHandler(ValidatorHandler validatorHandler) {
        ContentHandler contentHandler;
        ErrorHandler errorHandler = this.getErrorHandler();
        if (null == this.validatingContentHandler) {
            contentHandler = this.getContentHandler();
        } else {
            contentHandler = validatorHandler.getContentHandler();
            this.validatingContentHandler = null;
        }
        ValidatingContentHandler validatingContentHandler = null;
        if (null != validatorHandler) {
            validatingContentHandler = new ValidatingContentHandler(validatorHandler);
            validatingContentHandler.setContentHandler(contentHandler);
            contentHandler = validatingContentHandler;
        }
        if (null != this.reader) {
            this.reader.setContentHandler(contentHandler);
        }
        this.setContentHandler(contentHandler);
        this.validatingContentHandler = validatingContentHandler;
        this.setErrorHandler(errorHandler);
    }

    public ValidatorHandler getValidatorHandler() {
        if (null == this.validatingContentHandler) {
            return null;
        }
        return this.validatingContentHandler.getValidatorHandler();
    }

    public void newObjectEvent(Object object, Object parent, XMLMapping selfRecordMapping) {
    }

    public Object getCurrentObject(AbstractSession session, XMLMapping selfRecordMapping) {
        return null;
    }

    public Object getValue(CharSequence characters, Class<?> dataType) {
        return null;
    }

    protected static class ValidatingContentHandler
    implements ContentHandler {
        private ValidatorHandler validatorHandler;
        private ContentHandler contentHandler;

        public ValidatingContentHandler(ValidatorHandler validatorHandler) {
            this.validatorHandler = validatorHandler;
        }

        public ContentHandler getContentHandler() {
            return this.contentHandler;
        }

        public void setContentHandler(ContentHandler contentHandler) {
            this.contentHandler = contentHandler;
        }

        public void setErrorHandler(ErrorHandler errorHandler) {
            this.validatorHandler.setErrorHandler(errorHandler);
        }

        public ValidatorHandler getValidatorHandler() {
            return this.validatorHandler;
        }

        public void setValidatorHandler(ValidatorHandler validatorHandler) {
            this.validatorHandler = validatorHandler;
        }

        public void setDocumentLocator(Locator locator) {
            this.validatorHandler.setDocumentLocator(locator);
            this.contentHandler.setDocumentLocator(locator);
        }

        public void startDocument() throws SAXException {
            this.validatorHandler.startDocument();
            this.contentHandler.startDocument();
        }

        public void endDocument() throws SAXException {
            this.validatorHandler.endDocument();
            this.contentHandler.endDocument();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.validatorHandler.startPrefixMapping(prefix, uri);
            this.contentHandler.startPrefixMapping(prefix, uri);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.validatorHandler.endPrefixMapping(prefix);
            this.contentHandler.endPrefixMapping(prefix);
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.validatorHandler.startElement(uri, localName, qName, atts);
            this.contentHandler.startElement(uri, localName, qName, atts);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.validatorHandler.endElement(uri, localName, qName);
            this.contentHandler.endElement(uri, localName, qName);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.validatorHandler.characters(ch, start, length);
            this.contentHandler.characters(ch, start, length);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.validatorHandler.ignorableWhitespace(ch, start, length);
            this.contentHandler.characters(ch, start, length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.validatorHandler.processingInstruction(target, data);
            this.contentHandler.processingInstruction(target, data);
        }

        public void skippedEntity(String name) throws SAXException {
            this.validatorHandler.skippedEntity(name);
            this.contentHandler.skippedEntity(name);
        }
    }

    private static class LexicalHandlerWrapper
    implements LexicalHandler {
        private LexicalHandler lexicalHandler;

        public LexicalHandlerWrapper(LexicalHandler lexicalHandler) {
            this.lexicalHandler = lexicalHandler;
        }

        public void setLexicalHandler(LexicalHandler lexicalHandler) {
            this.lexicalHandler = lexicalHandler;
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            if (null != this.lexicalHandler) {
                this.lexicalHandler.comment(ch, start, length);
            }
        }

        public void endCDATA() throws SAXException {
            if (null != this.lexicalHandler) {
                this.lexicalHandler.endCDATA();
            }
        }

        public void endDTD() throws SAXException {
            if (null != this.lexicalHandler) {
                this.lexicalHandler.endDTD();
            }
        }

        public void endEntity(String name) throws SAXException {
            if (null != this.lexicalHandler) {
                this.lexicalHandler.endEntity(name);
            }
        }

        public void startCDATA() throws SAXException {
            if (null != this.lexicalHandler) {
                this.lexicalHandler.startCDATA();
            }
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            if (null != this.lexicalHandler) {
                this.lexicalHandler.startCDATA();
            }
        }

        public void startEntity(String name) throws SAXException {
            if (null != this.lexicalHandler) {
                this.lexicalHandler.startEntity(name);
            }
        }
    }
}

