/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.partitioning;

import org.eclipse.persistence.descriptors.partitioning.FieldPartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.AbstractPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public abstract class FieldPartitioningMetadata
extends AbstractPartitioningMetadata {
    protected ColumnMetadata partitionColumn;
    protected String partitionValueType;
    protected Boolean unionUnpartitionableQueries;

    public FieldPartitioningMetadata() {
        super("<field-partitioning>");
    }

    public FieldPartitioningMetadata(MetadataAnnotation annotation, MetadataAccessor accessor) {
        super(annotation, accessor);
        MetadataAnnotation column = (MetadataAnnotation)annotation.getAttribute("partitionColumn");
        if (column != null) {
            this.partitionColumn = new ColumnMetadata(column, accessor);
        }
        this.partitionValueType = (String)annotation.getAttribute("partitionValueType");
        this.unionUnpartitionableQueries = (Boolean)annotation.getAttribute("unionUnpartitionableQueries");
    }

    protected FieldPartitioningMetadata(String elementName) {
        super(elementName);
    }

    public void buildPolicy(PartitioningPolicy policy) {
        super.buildPolicy(policy);
        if (this.partitionColumn != null) {
            ((FieldPartitioningPolicy)policy).setPartitionField(this.partitionColumn.getDatabaseField());
        }
        if (this.unionUnpartitionableQueries != null) {
            ((FieldPartitioningPolicy)policy).setUnionUnpartitionableQueries(this.unionUnpartitionableQueries);
        }
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof FieldPartitioningMetadata) {
            FieldPartitioningMetadata policy = (FieldPartitioningMetadata)objectToCompare;
            return this.valuesMatch(this.partitionColumn, policy.getPartitionColumn()) && this.valuesMatch(this.unionUnpartitionableQueries, policy.getUnionUnpartitionableQueries()) && this.valuesMatch(this.partitionValueType, policy.getPartitionValueType());
        }
        return false;
    }

    public ColumnMetadata getPartitionColumn() {
        return this.partitionColumn;
    }

    public String getPartitionValueType() {
        return this.partitionValueType;
    }

    public Boolean getUnionUnpartitionableQueries() {
        return this.unionUnpartitionableQueries;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.partitionColumn, accessibleObject);
    }

    public void setPartitionColumn(ColumnMetadata partitionColumn) {
        this.partitionColumn = partitionColumn;
    }

    public void setPartitionValueType(String partitionValueType) {
        this.partitionValueType = partitionValueType;
    }

    public void setUnionUnpartitionableQueries(Boolean unionUnpartitionableQueries) {
        this.unionUnpartitionableQueries = unionUnpartitionableQueries;
    }
}

