/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile;

import java.io.File;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile.CFExternalClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile.CFExternalClassRepository;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassFile;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class CFExternalClassDescription
implements ExternalClassDescription {
    private final String name;
    private final File classpathEntry;
    private final CFExternalClassRepository repository;
    private ExternalClass externalClass;

    CFExternalClassDescription(String name, String classpathEntry, CFExternalClassRepository repository) {
        this.name = name;
        this.classpathEntry = new File(classpathEntry);
        this.repository = repository;
    }

    CFExternalClassDescription(String name, CFExternalClassRepository repository) {
        this.name = name;
        this.classpathEntry = null;
        this.repository = repository;
    }

    public int getArrayDepth() {
        return ClassTools.arrayDepthForClassNamed(this.name);
    }

    public String getAdditionalInfo() {
        return this.classpathEntry.getPath();
    }

    public String getElementTypeName() {
        return ClassTools.elementTypeNameForClassNamed(this.name);
    }

    public synchronized ExternalClass getExternalClass() throws ExternalClassNotFoundException {
        if (this.externalClass == null) {
            this.externalClass = this.buildExternalClass();
        }
        return this.externalClass;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSynthetic() {
        return ClassTools.classNamedIsAnonymous(this.name);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.getName());
    }

    ExternalClassDescription classDescriptionNamed(String className) {
        return this.repository.getClassDescriptionNamed(className);
    }

    private ExternalClass buildExternalClass() throws ExternalClassNotFoundException {
        if (this.classpathEntry == null) {
            throw new IllegalStateException();
        }
        try {
            return new CFExternalClass(ClassFile.forClass(this.classpathEntry, this.name), this);
        }
        catch (Throwable t) {
            throw new ExternalClassNotFoundException(this.name, t);
        }
    }
}

