/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.resource;

import java.io.IOException;
import java.net.URL;
import org.apache.xerces.util.URI;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ClasspathResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.FileResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.UrlResourceSpecification;

public abstract class ResourceSpecification
extends MWModel {
    protected String location;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(ResourceSpecification.class);
        InheritancePolicy ip = descriptor.getInheritancePolicy();
        ip.setClassIndicatorFieldName("@type");
        ip.addClassIndicator(FileResourceSpecification.class, (Object)"file");
        ip.addClassIndicator(UrlResourceSpecification.class, (Object)"url");
        ip.addClassIndicator(ClasspathResourceSpecification.class, (Object)"classpath");
        descriptor.addDirectMapping("location", "getLocationForTopLink", "setLocationForTopLink", "location/text()");
        return descriptor;
    }

    protected ResourceSpecification() {
    }

    protected ResourceSpecification(MWModel parent, String resourceLocation) {
        super(parent);
        this.location = resourceLocation;
    }

    public String getLocation() {
        return this.location;
    }

    public abstract String getSourceKey();

    public URL validResourceUrl() throws ResourceException {
        URL resourceUrl = this.resourceUrl();
        try {
            resourceUrl.openConnection();
        }
        catch (IOException ioe) {
            throw ResourceException.inaccessibleResourceException(ioe);
        }
        return resourceUrl;
    }

    public URI validResourceURI() throws ResourceException {
        URL url = this.validResourceUrl();
        URI uri = null;
        try {
            uri = new URI(url.toString().replace(" ", "%20"));
        }
        catch (URI.MalformedURIException exception) {
            throw ResourceException.incorrectlySpecifiedResourceException(exception);
        }
        return uri;
    }

    protected abstract URL resourceUrl() throws ResourceException;

    public void toString(StringBuffer sb) {
        sb.append(this.location);
    }

    private String getLocationForTopLink() {
        return this.getLocationForTopLink2();
    }

    protected String getLocationForTopLink2() {
        return this.location;
    }

    private void setLocationForTopLink(String loc) {
        this.setLocationForTopLink2(loc);
    }

    protected void setLocationForTopLink2(String loc) {
        this.location = loc;
    }
}

