/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAbstractRelationalReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBatchReadItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWOrderableQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWOrderingItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Ordering;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWRelationalReadAllQuery
extends MWAbstractRelationalReadQuery
implements MWReadAllQuery,
MWOrderableQuery {
    private List batchReadItems;
    public static final String BATCH_READ_ITEMS_LIST = "batchReadItems";
    private List orderingItems;
    public static final String ORDERING_ITEMS_LIST = "orderingItems";

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWRelationalReadAllQuery.class);
        descriptor.getInheritancePolicy().setParentClass(MWAbstractRelationalReadQuery.class);
        XMLCompositeCollectionMapping batchReadItemsMapping = new XMLCompositeCollectionMapping();
        batchReadItemsMapping.setAttributeName(BATCH_READ_ITEMS_LIST);
        batchReadItemsMapping.setReferenceClass(MWOrderingItem.class);
        batchReadItemsMapping.setXPath("batch-reads/batch-read-item");
        descriptor.addMapping((DatabaseMapping)batchReadItemsMapping);
        XMLCompositeCollectionMapping orderingItemsMapping = new XMLCompositeCollectionMapping();
        orderingItemsMapping.setAttributeName(ORDERING_ITEMS_LIST);
        orderingItemsMapping.setReferenceClass(MWOrderingItem.class);
        orderingItemsMapping.setXPath("orderings/ordering-item");
        descriptor.addMapping((DatabaseMapping)orderingItemsMapping);
        return descriptor;
    }

    private MWRelationalReadAllQuery() {
    }

    MWRelationalReadAllQuery(MWRelationalQueryManager parent, String name) {
        super(parent, name);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.batchReadItems = new Vector();
        this.orderingItems = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        List list = this.batchReadItems;
        synchronized (list) {
            children.addAll(this.batchReadItems);
        }
        list = this.orderingItems;
        synchronized (list) {
            children.addAll(this.orderingItems);
        }
    }

    public MWReportQuery asReportQuery() {
        this.getQueryManager().removeQuery(this);
        MWReportQuery newQuery = ((MWRelationalQueryManager)this.getQueryManager()).addReportQuery(this.getName());
        newQuery.initializeFrom(this);
        return newQuery;
    }

    public MWReadObjectQuery asReadObjectQuery() {
        this.getQueryManager().removeQuery(this);
        MWReadObjectQuery newQuery = this.getQueryManager().addReadObjectQuery(this.getName());
        ((MWAbstractQuery)((Object)newQuery)).initializeFrom(this);
        return newQuery;
    }

    public MWReadAllQuery asReadAllQuery() {
        return this;
    }

    public String queryType() {
        return "READ_ALL_QUERY";
    }

    public Ordering addOrderingItem(MWQueryable queryable) {
        if (this.orderingAttributesAllowed()) {
            MWOrderingItem orderingItem = new MWOrderingItem(this, queryable);
            this.addOrderingItem(orderingItem);
            return orderingItem;
        }
        throw new IllegalStateException("Ordering Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public Ordering addOrderingItem(Iterator queryables) {
        if (this.orderingAttributesAllowed()) {
            MWOrderingItem orderingItem = new MWOrderingItem(this, queryables);
            this.addOrderingItem(orderingItem);
            return orderingItem;
        }
        throw new IllegalStateException("Ordering Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public Ordering addOrderingItem(Iterator queryables, Iterator allowsNull) {
        if (this.orderingAttributesAllowed()) {
            MWOrderingItem orderingItem = new MWOrderingItem(this, queryables, allowsNull);
            this.addOrderingItem(orderingItem);
            return orderingItem;
        }
        throw new IllegalStateException("Ordering Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public Ordering addOrderingItem(int index, Iterator queryables, Iterator allowsNull) {
        if (this.orderingAttributesAllowed()) {
            MWOrderingItem orderingItem = new MWOrderingItem(this, queryables, allowsNull);
            this.addOrderingItem(index, orderingItem);
            return orderingItem;
        }
        throw new IllegalStateException("Ordering Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    private boolean orderingAttributesAllowed() {
        return this.getQueryFormat().orderingAttributesAllowed();
    }

    private void addOrderingItem(Ordering orderingItem) {
        this.addOrderingItem(this.orderingItemsSize(), orderingItem);
    }

    private void addOrderingItem(int index, Ordering orderingItem) {
        this.addItemToList(index, orderingItem, this.orderingItems, ORDERING_ITEMS_LIST);
    }

    public void removeOrderingItem(Ordering orderingItem) {
        this.removeOrderingItem(this.orderingItems.indexOf(orderingItem));
    }

    public void removeOrderingItem(int index) {
        this.removeItemFromList(index, this.orderingItems, ORDERING_ITEMS_LIST);
    }

    public void removeOrderingItems(Iterator orderingItems) {
        while (orderingItems.hasNext()) {
            this.removeOrderingItem((Ordering)orderingItems.next());
        }
    }

    public ListIterator orderingItems() {
        return new CloneListIterator(this.orderingItems);
    }

    public int orderingItemsSize() {
        return this.orderingItems.size();
    }

    public int indexOfOrderingItem(Ordering orderingItem) {
        return this.orderingItems.indexOf(orderingItem);
    }

    public void moveOrderingItemUp(Ordering item) {
        int index = this.indexOfOrderingItem(item);
        this.removeOrderingItem(index);
        this.addOrderingItem(index - 1, item);
    }

    public void moveOrderingItemDown(Ordering item) {
        int index = this.indexOfOrderingItem(item);
        this.removeOrderingItem(index);
        this.addOrderingItem(index + 1, item);
    }

    public MWBatchReadItem addBatchReadItem(MWQueryable queryable) {
        if (this.batchReadAttributesAllowed()) {
            MWBatchReadItem item = new MWBatchReadItem(this, queryable);
            this.addBatchReadItem(item);
            return item;
        }
        throw new IllegalStateException("BatchRead Items are not allowed if the QueryFormat is SQL");
    }

    public MWBatchReadItem addBatchReadItem(Iterator queryables) {
        if (this.batchReadAttributesAllowed()) {
            MWBatchReadItem item = new MWBatchReadItem(this, queryables);
            this.addBatchReadItem(item);
            return item;
        }
        throw new IllegalStateException("BatchRead Items are not allowed if the QueryFormat is SQL");
    }

    public MWBatchReadItem addBatchReadItem(Iterator queryables, Iterator allowsNull) {
        if (this.batchReadAttributesAllowed()) {
            MWBatchReadItem item = new MWBatchReadItem(this, queryables, allowsNull);
            this.addBatchReadItem(item);
            return item;
        }
        throw new IllegalStateException("BatchRead Items are not allowed if the QueryFormat is SQL");
    }

    public MWBatchReadItem addBatchReadItem(int index, Iterator queryables, Iterator allowsNull) {
        if (this.batchReadAttributesAllowed()) {
            MWBatchReadItem item = new MWBatchReadItem(this, queryables, allowsNull);
            this.addBatchReadItem(index, item);
            return item;
        }
        throw new IllegalStateException("BatchRead Items are not allowed if the QueryFormat is SQL");
    }

    private boolean batchReadAttributesAllowed() {
        return this.getQueryFormat().batchReadAttributesAllowed();
    }

    private void addBatchReadItem(MWBatchReadItem item) {
        this.addBatchReadItem(this.batchReadItemsSize(), item);
    }

    private void addBatchReadItem(int index, MWBatchReadItem item) {
        this.addItemToList(index, item, this.batchReadItems, BATCH_READ_ITEMS_LIST);
    }

    public void removeBatchReadItem(MWBatchReadItem batchReadItem) {
        this.removeBatchReadItem(this.batchReadItems.indexOf(batchReadItem));
    }

    public void removeBatchReadItem(int index) {
        this.removeItemFromList(index, this.batchReadItems, BATCH_READ_ITEMS_LIST);
    }

    public void removeBatchReadItems(Iterator batchReadItems) {
        while (batchReadItems.hasNext()) {
            this.removeBatchReadItem((MWBatchReadItem)batchReadItems.next());
        }
    }

    public void moveBatchReadItemUp(MWBatchReadItem batchReadItem) {
        int index = this.indexOfBatchReadItem(batchReadItem);
        this.removeBatchReadItem(index);
        this.addBatchReadItem(index - 1, batchReadItem);
    }

    public void moveBatchReadItemDown(MWBatchReadItem batchReadItem) {
        int index = this.indexOfBatchReadItem(batchReadItem);
        this.removeBatchReadItem(index);
        this.addBatchReadItem(index + 1, batchReadItem);
    }

    public ListIterator batchReadItems() {
        return new CloneListIterator(this.batchReadItems);
    }

    public int batchReadItemsSize() {
        return this.batchReadItems.size();
    }

    public int indexOfBatchReadItem(MWBatchReadItem item) {
        return this.batchReadItems.indexOf(item);
    }

    public void formatSetToEjbql() {
        this.removeOrderingItems(this.orderingItems());
    }

    public void formatSetToSql() {
        this.removeOrderingItems(this.orderingItems());
        this.removeBatchReadItems(this.batchReadItems());
    }

    public DatabaseQuery runtimeQuery() {
        ReadAllQuery query = (ReadAllQuery)super.runtimeQuery();
        ListIterator i = this.batchReadItems();
        while (i.hasNext()) {
            ((MWBatchReadItem)i.next()).adjustRuntimeQuery((ObjectLevelReadQuery)query);
        }
        i = this.orderingItems();
        while (i.hasNext()) {
            ((MWOrderingItem)i.next()).adjustRuntimeQuery((ObjectLevelReadQuery)query);
        }
        return query;
    }

    protected ObjectLevelReadQuery buildRuntimeQuery() {
        return new ReadAllQuery();
    }
}

