/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWConverterMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWNullConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWObjectTypeConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWSerializedObjectConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTypeConversionConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWDirectContainerMapping
extends MWMapping
implements MWConverterMapping {
    private MWConverter directValueConverter;

    protected MWDirectContainerMapping() {
    }

    public MWDirectContainerMapping(MWMappingDescriptor parent, MWClassAttribute attribute, String name) {
        super(parent, attribute, name);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.directValueConverter = new MWNullConverter(this);
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.directValueConverter);
    }

    public MWConverter getConverter() {
        return this.directValueConverter;
    }

    public MWNullConverter setNullConverter() {
        MWNullConverter nullConverter = new MWNullConverter(this);
        this.setDirectValueConverter(nullConverter);
        return nullConverter;
    }

    public MWObjectTypeConverter setObjectTypeConverter() {
        MWObjectTypeConverter objectTypeConverter = new MWObjectTypeConverter(this);
        this.setDirectValueConverter(objectTypeConverter);
        return objectTypeConverter;
    }

    public MWSerializedObjectConverter setSerializedObjectConverter() {
        MWSerializedObjectConverter serializedObjectConverter = new MWSerializedObjectConverter(this);
        this.setDirectValueConverter(serializedObjectConverter);
        return serializedObjectConverter;
    }

    public MWTypeConversionConverter setTypeConversionConverter() {
        MWTypeConversionConverter typeConversionConverter = this.buildTypeConversionConverter();
        this.setDirectValueConverter(typeConversionConverter);
        return typeConversionConverter;
    }

    protected abstract MWTypeConversionConverter buildTypeConversionConverter();

    private void setDirectValueConverter(MWConverter newConverter) {
        MWConverter oldConverter = this.directValueConverter;
        this.directValueConverter = newConverter;
        newConverter.setParent(this);
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    public boolean usesTransparentIndirection() {
        return false;
    }

    protected void initializeFromMWConverterMapping(MWConverterMapping converterMapping) {
        super.initializeFromMWConverterMapping(converterMapping);
        this.setDirectValueConverter(converterMapping.getConverter());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWDirectContainerMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWMapping.class);
        XMLCompositeObjectMapping converterMapping = new XMLCompositeObjectMapping();
        converterMapping.setReferenceClass(MWConverter.class);
        converterMapping.setAttributeName("directValueConverter");
        converterMapping.setGetMethodName("getConverterForTopLink");
        converterMapping.setSetMethodName("setConverterForTopLink");
        converterMapping.setXPath("direct-value-converter");
        descriptor.addMapping((DatabaseMapping)converterMapping);
        return descriptor;
    }

    private MWConverter getConverterForTopLink() {
        return this.directValueConverter == null ? null : this.directValueConverter.getValueForTopLink();
    }

    private void setConverterForTopLink(MWConverter converter) {
        this.directValueConverter = converter == null ? new MWNullConverter(this) : converter;
    }
}

