/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.DailyCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCacheExpiry;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorCachingPolicy;

public final class MWProjectDefaultCacheExpiry
extends MWModel
implements MWCacheExpiry {
    private MWProjectDefaultCacheExpiry() {
    }

    MWProjectDefaultCacheExpiry(MWCachingPolicy parent) {
        super(parent);
    }

    private MWCacheExpiry getProjectCacheExpiry() {
        return this.getProject().getDefaultsPolicy().getCachingPolicy().getCacheExpiry();
    }

    public Date getDailyExpiryTime() {
        return this.getProjectCacheExpiry().getDailyExpiryTime();
    }

    private boolean newExpiryTimeDifferent(Date newExpiryTime) {
        Date oldExpiryTime = this.getDailyExpiryTime();
        return newExpiryTime.getHours() != oldExpiryTime.getHours() || newExpiryTime.getMinutes() != oldExpiryTime.getMinutes() || newExpiryTime.getSeconds() != oldExpiryTime.getSeconds();
    }

    public void setDailyExpiryTime(Date dailyExpiryTime) {
        if (this.newExpiryTimeDifferent(dailyExpiryTime)) {
            this.getCachingPolicy().setUseProjectDefaultCacheExpiry(false);
            this.getCachingPolicy().getCacheExpiry().setDailyExpiryTime(dailyExpiryTime);
        }
    }

    public void setDailyExpiryTime(Calendar dailyExpiryTime) {
        if (this.valuesAreDifferent(dailyExpiryTime.getTime(), this.getDailyExpiryTime())) {
            this.getCachingPolicy().setUseProjectDefaultCacheExpiry(false);
            this.getCachingPolicy().getCacheExpiry().setDailyExpiryTime(dailyExpiryTime);
        }
    }

    public String getExpiryType() {
        return this.getProjectCacheExpiry().getExpiryType();
    }

    public void setExpiryType(String expiryType) {
        if (this.valuesAreDifferent(expiryType, this.getExpiryType())) {
            this.getCachingPolicy().setUseProjectDefaultCacheExpiry(false);
            this.getCachingPolicy().getCacheExpiry().setExpiryType(expiryType);
        }
    }

    public boolean getUpdateReadTimeOnUpdate() {
        return this.getProjectCacheExpiry().getUpdateReadTimeOnUpdate();
    }

    public void setUpdateReadTimeOnUpdate(boolean updateReadTimeOnUpdate) {
        if (updateReadTimeOnUpdate != this.getUpdateReadTimeOnUpdate()) {
            this.getCachingPolicy().setUseProjectDefaultCacheExpiry(false);
            this.getCachingPolicy().getCacheExpiry().setUpdateReadTimeOnUpdate(updateReadTimeOnUpdate);
        }
    }

    public Long getTimeToLiveExpiry() {
        return this.getProjectCacheExpiry().getTimeToLiveExpiry();
    }

    public void setTimeToLiveExpiry(Long timeToLiveExpiry) {
        if (timeToLiveExpiry != this.getTimeToLiveExpiry()) {
            this.getCachingPolicy().setUseProjectDefaultCacheExpiry(false);
            this.getCachingPolicy().getCacheExpiry().setTimeToLiveExpiry(timeToLiveExpiry);
        }
    }

    private MWDescriptorCachingPolicy getCachingPolicy() {
        return (MWDescriptorCachingPolicy)this.getParent();
    }

    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        if (this.getExpiryType() != "No Expiry") {
            if (this.getExpiryType() == "Daily Expiry") {
                Date expiryTime = this.getDailyExpiryTime();
                runtimeDescriptor.setCacheInvalidationPolicy((CacheInvalidationPolicy)new DailyCacheInvalidationPolicy(expiryTime.getHours(), expiryTime.getMinutes(), expiryTime.getSeconds(), 0));
            } else if (this.getExpiryType() == "Time to Live Expiry") {
                runtimeDescriptor.setCacheInvalidationPolicy((CacheInvalidationPolicy)new TimeToLiveCacheInvalidationPolicy(this.getTimeToLiveExpiry().longValue()));
            }
        }
    }

    public MWCacheExpiry getPersistedPolicy() {
        return null;
    }
}

