/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorValue;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWClassIndicatorFieldPolicy
extends MWAbstractClassIndicatorPolicy {
    private volatile boolean classNameIsIndicator;
    public static final String CLASS_NAME_IS_INDICATOR_PROPERTY = "classNameIsIndicator";
    private volatile transient MWTypeDeclaration indicatorType;
    public static final String INDICATOR_TYPE_PROPERTY = "indicatorType";
    private Collection classIndicatorValues;
    public static final String CLASS_INDICATOR_VALUES_COLLECTION = "classIndicatorValues";
    private volatile Class legacyIndicatorType;
    private volatile ConversionManager conversionManager;
    public static Class[] ALLOWED_INDICATOR_TYPES = new Class[]{String.class, Integer.class, Boolean.class, Long.class};
    public static Class DEFAULT_INDICATOR_TYPE = String.class;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWClassIndicatorFieldPolicy.class);
        descriptor.getInheritancePolicy().setParentClass(MWAbstractClassIndicatorPolicy.class);
        XMLDirectMapping classNameIndicatorMapping = (XMLDirectMapping)descriptor.addDirectMapping(CLASS_NAME_IS_INDICATOR_PROPERTY, "class-name-is-indicator/text()");
        classNameIndicatorMapping.setNullValue((Object)Boolean.FALSE);
        XMLCompositeObjectMapping indicatorTypeMapping = new XMLCompositeObjectMapping();
        indicatorTypeMapping.setAttributeName(INDICATOR_TYPE_PROPERTY);
        indicatorTypeMapping.setReferenceClass(MWTypeDeclaration.class);
        indicatorTypeMapping.setXPath("indicator-type");
        descriptor.addMapping((DatabaseMapping)indicatorTypeMapping);
        XMLCompositeCollectionMapping classIndicatorValuesMapping = new XMLCompositeCollectionMapping();
        classIndicatorValuesMapping.setAttributeName(CLASS_INDICATOR_VALUES_COLLECTION);
        classIndicatorValuesMapping.setGetMethodName("getIndicatorValuesForTopLink");
        classIndicatorValuesMapping.setSetMethodName("setIndicatorValuesForTopLink");
        classIndicatorValuesMapping.setReferenceClass(MWClassIndicatorValue.class);
        classIndicatorValuesMapping.setXPath("class-indicator-values/class-indicator-value");
        descriptor.addMapping((DatabaseMapping)classIndicatorValuesMapping);
        return descriptor;
    }

    protected MWClassIndicatorFieldPolicy() {
    }

    protected MWClassIndicatorFieldPolicy(MWClassIndicatorPolicy.Parent parent) {
        this(parent, NullIterator.instance());
    }

    protected MWClassIndicatorFieldPolicy(MWClassIndicatorPolicy.Parent parent, Iterator descriptorsAvailableForIndication) {
        super(parent);
        this.setDescriptorsAvailableForIndicatorDictionary(descriptorsAvailableForIndication);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.indicatorType = new MWTypeDeclaration((MWModel)this, this.typeFor(DEFAULT_INDICATOR_TYPE));
        this.classIndicatorValues = new Vector();
        this.classNameIsIndicator = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Collection collection = this.classIndicatorValues;
        synchronized (collection) {
            children.addAll(this.classIndicatorValues);
        }
        if (this.indicatorType != null) {
            children.add(this.indicatorType);
        }
    }

    public String getType() {
        return "fieldClassIndicatorPolicy";
    }

    public abstract MWDataField getField();

    public MWClassIndicatorValue addIndicator(Object value, MWMappingDescriptor descriptor) {
        MWClassIndicatorValue indicator = new MWClassIndicatorValue(this, descriptor, value);
        this.classIndicatorValues.add(indicator);
        this.fireItemAdded(CLASS_INDICATOR_VALUES_COLLECTION, indicator);
        return indicator;
    }

    public void removeIndicator(MWClassIndicatorValue indicator) {
        this.removeItemFromCollection(indicator, this.classIndicatorValues, CLASS_INDICATOR_VALUES_COLLECTION);
    }

    public void removeIndicatorFor(MWDescriptor descriptor) {
        Iterator stream = this.classIndicatorValues();
        while (stream.hasNext()) {
            MWClassIndicatorValue value = (MWClassIndicatorValue)stream.next();
            if (value.getDescriptorValue() != descriptor) continue;
            this.removeIndicator(value);
            return;
        }
    }

    public void setClassNameIsIndicator(boolean classNameIsIndicator) {
        boolean oldValue = this.classNameIsIndicator;
        this.classNameIsIndicator = classNameIsIndicator;
        if (oldValue != classNameIsIndicator) {
            if (classNameIsIndicator) {
                this.setIndicatorType(null);
            } else {
                this.setIndicatorType(new MWTypeDeclaration((MWModel)this, this.typeNamed(DEFAULT_INDICATOR_TYPE.getName())));
                this.setDescriptorsAvailableForIndicatorDictionary(((MWDescriptorInheritancePolicy)this.getParent()).getAllDescriptorsAvailableForIndicatorDictionary().iterator());
            }
        }
        this.firePropertyChanged(CLASS_NAME_IS_INDICATOR_PROPERTY, oldValue, classNameIsIndicator);
    }

    public void setIndicatorType(MWTypeDeclaration newIndicatorType) {
        MWTypeDeclaration oldValue = this.getIndicatorType();
        this.indicatorType = newIndicatorType;
        this.convertValues();
        this.firePropertyChanged(INDICATOR_TYPE_PROPERTY, oldValue, newIndicatorType);
    }

    public boolean classNameIsIndicator() {
        return this.classNameIsIndicator;
    }

    public Object buildIndicatorValueFromString(String valueString) {
        try {
            Class javaClass = ClassTools.classForTypeDeclaration(this.getIndicatorType().typeName(), this.getIndicatorType().getDimensionality());
            return this.getConversionManager().convertObject((Object)valueString, javaClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ConversionException.couldNotBeConverted((Object)valueString, null);
        }
    }

    public void clearIndicatorValues() {
        Iterator values = this.classIndicatorValues();
        while (values.hasNext()) {
            MWClassIndicatorValue value = (MWClassIndicatorValue)values.next();
            this.removeIndicator(value);
        }
    }

    public void convertValues() {
        if (this.getIndicatorType() == null) {
            this.clearIndicatorValues();
        }
        Iterator i = this.classIndicatorValues();
        while (i.hasNext()) {
            MWClassIndicatorValue value = (MWClassIndicatorValue)i.next();
            Object before = value.getIndicatorValue();
            if (before == null) continue;
            try {
                Object after = this.getConversionManager().convertObject(before, ClassTools.classForTypeDeclaration(this.getIndicatorType().typeName(), this.getIndicatorType().getDimensionality()));
                value.setIndicatorValue(after);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            catch (ConversionException ex) {
                value.setIndicatorValue(null);
            }
        }
    }

    public MWClassIndicatorValue getClassIndicatorValueForDescriptor(MWMappingDescriptor descriptor) {
        Iterator i = this.classIndicatorValues();
        while (i.hasNext()) {
            MWClassIndicatorValue indicatorValue = (MWClassIndicatorValue)i.next();
            if (!indicatorValue.getDescriptorValue().equals(descriptor)) continue;
            return indicatorValue;
        }
        return null;
    }

    public Iterator classIndicatorValues() {
        return new CloneIterator(this.classIndicatorValues);
    }

    public int classIndicatorValuesSize() {
        return this.classIndicatorValues.size();
    }

    public ConversionManager getConversionManager() {
        if (this.conversionManager == null) {
            this.conversionManager = new ConversionManager();
        }
        return this.conversionManager;
    }

    public MWDescriptor getDescriptorForIndicator(Object indicator) {
        Iterator i = this.includedClassIndicatorValues();
        while (i.hasNext()) {
            MWClassIndicatorValue indicatorValue = (MWClassIndicatorValue)i.next();
            if (indicatorValue.getIndicatorValue() == null || !indicatorValue.getIndicatorValue().equals(indicator)) continue;
            return indicatorValue.getDescriptorValue();
        }
        return null;
    }

    public Object getIndicatorForDescriptor(MWMappingDescriptor descriptor) {
        Iterator i = this.classIndicatorValues();
        while (i.hasNext()) {
            MWClassIndicatorValue indicatorValue = (MWClassIndicatorValue)i.next();
            if (!indicatorValue.getDescriptorValue().equals(descriptor)) continue;
            return indicatorValue.getIndicatorValue();
        }
        return null;
    }

    public MWTypeDeclaration getIndicatorType() {
        return this.indicatorType;
    }

    public Iterator includedClassIndicatorValues() {
        return this.getIndicatorValuesForTopLink().iterator();
    }

    public boolean isRepeatedIndicatorValue(Object indicatorValue) {
        Iterator values = this.classIndicatorValues();
        while (values.hasNext()) {
            Object value = ((MWClassIndicatorValue)values.next()).getIndicatorValue();
            if (value == null || !value.equals(indicatorValue)) continue;
            return true;
        }
        return false;
    }

    public void rebuildClassIndicatorValues(Collection descriptors) {
        Iterator i = this.classIndicatorValues();
        while (i.hasNext()) {
            MWClassIndicatorValue indicatorValue = (MWClassIndicatorValue)i.next();
            if (descriptors.contains(indicatorValue.getDescriptorValue())) continue;
            this.removeIndicator(indicatorValue);
        }
        this.setDescriptorsAvailableForIndicatorDictionary(descriptors.iterator());
    }

    public void setDescriptorsAvailableForIndicatorDictionary(Iterator descriptors) {
        if (this.classNameIsIndicator()) {
            this.setIndicatorType(null);
            return;
        }
        while (descriptors.hasNext()) {
            MWMappingDescriptor descriptor = (MWMappingDescriptor)descriptors.next();
            if (this.getClassIndicatorValueForDescriptor(descriptor) != null) continue;
            this.addIndicator(null, descriptor);
        }
    }

    public void setDescriptorsAvailableForIndicatorDictionaryForTopLink(Iterator descriptors) {
        if (this.classNameIsIndicator()) {
            this.setIndicatorType(null);
            return;
        }
        while (descriptors.hasNext()) {
            MWMappingDescriptor descriptor = (MWMappingDescriptor)descriptors.next();
            if (this.getClassIndicatorValueForDescriptor(descriptor) != null) continue;
            MWClassIndicatorValue value = this.addIndicator(null, descriptor);
            value.setInclude(false);
        }
    }

    public void resetDescriptorAvailableForIndication(Iterator descriptors) {
        Iterator currentIndicators = this.classIndicatorValues();
        while (currentIndicators.hasNext()) {
            MWClassIndicatorValue value = (MWClassIndicatorValue)currentIndicators.next();
            this.removeIndicator(value);
        }
        this.setDescriptorsAvailableForIndicatorDictionary(descriptors);
    }

    protected abstract boolean fieldSpecified();

    public void checkClassIndicatorField(List newProblems) {
        if (!this.fieldSpecified()) {
            newProblems.add(this.buildProblem("0054"));
        }
    }

    public void adjustRuntimeInheritancePolicy(InheritancePolicy runtimeInheritancePolicy) {
        Iterator indicatorValues = this.includedClassIndicatorValues();
        while (indicatorValues.hasNext()) {
            Object value = ((MWClassIndicatorValue)indicatorValues.next()).getIndicatorValue();
            if (value == null) continue;
            runtimeInheritancePolicy.addClassNameIndicator(this.getDescriptorForIndicator(value).getMWClass().fullName(), value);
        }
        runtimeInheritancePolicy.setShouldUseClassNameAsIndicator(this.classNameIsIndicator());
    }

    public void postProjectBuild() {
        super.postProjectBuild();
        this.convertValues();
    }

    private List getIndicatorValuesForTopLink() {
        ArrayList<MWClassIndicatorValue> topLinkValues = new ArrayList<MWClassIndicatorValue>();
        Iterator stream = this.classIndicatorValues();
        while (stream.hasNext()) {
            MWClassIndicatorValue value = (MWClassIndicatorValue)stream.next();
            if (!value.isInclude()) continue;
            topLinkValues.add(value);
        }
        return topLinkValues;
    }

    private void setIndicatorValuesForTopLink(List indicatorValues) {
        this.classIndicatorValues = indicatorValues;
    }
}

