/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.db;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWNominative;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalForeignKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalForeignKeyColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalTableDescription;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.utility.NameTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class MWTable
extends MWModel
implements MWNominative {
    private volatile String catalog;
    public static final String CATALOG_PROPERTY = "catalog";
    private volatile String schema;
    public static final String SCHEMA_PROPERTY = "schema";
    private volatile String shortName;
    public static final String SHORT_NAME_PROPERTY = "shortName";
    public static final String QUALIFIED_NAME_PROPERTY = "qualifiedName";
    private Date lastRefreshTimestamp;
    public static final String LAST_REFRESH_TIMESTAMP_PROPERTY = "lastRefreshTimestamp";
    private Collection columns;
    public static final String COLUMNS_COLLECTION = "columns";
    private Collection references;
    public static final String REFERENCES_COLLECTION = "references";
    private boolean legacyIsFullyQualified;

    private MWTable() {
    }

    MWTable(MWDatabase database, String catalog, String schema, String shortName) {
        super(database);
        this.catalog = catalog;
        this.schema = schema;
        this.shortName = shortName;
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.lastRefreshTimestamp = null;
        this.columns = new Vector();
        this.references = new Vector();
    }

    public String getCatalog() {
        return this.catalog;
    }

    private void setCatalog(String catalog) {
        String old = this.catalog;
        this.catalog = catalog;
        if (this.attributeValueHasChanged(old, catalog)) {
            this.firePropertyChanged(CATALOG_PROPERTY, old, catalog);
            this.qualifiedNameChanged();
        }
    }

    public String getSchema() {
        return this.schema;
    }

    private void setSchema(String schema) {
        String old = this.schema;
        this.schema = schema;
        if (this.attributeValueHasChanged(old, schema)) {
            this.firePropertyChanged(SCHEMA_PROPERTY, old, schema);
            this.qualifiedNameChanged();
        }
    }

    public String getShortName() {
        return this.shortName;
    }

    private void setShortName(String shortName) {
        String old = this.shortName;
        this.shortName = shortName;
        if (this.attributeValueHasChanged(old, shortName)) {
            this.firePropertyChanged(SHORT_NAME_PROPERTY, old, shortName);
            this.qualifiedNameChanged();
        }
    }

    private void qualifiedNameChanged() {
        this.firePropertyChanged(QUALIFIED_NAME_PROPERTY, this.qualifiedName());
        this.getProject().nodeRenamed(this);
        Iterator stream = this.columns();
        while (stream.hasNext()) {
            ((MWColumn)stream.next()).qualifiedNameChanged();
        }
    }

    public Date getLastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    private void setLastRefreshTimestamp(Date lastRefreshTimestamp) {
        Date old = this.lastRefreshTimestamp;
        this.lastRefreshTimestamp = lastRefreshTimestamp;
        this.firePropertyChanged(LAST_REFRESH_TIMESTAMP_PROPERTY, old, lastRefreshTimestamp);
    }

    public Iterator columns() {
        return new CloneIterator(this.columns){

            protected void remove(Object current) {
                MWTable.this.removeColumn((MWColumn)current);
            }
        };
    }

    public int columnsSize() {
        return this.columns.size();
    }

    public MWColumn addColumn(String name) {
        this.checkColumnName(name);
        return this.addColumn(new MWColumn(this, name));
    }

    private MWColumn addColumn(MWColumn column) {
        this.addItemToCollection(column, this.columns, COLUMNS_COLLECTION);
        return column;
    }

    public void removeColumn(MWColumn column) {
        this.removeNodeFromCollection(column, this.columns, COLUMNS_COLLECTION);
    }

    public void removeColumns(Iterator cols) {
        while (cols.hasNext()) {
            this.removeColumn((MWColumn)cols.next());
        }
    }

    public void removeColumns(Collection cols) {
        this.removeColumns(cols.iterator());
    }

    public boolean containsColumnNamed(String columnName) {
        return this.columnNamed(columnName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWColumn columnNamed(String unqualifiedColumnName) {
        Collection collection = this.columns;
        synchronized (collection) {
            for (MWColumn column : this.columns) {
                if (!column.getName().equals(unqualifiedColumnName)) continue;
                return column;
            }
        }
        return null;
    }

    public MWColumn columnWithQualifiedName(String name) {
        if (!MWColumn.parseTableNameFromQualifiedName(name).equals(this.getName())) {
            throw new IllegalArgumentException();
        }
        return this.columnNamed(MWColumn.parseColumnNameFromQualifiedName(name));
    }

    public Iterator columnNames() {
        return new TransformationIterator(this.columns()){

            protected Object transform(Object next) {
                return ((MWColumn)next).getName();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int primaryKeyColumnsSize() {
        int size = 0;
        Collection collection = this.columns;
        synchronized (collection) {
            Iterator stream = this.columns.iterator();
            while (stream.hasNext()) {
                if (!((MWColumn)stream.next()).isPrimaryKey()) continue;
                ++size;
            }
        }
        return size;
    }

    public Iterator primaryKeyColumns() {
        return new FilteringIterator(this.columns()){

            protected boolean accept(Object o) {
                return ((MWColumn)o).isPrimaryKey();
            }
        };
    }

    public Iterator primaryKeyColumnNames() {
        return new TransformationIterator(this.primaryKeyColumns()){

            protected Object transform(Object next) {
                return ((MWColumn)next).getName();
            }
        };
    }

    public Iterator nonPrimaryKeyColumns() {
        return new FilteringIterator(this.columns()){

            protected boolean accept(Object o) {
                return !((MWColumn)o).isPrimaryKey();
            }
        };
    }

    public MWColumn addColumnLike(MWColumn original) {
        MWColumn copy = this.addColumn(original.getName());
        copy.copySettingsFrom(original);
        return copy;
    }

    public Iterator references() {
        return new CloneIterator(this.references){

            protected void remove(Object current) {
                MWTable.this.removeReference((MWReference)current);
            }
        };
    }

    public int referencesSize() {
        return this.references.size();
    }

    public MWReference addReference(String name, MWTable targetTable) {
        this.checkReferenceName(name);
        return this.addReference(new MWReference(this, name, targetTable));
    }

    private MWReference addReference(MWReference reference) {
        this.addItemToCollection(reference, this.references, REFERENCES_COLLECTION);
        return reference;
    }

    public void removeReference(MWReference reference) {
        this.removeNodeFromCollection(reference, this.references, REFERENCES_COLLECTION);
    }

    public void removeReferences(Iterator refs) {
        while (refs.hasNext()) {
            this.removeReference((MWReference)refs.next());
        }
    }

    public void removeReferences(Collection refs) {
        this.removeReferences(refs.iterator());
    }

    private void removeDatabaseReferences(Iterator refs) {
        while (refs.hasNext()) {
            MWReference ref = (MWReference)refs.next();
            if (!ref.isOnDatabase()) continue;
            this.removeReference(ref);
        }
    }

    private void removeDatabaseReferences(Collection refs) {
        this.removeDatabaseReferences(refs.iterator());
    }

    public boolean containsReferenceNamed(String referenceName) {
        return this.referenceNamed(referenceName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWReference referenceNamed(String referenceName) {
        Collection collection = this.references;
        synchronized (collection) {
            for (MWReference reference : this.references) {
                if (!reference.getName().equals(referenceName)) continue;
                return reference;
            }
            return null;
        }
    }

    public Iterator referenceNames() {
        return new TransformationIterator(this.references()){

            protected Object transform(Object next) {
                return ((MWReference)next).getName();
            }
        };
    }

    public Iterator databaseReferences() {
        return new FilteringIterator(this.references()){

            protected boolean accept(Object o) {
                return ((MWReference)o).isOnDatabase();
            }
        };
    }

    public Iterator referencesBetween(MWTable table) {
        return new CompositeIterator(this.referencesTo(table), table.referencesTo(this));
    }

    public Iterator referencesTo(final MWTable targetTable) {
        return new FilteringIterator(this.references()){

            protected boolean accept(Object o) {
                return ((MWReference)o).getTargetTable() == targetTable;
            }
        };
    }

    public String getName() {
        return this.qualifiedName();
    }

    public DatabasePlatform databasePlatform() {
        return this.getDatabase().getDatabasePlatform();
    }

    boolean nameMatches(String cat, String sch, String sn) {
        return this.valuesAreEqual(this.catalog, cat) && this.valuesAreEqual(this.schema, sch) && this.valuesAreEqual(this.shortName, sn);
    }

    boolean nameMatchesIgnoreCase(String cat, String sch, String sn) {
        return StringTools.stringsAreEqualIgnoreCase(this.catalog, cat) && StringTools.stringsAreEqualIgnoreCase(this.schema, sch) && StringTools.stringsAreEqualIgnoreCase(this.shortName, sn);
    }

    public boolean nameIsQualified() {
        if (this.catalog != null) {
            return true;
        }
        return this.schema != null;
    }

    public boolean nameIsUnqualified() {
        return !this.nameIsQualified();
    }

    public String qualifiedName() {
        return NameTools.buildQualifiedDatabaseObjectName(this.catalog, this.schema, this.shortName);
    }

    public String unqualifiedName() {
        return this.shortName;
    }

    private String qualifier() {
        if (this.nameIsUnqualified()) {
            return "";
        }
        StringBuffer sb = new StringBuffer(100);
        if (this.catalog != null) {
            sb.append(this.catalog);
        }
        if (this.schema != null) {
            if (this.catalog != null) {
                sb.append('.');
            }
            sb.append(this.schema);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Collection collection = this.columns;
        synchronized (collection) {
            children.addAll(this.columns);
        }
        collection = this.references;
        synchronized (collection) {
            children.addAll(this.references);
        }
    }

    public void rename(String newCatalog, String newSchema, String newShortName) {
        if (this.nameMatches(newCatalog, newSchema, newShortName)) {
            return;
        }
        this.getDatabase().checkTableName(newCatalog, newSchema, newShortName, this);
        this.setCatalog(newCatalog);
        this.setSchema(newSchema);
        this.setShortName(newShortName);
        this.getDatabase().tableRenamed();
    }

    void checkColumnName(String columnName) {
        if (columnName == null || columnName.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.containsColumnNamed(columnName)) {
            throw new IllegalArgumentException("duplicate column name: " + columnName);
        }
    }

    void checkReferenceName(String referenceName) {
        if (referenceName == null || referenceName.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.containsReferenceNamed(referenceName)) {
            throw new IllegalArgumentException("duplicate reference name: " + referenceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void databasePlatformChanged() {
        Collection collection = this.columns;
        synchronized (collection) {
            Iterator stream = this.columns.iterator();
            while (stream.hasNext()) {
                ((MWColumn)stream.next()).databasePlatformChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        int identityTypeCount = 0;
        Collection collection = this.columns;
        synchronized (collection) {
            for (MWColumn column : this.columns) {
                if (!column.isIdentity()) continue;
                ++identityTypeCount;
            }
        }
        if (identityTypeCount > 1) {
            currentProblems.add(this.buildProblem("0701"));
        }
    }

    public Iterator matchingExternalTableDescriptions() {
        return this.getDatabase().externalTableDescriptions(this.catalog, this.schema, this.shortName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshColumns(ExternalTable externalTable) {
        HashSet removedColumns;
        Collection collection = this.columns;
        synchronized (collection) {
            removedColumns = new HashSet(this.columns);
        }
        ExternalColumn[] externalColumns = externalTable.getColumns();
        int i = externalColumns.length;
        while (i-- > 0) {
            this.refreshColumn(externalColumns[i], removedColumns);
        }
        this.removeColumns(removedColumns);
        this.setLastRefreshTimestamp(new Date());
    }

    private void refreshColumn(ExternalColumn externalColumn, Collection removedColumns) {
        MWColumn existingColumn = this.columnNamed(externalColumn.getName());
        if (existingColumn == null) {
            existingColumn = this.addColumn(externalColumn.getName());
        } else {
            removedColumns.remove(existingColumn);
        }
        existingColumn.refresh(externalColumn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshReferences(ExternalTable externalTable) {
        HashSet removedReferences;
        Collection collection = this.references;
        synchronized (collection) {
            removedReferences = new HashSet(this.references);
        }
        ExternalForeignKey[] externalForeignKeys = externalTable.getForeignKeys();
        int i = externalForeignKeys.length;
        while (i-- > 0) {
            this.refreshReference(externalForeignKeys[i], removedReferences);
        }
        this.removeDatabaseReferences(removedReferences);
    }

    private void refreshReference(ExternalForeignKey externalForeignKey, Collection removedReferences) {
        ExternalTableDescription ttd = externalForeignKey.getTargetTableDescription();
        MWTable targetTable = this.getDatabase().tableNamed(ttd.getCatalogName(), ttd.getSchemaName(), ttd.getName());
        if (targetTable == null) {
            targetTable = this.getDatabase().tableNamed(null, null, ttd.getName());
        }
        if (targetTable == null) {
            return;
        }
        for (MWReference ref : removedReferences) {
            if (!ref.getName().equals(externalForeignKey.getName())) continue;
            ref.setTargetTable(targetTable);
            ref.refreshColumnPairs(externalForeignKey);
            ref.setOnDatabase(true);
            removedReferences.remove(ref);
            return;
        }
        for (MWReference ref : removedReferences) {
            if (!ref.matchesColumnPairs(externalForeignKey)) continue;
            ref.setName(externalForeignKey.getName());
            ref.setTargetTable(targetTable);
            ref.setOnDatabase(true);
            removedReferences.remove(ref);
            return;
        }
        MWReference ref = this.addReference(externalForeignKey.getName(), targetTable);
        ExternalForeignKeyColumnPair[] pairs = externalForeignKey.getColumnPairs();
        int i = pairs.length;
        while (i-- > 0) {
            ref.addColumnPair(this.column(pairs[i].getSourceColumn()), targetTable.column(pairs[i].getTargetColumn()));
        }
        ref.setOnDatabase(true);
    }

    MWColumn column(ExternalColumn externalColumn) {
        return externalColumn == null ? null : this.columnNamed(externalColumn.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TableDefinition buildRuntimeTableDefinition() {
        TableDefinition td = new TableDefinition();
        td.setName(this.shortName);
        td.setQualifier(this.qualifier());
        Collection collection = this.columns;
        synchronized (collection) {
            Iterator stream = this.columns.iterator();
            while (stream.hasNext()) {
                td.addField(((MWColumn)stream.next()).buildRuntimeFieldDefinition());
            }
        }
        collection = this.references;
        synchronized (collection) {
            for (MWReference ref : this.references) {
                if (!ref.isOnDatabase()) continue;
                td.addForeignKeyConstraint(ref.buildRuntimeConstraint());
            }
        }
        return td;
    }

    public void toString(StringBuffer sb) {
        sb.append(this.qualifiedName());
    }

    public String displayString() {
        return this.qualifiedName();
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWTable.class);
        descriptor.setDefaultRootElement("table");
        descriptor.addDirectMapping(CATALOG_PROPERTY, "catalog/text()");
        descriptor.addDirectMapping(SCHEMA_PROPERTY, "schema/text()");
        descriptor.addDirectMapping(SHORT_NAME_PROPERTY, "short-name/text()");
        descriptor.addDirectMapping(LAST_REFRESH_TIMESTAMP_PROPERTY, "last-refresh-timestamp/text()");
        XMLCompositeCollectionMapping columnsMapping = new XMLCompositeCollectionMapping();
        columnsMapping.setAttributeName(COLUMNS_COLLECTION);
        columnsMapping.setGetMethodName("getColumnsForTopLink");
        columnsMapping.setSetMethodName("setColumnsForTopLink");
        columnsMapping.setReferenceClass(MWColumn.class);
        columnsMapping.setXPath("columns/column");
        descriptor.addMapping((DatabaseMapping)columnsMapping);
        XMLCompositeCollectionMapping referencesMapping = new XMLCompositeCollectionMapping();
        referencesMapping.setAttributeName(REFERENCES_COLLECTION);
        referencesMapping.setGetMethodName("getReferencesForTopLink");
        referencesMapping.setSetMethodName("setReferencesForTopLink");
        referencesMapping.setReferenceClass(MWReference.class);
        referencesMapping.setXPath("references/table-association");
        descriptor.addMapping((DatabaseMapping)referencesMapping);
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getColumnsForTopLink() {
        Collection collection = this.columns;
        synchronized (collection) {
            return new TreeSet(this.columns);
        }
    }

    private void setColumnsForTopLink(Collection columns) {
        this.columns = columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getReferencesForTopLink() {
        Collection collection = this.references;
        synchronized (collection) {
            return new TreeSet(this.references);
        }
    }

    private void setReferencesForTopLink(Collection references) {
        this.references = references;
    }
}

